/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.ShapeType;

public class GeometryCollection<G extends Geometry>
implements Geometry,
Iterable<G> {
    public static final GeometryCollection<Geometry> EMPTY = new GeometryCollection();
    private final List<G> shapes;

    public GeometryCollection() {
        this.shapes = Collections.emptyList();
    }

    public GeometryCollection(List<G> shapes) {
        if (shapes == null || shapes.isEmpty()) {
            throw new IllegalArgumentException("the list of shapes cannot be null or empty");
        }
        this.shapes = shapes;
    }

    @Override
    public ShapeType type() {
        return ShapeType.GEOMETRYCOLLECTION;
    }

    @Override
    public <T> T visit(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    public int size() {
        return this.shapes.size();
    }

    public G get(int i) {
        return (G)((Geometry)this.shapes.get(i));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryCollection that = (GeometryCollection)o;
        return Objects.equals(this.shapes, that.shapes);
    }

    public int hashCode() {
        return Objects.hash(this.shapes);
    }

    @Override
    public Iterator<G> iterator() {
        return this.shapes.iterator();
    }
}

