/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.logconsole;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.logconsole.ILogConsole;
import org.eclipse.dltk.logconsole.LogConsoleType;
import org.eclipse.dltk.logconsole.impl.ILogConsoleFactory;

public class LogConsoleFactoryManager {
    private static LogConsoleFactoryManager manager = null;
    private List<FactoryDescriptor> descriptors = null;

    public static synchronized LogConsoleFactoryManager getInstance() {
        if (manager == null) {
            manager = new LogConsoleFactoryManager();
        }
        return manager;
    }

    public synchronized List<FactoryDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList<FactoryDescriptor>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.logconsole");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("factory".equals(element.getName())) {
                    this.descriptors.add(new FactoryDescriptor(element));
                }
                ++n2;
            }
        }
        return this.descriptors;
    }

    public ILogConsole create(LogConsoleType consoleType, Object identifier) {
        for (FactoryDescriptor descriptor : this.getDescriptors()) {
            ILogConsole console;
            ILogConsoleFactory factory;
            String type = descriptor.getConsoleType();
            if (type != null && !type.equals(consoleType) || (factory = descriptor.getFactory()) == null || (console = factory.create(consoleType, identifier)) == null) continue;
            return console;
        }
        return null;
    }

    static class FactoryDescriptor {
        final IConfigurationElement element;
        ILogConsoleFactory factory;
        boolean failure;

        public FactoryDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        String getConsoleType() {
            return this.element.getAttribute("consoleType");
        }

        ILogConsoleFactory getFactory() {
            if (this.failure) {
                return null;
            }
            if (this.factory != null) {
                return this.factory;
            }
            try {
                this.factory = (ILogConsoleFactory)this.element.createExecutableExtension("class");
                return this.factory;
            }
            catch (Exception e) {
                this.failure = true;
                this.factory = null;
                return null;
            }
        }
    }
}

