/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.wst.jsdt.jsdoc.Util;

public class ElementInfo {
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PROPERTY = 3;
    public static final int EVENT = 4;
    public static final int COLLECTION = 5;
    protected String name;
    protected String baseUrl;
    protected ElementInfo parent;
    protected ElementInfo[] children;
    protected int type = -5;
    protected static ArrayList nodes;
    protected boolean visited = false;
    protected static int instances;
    protected static boolean DEBUG;
    protected static boolean useCache;
    protected static boolean keepCache;

    static {
        instances = 0;
        DEBUG = false;
    }

    public boolean shouldUseCache() {
        return useCache;
    }

    public boolean shouldKeepCache() {
        return keepCache;
    }

    public static void setUseCache(boolean shouldUseCache) {
        useCache = shouldUseCache;
    }

    public static void setKeepCache(boolean shouldKeepCache) {
        keepCache = shouldKeepCache;
    }

    public boolean visit() {
        boolean ov = this.visited;
        this.visited = true;
        return ov;
    }

    public boolean equals(Object o) {
        try {
            ElementInfo other = (ElementInfo)o;
            boolean equal = other.getUrl().trim().equalsIgnoreCase(this.getUrl().trim());
            return equal;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void freeObject(ElementInfo element) {
        int i = 0;
        while (i < nodes.size()) {
            ElementInfo temp = (ElementInfo)nodes.get(i);
            if (temp.getUrl().equalsIgnoreCase(element.getUrl())) {
                nodes.remove(i);
                break;
            }
            ++i;
        }
    }

    public ElementInfo[] getFoundObjects() {
        ArrayList<ElementInfo> found = new ArrayList<ElementInfo>();
        ElementInfo[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getType() == 5 || children[i].getType() == 4) {
                children[i].clearVisit();
                found.add(children[i]);
            }
            ++i;
        }
        return found.toArray(new ElementInfo[found.size()]);
    }

    public void clearVisit() {
        this.visited = false;
    }

    public ElementInfo(String baseUrl, ElementInfo parent) {
        nodes = new ArrayList();
        this.baseUrl = baseUrl;
        this.parent = parent;
        if (DEBUG) {
            System.out.println("Creating new instance for total of : " + ++instances);
        }
    }

    public void finalize() {
        if (DEBUG) {
            System.out.println("Destroying instance for total of : " + --instances);
        }
    }

    public void addNode(ElementInfo element) {
        nodes.add(element);
    }

    public static ElementInfo findChild(String baseUrl) {
        int i = 0;
        while (i < nodes.size()) {
            ElementInfo temp = (ElementInfo)nodes.get(i);
            if (temp.getUrl().equalsIgnoreCase(baseUrl)) {
                return temp;
            }
            ++i;
        }
        return null;
    }

    public boolean isDefined(String baseUrl) {
        return ElementInfo.findChild(baseUrl) != null;
    }

    public ElementInfo getParent() {
        return this.parent;
    }

    public ElementInfo[] getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.baseUrl;
    }

    public String getJsDoc(String parentName) {
        return null;
    }

    public String getJsStructure() {
        return null;
    }

    public String getTypeName() {
        switch (this.getType()) {
            case 3: {
                return "Property";
            }
            case 2: {
                return "Method";
            }
            case 1: {
                return "Class";
            }
        }
        return "Unknown Type";
    }

    public int getType() {
        return -1;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("name : " + this.getName() + Util.NEW_LINE);
        buff.append("Type : " + this.getTypeName() + "Util.NEW_LINE");
        if (this.getParent() != null) {
            buff.append("\tParent Name : " + this.getParent().getName() + Util.NEW_LINE);
            buff.append("\tParent Type : " + this.getParent().getTypeName() + Util.NEW_LINE);
        } else {
            buff.append("No Parent" + Util.NEW_LINE);
        }
        buff.append("baseUrl : " + this.baseUrl + Util.NEW_LINE);
        buff.append("----------------Children--------------" + Util.NEW_LINE + "Name\t\t\t\tType" + Util.NEW_LINE);
        if (this.hasChildren()) {
            ElementInfo[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                buff.append(String.valueOf(children[i].getName()) + "\t\t\t" + children[i].getTypeName() + Util.NEW_LINE);
                ++i;
            }
        } else {
            buff.append(String.valueOf(Util.NEW_LINE) + "No Children" + Util.NEW_LINE);
        }
        buff.append("--------------------------------------");
        return buff.toString();
    }

    protected String getPageText() {
        try {
            return Util.retrieveFromUrl(this.getUrl(), this.shouldUseCache(), !this.shouldKeepCache());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getBaseUrl() {
        return Util.getBaseUrl(this.getUrl());
    }

    public String getDeclarationString() {
        return null;
    }

    public String getJsStructure(String parent) {
        return "NOT DEFINED " + parent;
    }

    public boolean isStatic() {
        return false;
    }
}

