/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PDOMCache {
    private Map<File, PDOM> path2pdom = new HashMap<File, PDOM>();
    private static PDOMCache singleton;
    private static Object singletonMutex;

    static {
        singletonMutex = new Object();
    }

    private PDOMCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDOMCache getInstance() {
        Object object = singletonMutex;
        synchronized (object) {
            if (singleton == null) {
                singleton = new PDOMCache();
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDOM getPDOM(IPath path, IIndexLocationConverter converter) {
        if (path == null) {
            return null;
        }
        PDOM result = null;
        File file = path.toFile();
        Map<File, PDOM> map = this.path2pdom;
        synchronized (map) {
            if (this.path2pdom.containsKey(file)) {
                result = this.path2pdom.get(file);
            }
            if (result == null) {
                try {
                    result = new PDOM(file, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                    this.path2pdom.put(file, result);
                }
                catch (CoreException ce) {
                    CCorePlugin.log(ce);
                }
            }
        }
        return result;
    }
}

