/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.internal.AbstractJavaResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ParamValueFactoryWithSource;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

class JavaResourceMethodDispatcherProvider
implements ResourceMethodDispatcher.Provider {
    @Inject
    private ServiceLocator serviceLocator;

    JavaResourceMethodDispatcherProvider() {
    }

    @Override
    public ResourceMethodDispatcher create(Invocable resourceMethod, InvocationHandler invocationHandler, ConfiguredValidator validator) {
        List<ParamValueFactoryWithSource<?>> valueProviders = ParameterValueHelper.createValueProviders(this.serviceLocator, resourceMethod);
        Class<?> returnType = resourceMethod.getHandlingMethod().getReturnType();
        AbstractMethodParamInvoker resourceMethodDispatcher = Response.class.isAssignableFrom(returnType) ? new ResponseOutInvoker(resourceMethod, invocationHandler, valueProviders, validator) : (returnType != Void.TYPE ? (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType) ? new ObjectOutInvoker(resourceMethod, invocationHandler, valueProviders, validator) : new TypeOutInvoker(resourceMethod, invocationHandler, valueProviders, validator)) : new VoidOutInvoker(resourceMethod, invocationHandler, valueProviders, validator));
        this.serviceLocator.inject((Object)resourceMethodDispatcher);
        return resourceMethodDispatcher;
    }

    final ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    private static abstract class AbstractMethodParamInvoker
    extends AbstractJavaResourceMethodDispatcher {
        private final List<ParamValueFactoryWithSource<?>> valueProviders;

        public AbstractMethodParamInvoker(Invocable resourceMethod, InvocationHandler handler, List<ParamValueFactoryWithSource<?>> valueProviders, ConfiguredValidator validator) {
            super(resourceMethod, handler, validator);
            this.valueProviders = valueProviders;
        }

        final Object[] getParamValues() {
            return ParameterValueHelper.getParameterValues(this.valueProviders);
        }
    }

    private static final class ObjectOutInvoker
    extends AbstractMethodParamInvoker {
        public ObjectOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<ParamValueFactoryWithSource<?>> valueProviders, ConfiguredValidator validator) {
            super(resourceMethod, handler, valueProviders, validator);
        }

        @Override
        protected Response doDispatch(Object resource, ContainerRequest containerRequest) throws ProcessingException {
            Object o = this.invoke(containerRequest, resource, this.getParamValues());
            if (o instanceof Response) {
                return (Response)Response.class.cast(o);
            }
            if (o != null) {
                return Response.ok().entity(o).build();
            }
            return Response.noContent().build();
        }
    }

    private static final class ResponseOutInvoker
    extends AbstractMethodParamInvoker {
        public ResponseOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<ParamValueFactoryWithSource<?>> valueProviders, ConfiguredValidator validator) {
            super(resourceMethod, handler, valueProviders, validator);
        }

        @Override
        protected Response doDispatch(Object resource, ContainerRequest containerRequest) throws ProcessingException {
            return (Response)Response.class.cast(this.invoke(containerRequest, resource, this.getParamValues()));
        }
    }

    private static final class TypeOutInvoker
    extends AbstractMethodParamInvoker {
        private final Type t;

        public TypeOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<ParamValueFactoryWithSource<?>> valueProviders, ConfiguredValidator validator) {
            super(resourceMethod, handler, valueProviders, validator);
            this.t = resourceMethod.getHandlingMethod().getGenericReturnType();
        }

        @Override
        protected Response doDispatch(Object resource, ContainerRequest containerRequest) throws ProcessingException {
            Object o = this.invoke(containerRequest, resource, this.getParamValues());
            if (o != null) {
                Response response = Response.ok().entity(o).build();
                return response;
            }
            return Response.noContent().build();
        }
    }

    private static final class VoidOutInvoker
    extends AbstractMethodParamInvoker {
        public VoidOutInvoker(Invocable resourceMethod, InvocationHandler handler, List<ParamValueFactoryWithSource<?>> valueProviders, ConfiguredValidator validator) {
            super(resourceMethod, handler, valueProviders, validator);
        }

        @Override
        protected Response doDispatch(Object resource, ContainerRequest containerRequest) throws ProcessingException {
            this.invoke(containerRequest, resource, this.getParamValues());
            return Response.noContent().build();
        }
    }
}

