/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;

public interface ITimeGraphDataProvider<M extends ITimeGraphEntryModel>
extends ITmfTreeDataProvider<M>,
ITimeGraphStateFilter {
    @Deprecated
    public TmfModelResponse<List<ITimeGraphRowModel>> fetchRowModel(SelectionTimeQueryFilter var1, @Nullable IProgressMonitor var2);

    default public TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter != null) {
            TmfModelResponse<List<ITimeGraphRowModel>> response = this.fetchRowModel(filter, monitor);
            List<ITimeGraphRowModel> rows = response.getModel();
            if (rows != null) {
                return new TmfModelResponse<TimeGraphModel>(new TimeGraphModel(rows), response.getStatus(), response.getStatusMessage());
            }
            return new TmfModelResponse<Object>(null, response.getStatus(), response.getStatusMessage());
        }
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter var1, @Nullable IProgressMonitor var2);

    default public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter != null) {
            return this.fetchArrows(filter, monitor);
        }
        return new TmfModelResponse<List<ITimeGraphArrow>>(Collections.emptyList(), ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
    }

    @Deprecated
    public TmfModelResponse<Map<String, String>> fetchTooltip(SelectionTimeQueryFilter var1, @Nullable IProgressMonitor var2);

    default public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter != null) {
            return this.fetchTooltip(filter, monitor);
        }
        return new TmfModelResponse<Map<String, String>>(Collections.emptyMap(), ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
    }
}

