/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SSHImplementationJsch
extends SSHImplementationAbstract {
    private static final Log log = Log.getLog(SSHImplementationJsch.class);
    private static transient JSch jsch;
    private volatile transient Session session;

    protected void setupTunnel(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, String dbHost, String sshHost, String aliveInterval, int sshPortNum, File privKeyFile, int connectTimeout, int dbPort, int localPort) throws DBException, IOException {
        try {
            if (jsch == null) {
                jsch = new JSch();
                JSch.setLogger((Logger)new LoggerProxy());
            }
            if (privKeyFile != null) {
                if (!CommonUtils.isEmpty((String)configuration.getPassword())) {
                    jsch.addIdentity(privKeyFile.getAbsolutePath(), configuration.getPassword());
                } else {
                    jsch.addIdentity(privKeyFile.getAbsolutePath());
                }
            }
            log.debug((Object)"Instantiate SSH tunnel");
            this.session = jsch.getSession(configuration.getUserName(), sshHost, sshPortNum);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setConfig("PreferredAuthentications", privKeyFile != null ? "publickey,keyboard-interactive" : "password,keyboard-interactive");
            this.session.setConfig("ConnectTimeout", String.valueOf(connectTimeout));
            UserInfoCustom ui = new UserInfoCustom(configuration);
            this.session.setUserInfo((UserInfo)ui);
            if (!CommonUtils.isEmpty((String)aliveInterval)) {
                this.session.setServerAliveInterval(Integer.parseInt(aliveInterval));
            }
            log.debug((Object)"Connect to tunnel host");
            this.session.connect(connectTimeout);
            try {
                this.session.setPortForwardingL(localPort, dbHost, dbPort);
            }
            catch (JSchException e) {
                this.closeTunnel(monitor);
                throw e;
            }
        }
        catch (JSchException e) {
            throw new DBException("Cannot establish tunnel", (Throwable)e);
        }
    }

    public void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.session != null) {
            RuntimeUtils.runTask(monitor1 -> {
                if (this.session != null) {
                    try {
                        this.session.disconnect();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, (String)"Close SSH session", (long)1000L);
            this.session = null;
        }
    }

    public String getClientVersion() {
        return this.session == null ? null : this.session.getClientVersion();
    }

    public String getServerVersion() {
        return this.session == null ? null : this.session.getServerVersion();
    }

    public void invalidateTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        boolean isAlive = false;
        if (isAlive) {
            try {
                this.session.sendKeepAliveMsg();
            }
            catch (Exception exception) {
                isAlive = false;
            }
        }
        if (!isAlive) {
            this.closeTunnel(monitor);
            this.initTunnel(monitor, null, this.savedConfiguration, this.savedConnectionInfo);
        }
    }

    private class LoggerProxy
    implements Logger {
        private LoggerProxy() {
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            String levelStr;
            switch (level) {
                case 1: {
                    levelStr = "INFO";
                    break;
                }
                case 2: {
                    levelStr = "WARN";
                    break;
                }
                case 3: {
                    levelStr = "ERROR";
                    break;
                }
                case 4: {
                    levelStr = "FATAL";
                    break;
                }
                default: {
                    levelStr = "DEBUG";
                }
            }
            log.debug((Object)("SSH " + levelStr + ": " + message));
        }
    }

    private class UIUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        DBWHandlerConfiguration configuration;

        private UIUserInfo(DBWHandlerConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getPassphrase() {
            return this.configuration.getPassword();
        }

        public String getPassword() {
            return this.configuration.getPassword();
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
            log.info((Object)message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            System.out.printf("Keyboard interactive auth", new Object[0]);
            return new String[]{this.configuration.getPassword()};
        }
    }

    private class UserInfoCustom
    extends UserInfoPrompter {
        private final DBWHandlerConfiguration configuration;

        UserInfoCustom(DBWHandlerConfiguration configuration) {
            super(SSHImplementationJsch.this.session);
            this.configuration = configuration;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.configuration.isSavePassword()) {
                this.setPassword(this.configuration.getPassword());
            }
            return super.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public boolean promptPassword(String message) {
            if (this.configuration.isSavePassword()) {
                this.setPassword(this.configuration.getPassword());
                return true;
            }
            return super.promptPassword(message);
        }

        public boolean promptPassphrase(String message) {
            if (this.configuration.isSavePassword()) {
                this.setPassphrase(this.configuration.getPassword());
                return true;
            }
            return super.promptPassphrase(message);
        }

        public void showMessage(String message) {
            log.debug((Object)"SSH server message:");
            log.debug((Object)message);
        }
    }
}

