/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class ExasolPrimaryKeyManager
extends SQLConstraintManager<ExasolTableUniqueKey, ExasolTable>
implements DBEObjectRenamer<ExasolTableUniqueKey> {
    public DBSObjectCache<? extends DBSObject, ExasolTableUniqueKey> getObjectsCache(ExasolTableUniqueKey object) {
        return object.getTable().getSchema().getConstraintCache();
    }

    protected ExasolTableUniqueKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final ExasolTable parent, Object copyFrom) throws DBException {
        return (ExasolTableUniqueKey)((Object)new UITask<ExasolTableUniqueKey>(){

            protected ExasolTableUniqueKey runTask() {
                EditConstraintPage editPage = new EditConstraintPage(ExasolMessages.edit_exasol_constraint_manager_dialog_title, (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY}, Boolean.valueOf(true));
                if (!editPage.edit()) {
                    return null;
                }
                ExasolTableUniqueKey constraint = new ExasolTableUniqueKey(parent, editPage.getConstraintType(), editPage.isEnableConstraint(), editPage.getConstraintName());
                ArrayList<ExasolTableKeyColumn> constColumns = new ArrayList<ExasolTableKeyColumn>();
                int ordinalPosition = 0;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    ExasolTableKeyColumn col;
                    try {
                        col = new ExasolTableKeyColumn((AbstractTableConstraint<ExasolTable>)constraint, parent.getAttribute(monitor, tableColumn.getName()), ++ordinalPosition);
                    }
                    catch (DBException dBException) {
                        log.error((Object)("Could not find column " + tableColumn.getName() + " in table " + parent.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        return null;
                    }
                    constColumns.add(col);
                }
                constraint.setColumns(constColumns);
                return constraint;
            }
        }.execute());
    }

    protected String getDropConstraintPattern(ExasolTableUniqueKey constraint) {
        return "ALTER TABLE " + constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP PRIMARY KEY";
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolTableUniqueKey obj = (ExasolTableUniqueKey)command.getObject();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create PK", ExasolUtils.getPKDdl(obj, monitor)));
        }
        catch (DBException dBException) {
            log.error((Object)"Could not generated DDL for PK");
        }
    }

    public void renameObject(DBECommandContext commandContext, ExasolTableUniqueKey object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolTableUniqueKey constraint = (ExasolTableUniqueKey)command.getObject();
        if (command.getProperties().containsKey("enabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter PK", "ALTER TABLE " + constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY CONSTRAINT " + constraint.getName() + " " + (constraint.getEnabled() != false ? "ENABLE" : "DISABLE")));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolTableUniqueKey key = (ExasolTableUniqueKey)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename PK", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)key.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getNewName())));
    }
}

