/*
 * Copyright © 2012 - 2014 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef __OCL_MATH_H__
#define __OCL_MATH_H__

#include "ocl_types.h"
#include "ocl_math_common.h"


OVERLOADABLE float lgamma_r(float x, global int *signgamp);
OVERLOADABLE float lgamma_r(float x, local int *signgamp);
OVERLOADABLE float lgamma_r(float x, private int *signgamp);
OVERLOADABLE float sincos(float x, global float *cosval);
OVERLOADABLE float sincos(float x, local float *cosval);
OVERLOADABLE float sincos(float x, private float *cosval);
OVERLOADABLE float frexp(float x, global int *exp);
OVERLOADABLE float frexp(float x, local int *exp);
OVERLOADABLE float frexp(float x, private int *exp);
OVERLOADABLE float modf(float x, global float *i);
OVERLOADABLE float modf(float x, local float *i);
OVERLOADABLE float modf(float x, private float *i);
OVERLOADABLE float fract(float x, global float *p);
OVERLOADABLE float fract(float x, local float *p);
OVERLOADABLE float fract(float x, private float *p);
OVERLOADABLE float remquo(float x, float y, global int *quo);
OVERLOADABLE float remquo(float x, float y, local int *quo);
OVERLOADABLE float remquo(float x, float y, private int *quo);


OVERLOADABLE half lgamma_r(half x, global int *signgamp);
OVERLOADABLE half lgamma_r(half x, local int *signgamp);
OVERLOADABLE half lgamma_r(half x, private int *signgamp);
OVERLOADABLE half sincos(half x, global half *cosval);
OVERLOADABLE half sincos(half x, local half *cosval);
OVERLOADABLE half sincos(half x, private half *cosval);
OVERLOADABLE half frexp(half x, global int *exp);
OVERLOADABLE half frexp(half x, local int *exp);
OVERLOADABLE half frexp(half x, private int *exp);
OVERLOADABLE half modf(half x, global half *i);
OVERLOADABLE half modf(half x, local half *i);
OVERLOADABLE half modf(half x, private half *i);
OVERLOADABLE half fract(half x, global half *p);
OVERLOADABLE half fract(half x, local half *p);
OVERLOADABLE half fract(half x, private half *p);
OVERLOADABLE half remquo(half x, half y, global int *quo);
OVERLOADABLE half remquo(half x, half y, local int *quo);
OVERLOADABLE half remquo(half x, half y, private int *quo);



//------- double -----------
OVERLOADABLE double fract(double x, global double *p);
OVERLOADABLE double fract(double x, local double *p);
OVERLOADABLE double fract(double x, private double *p);
OVERLOADABLE double frexp(double x, global int *exp);
OVERLOADABLE double frexp(double x, local int *exp);
OVERLOADABLE double frexp(double x, private int *exp);
OVERLOADABLE double lgamma_r(double x, global int *signgamp);
OVERLOADABLE double lgamma_r(double x, local int *signgamp);
OVERLOADABLE double lgamma_r(double x, private int *signgamp);
OVERLOADABLE double modf(double x, global double *i);
OVERLOADABLE double modf(double x, local double *i);
OVERLOADABLE double modf(double x, private double *i);
OVERLOADABLE double remquo(double x, double y, global int *quo);
OVERLOADABLE double remquo(double x, double y, local int *quo);
OVERLOADABLE double remquo(double x, double y, private int *quo);
OVERLOADABLE double sincos(double x, global double *cosval);
OVERLOADABLE double sincos(double x, local double *cosval);
OVERLOADABLE double sincos(double x, private double *cosval);


//Begin from this part is autogenerated.
//Don't modify it manually.
//math builtin functions
//gentype fract (gentype x, __global gentype *iptr)

OVERLOADABLE float2 fract (float2 param0, __global float2 *param1);
OVERLOADABLE float3 fract (float3 param0, __global float3 *param1);
OVERLOADABLE float4 fract (float4 param0, __global float4 *param1);
OVERLOADABLE float8 fract (float8 param0, __global float8 *param1);
OVERLOADABLE float16 fract (float16 param0, __global float16 *param1);
OVERLOADABLE double2 fract (double2 param0, __global double2 *param1);
OVERLOADABLE double3 fract (double3 param0, __global double3 *param1);
OVERLOADABLE double4 fract (double4 param0, __global double4 *param1);
OVERLOADABLE double8 fract (double8 param0, __global double8 *param1);
OVERLOADABLE double16 fract (double16 param0, __global double16 *param1);
OVERLOADABLE half2 fract (half2 param0, __global half2 *param1);
OVERLOADABLE half3 fract (half3 param0, __global half3 *param1);
OVERLOADABLE half4 fract (half4 param0, __global half4 *param1);
OVERLOADABLE half8 fract (half8 param0, __global half8 *param1);
OVERLOADABLE half16 fract (half16 param0, __global half16 *param1);

//gentype fract (gentype x, __local gentype *iptr)

OVERLOADABLE float2 fract (float2 param0, __local float2 *param1);
OVERLOADABLE float3 fract (float3 param0, __local float3 *param1);
OVERLOADABLE float4 fract (float4 param0, __local float4 *param1);
OVERLOADABLE float8 fract (float8 param0, __local float8 *param1);
OVERLOADABLE float16 fract (float16 param0, __local float16 *param1);
OVERLOADABLE double2 fract (double2 param0, __local double2 *param1);
OVERLOADABLE double3 fract (double3 param0, __local double3 *param1);
OVERLOADABLE double4 fract (double4 param0, __local double4 *param1);
OVERLOADABLE double8 fract (double8 param0, __local double8 *param1);
OVERLOADABLE double16 fract (double16 param0, __local double16 *param1);
OVERLOADABLE half2 fract (half2 param0, __local half2 *param1);
OVERLOADABLE half3 fract (half3 param0, __local half3 *param1);
OVERLOADABLE half4 fract (half4 param0, __local half4 *param1);
OVERLOADABLE half8 fract (half8 param0, __local half8 *param1);
OVERLOADABLE half16 fract (half16 param0, __local half16 *param1);

//gentype fract (gentype x, __private gentype *iptr)

OVERLOADABLE float2 fract (float2 param0, __private float2 *param1);
OVERLOADABLE float3 fract (float3 param0, __private float3 *param1);
OVERLOADABLE float4 fract (float4 param0, __private float4 *param1);
OVERLOADABLE float8 fract (float8 param0, __private float8 *param1);
OVERLOADABLE float16 fract (float16 param0, __private float16 *param1);
OVERLOADABLE double2 fract (double2 param0, __private double2 *param1);
OVERLOADABLE double3 fract (double3 param0, __private double3 *param1);
OVERLOADABLE double4 fract (double4 param0, __private double4 *param1);
OVERLOADABLE double8 fract (double8 param0, __private double8 *param1);
OVERLOADABLE double16 fract (double16 param0, __private double16 *param1);
OVERLOADABLE half2 fract (half2 param0, __private half2 *param1);
OVERLOADABLE half3 fract (half3 param0, __private half3 *param1);
OVERLOADABLE half4 fract (half4 param0, __private half4 *param1);
OVERLOADABLE half8 fract (half8 param0, __private half8 *param1);
OVERLOADABLE half16 fract (half16 param0, __private half16 *param1);

//floatn frexp (floatn x, __global intn *exp)

OVERLOADABLE float2 frexp (float2 param0, __global int2 *param1);
OVERLOADABLE float3 frexp (float3 param0, __global int3 *param1);
OVERLOADABLE float4 frexp (float4 param0, __global int4 *param1);
OVERLOADABLE float8 frexp (float8 param0, __global int8 *param1);
OVERLOADABLE float16 frexp (float16 param0, __global int16 *param1);

//floatn frexp (floatn x, __local intn *exp)

OVERLOADABLE float2 frexp (float2 param0, __local int2 *param1);
OVERLOADABLE float3 frexp (float3 param0, __local int3 *param1);
OVERLOADABLE float4 frexp (float4 param0, __local int4 *param1);
OVERLOADABLE float8 frexp (float8 param0, __local int8 *param1);
OVERLOADABLE float16 frexp (float16 param0, __local int16 *param1);

//floatn frexp (floatn x, __private intn *exp)

OVERLOADABLE float2 frexp (float2 param0, __private int2 *param1);
OVERLOADABLE float3 frexp (float3 param0, __private int3 *param1);
OVERLOADABLE float4 frexp (float4 param0, __private int4 *param1);
OVERLOADABLE float8 frexp (float8 param0, __private int8 *param1);
OVERLOADABLE float16 frexp (float16 param0, __private int16 *param1);

//float frexp (float x, __global int *exp)


//float frexp (float x, __local int *exp)


//float frexp (float x, __private int *exp)


//halfn frexp (halfn x, __global intn *exp)

OVERLOADABLE half2 frexp (half2 param0, __global int2 *param1);
OVERLOADABLE half3 frexp (half3 param0, __global int3 *param1);
OVERLOADABLE half4 frexp (half4 param0, __global int4 *param1);
OVERLOADABLE half8 frexp (half8 param0, __global int8 *param1);
OVERLOADABLE half16 frexp (half16 param0, __global int16 *param1);

//halfn frexp (halfn x, __local intn *exp)

OVERLOADABLE half2 frexp (half2 param0, __local int2 *param1);
OVERLOADABLE half3 frexp (half3 param0, __local int3 *param1);
OVERLOADABLE half4 frexp (half4 param0, __local int4 *param1);
OVERLOADABLE half8 frexp (half8 param0, __local int8 *param1);
OVERLOADABLE half16 frexp (half16 param0, __local int16 *param1);

//halfn frexp (halfn x, __private intn *exp)

OVERLOADABLE half2 frexp (half2 param0, __private int2 *param1);
OVERLOADABLE half3 frexp (half3 param0, __private int3 *param1);
OVERLOADABLE half4 frexp (half4 param0, __private int4 *param1);
OVERLOADABLE half8 frexp (half8 param0, __private int8 *param1);
OVERLOADABLE half16 frexp (half16 param0, __private int16 *param1);

//half frexp (half x, __global int *exp)


//half frexp (half x, __local int *exp)


//half frexp (half x, __private int *exp)


//doublen frexp (doublen x, __global intn *exp)

OVERLOADABLE double2 frexp (double2 param0, __global int2 *param1);
OVERLOADABLE double3 frexp (double3 param0, __global int3 *param1);
OVERLOADABLE double4 frexp (double4 param0, __global int4 *param1);
OVERLOADABLE double8 frexp (double8 param0, __global int8 *param1);
OVERLOADABLE double16 frexp (double16 param0, __global int16 *param1);

//doublen frexp (doublen x, __local intn *exp)

OVERLOADABLE double2 frexp (double2 param0, __local int2 *param1);
OVERLOADABLE double3 frexp (double3 param0, __local int3 *param1);
OVERLOADABLE double4 frexp (double4 param0, __local int4 *param1);
OVERLOADABLE double8 frexp (double8 param0, __local int8 *param1);
OVERLOADABLE double16 frexp (double16 param0, __local int16 *param1);

//doublen frexp (doublen x, __private intn *exp)

OVERLOADABLE double2 frexp (double2 param0, __private int2 *param1);
OVERLOADABLE double3 frexp (double3 param0, __private int3 *param1);
OVERLOADABLE double4 frexp (double4 param0, __private int4 *param1);
OVERLOADABLE double8 frexp (double8 param0, __private int8 *param1);
OVERLOADABLE double16 frexp (double16 param0, __private int16 *param1);

//double frexp (double x, __global int *exp)


//double frexp (double x, __local int *exp)


//double frexp (double x, __private int *exp)


//floatn lgamma_r (floatn x, __global intn *signp)

OVERLOADABLE float2 lgamma_r (float2 param0, __global int2 *param1);
OVERLOADABLE float3 lgamma_r (float3 param0, __global int3 *param1);
OVERLOADABLE float4 lgamma_r (float4 param0, __global int4 *param1);
OVERLOADABLE float8 lgamma_r (float8 param0, __global int8 *param1);
OVERLOADABLE float16 lgamma_r (float16 param0, __global int16 *param1);

//floatn lgamma_r (floatn x, __local intn *signp)

OVERLOADABLE float2 lgamma_r (float2 param0, __local int2 *param1);
OVERLOADABLE float3 lgamma_r (float3 param0, __local int3 *param1);
OVERLOADABLE float4 lgamma_r (float4 param0, __local int4 *param1);
OVERLOADABLE float8 lgamma_r (float8 param0, __local int8 *param1);
OVERLOADABLE float16 lgamma_r (float16 param0, __local int16 *param1);

//floatn lgamma_r (floatn x, __private intn *signp)

OVERLOADABLE float2 lgamma_r (float2 param0, __private int2 *param1);
OVERLOADABLE float3 lgamma_r (float3 param0, __private int3 *param1);
OVERLOADABLE float4 lgamma_r (float4 param0, __private int4 *param1);
OVERLOADABLE float8 lgamma_r (float8 param0, __private int8 *param1);
OVERLOADABLE float16 lgamma_r (float16 param0, __private int16 *param1);

//float lgamma_r (float x, __global int *signp)


//float lgamma_r (float x, __local int *signp)


//float lgamma_r (float x,   __private int *signp)


//halfn lgamma_r (halfn x, __global intn *signp)

OVERLOADABLE half2 lgamma_r (half2 param0, __global int2 *param1);
OVERLOADABLE half3 lgamma_r (half3 param0, __global int3 *param1);
OVERLOADABLE half4 lgamma_r (half4 param0, __global int4 *param1);
OVERLOADABLE half8 lgamma_r (half8 param0, __global int8 *param1);
OVERLOADABLE half16 lgamma_r (half16 param0, __global int16 *param1);

//halfn lgamma_r (halfn x, __local intn *signp)

OVERLOADABLE half2 lgamma_r (half2 param0, __local int2 *param1);
OVERLOADABLE half3 lgamma_r (half3 param0, __local int3 *param1);
OVERLOADABLE half4 lgamma_r (half4 param0, __local int4 *param1);
OVERLOADABLE half8 lgamma_r (half8 param0, __local int8 *param1);
OVERLOADABLE half16 lgamma_r (half16 param0, __local int16 *param1);

//halfn lgamma_r (halfn x, __private intn *signp)

OVERLOADABLE half2 lgamma_r (half2 param0, __private int2 *param1);
OVERLOADABLE half3 lgamma_r (half3 param0, __private int3 *param1);
OVERLOADABLE half4 lgamma_r (half4 param0, __private int4 *param1);
OVERLOADABLE half8 lgamma_r (half8 param0, __private int8 *param1);
OVERLOADABLE half16 lgamma_r (half16 param0, __private int16 *param1);

//half lgamma_r (half x, __global int *signp)


//half lgamma_r (half x, __local int *signp)


//half lgamma_r (half x,   __private int *signp)


//doublen lgamma_r (doublen x, __global intn *signp)

OVERLOADABLE double2 lgamma_r (double2 param0, __global int2 *param1);
OVERLOADABLE double3 lgamma_r (double3 param0, __global int3 *param1);
OVERLOADABLE double4 lgamma_r (double4 param0, __global int4 *param1);
OVERLOADABLE double8 lgamma_r (double8 param0, __global int8 *param1);
OVERLOADABLE double16 lgamma_r (double16 param0, __global int16 *param1);

//doublen lgamma_r (doublen x, __local intn *signp)

OVERLOADABLE double2 lgamma_r (double2 param0, __local int2 *param1);
OVERLOADABLE double3 lgamma_r (double3 param0, __local int3 *param1);
OVERLOADABLE double4 lgamma_r (double4 param0, __local int4 *param1);
OVERLOADABLE double8 lgamma_r (double8 param0, __local int8 *param1);
OVERLOADABLE double16 lgamma_r (double16 param0, __local int16 *param1);

//doublen lgamma_r (doublen x, __private intn *signp)

OVERLOADABLE double2 lgamma_r (double2 param0, __private int2 *param1);
OVERLOADABLE double3 lgamma_r (double3 param0, __private int3 *param1);
OVERLOADABLE double4 lgamma_r (double4 param0, __private int4 *param1);
OVERLOADABLE double8 lgamma_r (double8 param0, __private int8 *param1);
OVERLOADABLE double16 lgamma_r (double16 param0, __private int16 *param1);

//double lgamma_r (double x, __global int *signp)


//double lgamma_r (double x, __local int *signp)


//double lgamma_r (double x, __private int *signp)


//gentype modf (gentype x, __global gentype *iptr)

OVERLOADABLE float2 modf (float2 param0, __global float2 *param1);
OVERLOADABLE float3 modf (float3 param0, __global float3 *param1);
OVERLOADABLE float4 modf (float4 param0, __global float4 *param1);
OVERLOADABLE float8 modf (float8 param0, __global float8 *param1);
OVERLOADABLE float16 modf (float16 param0, __global float16 *param1);
OVERLOADABLE double2 modf (double2 param0, __global double2 *param1);
OVERLOADABLE double3 modf (double3 param0, __global double3 *param1);
OVERLOADABLE double4 modf (double4 param0, __global double4 *param1);
OVERLOADABLE double8 modf (double8 param0, __global double8 *param1);
OVERLOADABLE double16 modf (double16 param0, __global double16 *param1);
OVERLOADABLE half2 modf (half2 param0, __global half2 *param1);
OVERLOADABLE half3 modf (half3 param0, __global half3 *param1);
OVERLOADABLE half4 modf (half4 param0, __global half4 *param1);
OVERLOADABLE half8 modf (half8 param0, __global half8 *param1);
OVERLOADABLE half16 modf (half16 param0, __global half16 *param1);

//gentype modf (gentype x, __local gentype *iptr)

OVERLOADABLE float2 modf (float2 param0, __local float2 *param1);
OVERLOADABLE float3 modf (float3 param0, __local float3 *param1);
OVERLOADABLE float4 modf (float4 param0, __local float4 *param1);
OVERLOADABLE float8 modf (float8 param0, __local float8 *param1);
OVERLOADABLE float16 modf (float16 param0, __local float16 *param1);
OVERLOADABLE double2 modf (double2 param0, __local double2 *param1);
OVERLOADABLE double3 modf (double3 param0, __local double3 *param1);
OVERLOADABLE double4 modf (double4 param0, __local double4 *param1);
OVERLOADABLE double8 modf (double8 param0, __local double8 *param1);
OVERLOADABLE double16 modf (double16 param0, __local double16 *param1);
OVERLOADABLE half2 modf (half2 param0, __local half2 *param1);
OVERLOADABLE half3 modf (half3 param0, __local half3 *param1);
OVERLOADABLE half4 modf (half4 param0, __local half4 *param1);
OVERLOADABLE half8 modf (half8 param0, __local half8 *param1);
OVERLOADABLE half16 modf (half16 param0, __local half16 *param1);

//gentype modf (gentype x, __private gentype *iptr)

OVERLOADABLE float2 modf (float2 param0, __private float2 *param1);
OVERLOADABLE float3 modf (float3 param0, __private float3 *param1);
OVERLOADABLE float4 modf (float4 param0, __private float4 *param1);
OVERLOADABLE float8 modf (float8 param0, __private float8 *param1);
OVERLOADABLE float16 modf (float16 param0, __private float16 *param1);
OVERLOADABLE double2 modf (double2 param0, __private double2 *param1);
OVERLOADABLE double3 modf (double3 param0, __private double3 *param1);
OVERLOADABLE double4 modf (double4 param0, __private double4 *param1);
OVERLOADABLE double8 modf (double8 param0, __private double8 *param1);
OVERLOADABLE double16 modf (double16 param0, __private double16 *param1);
OVERLOADABLE half2 modf (half2 param0, __private half2 *param1);
OVERLOADABLE half3 modf (half3 param0, __private half3 *param1);
OVERLOADABLE half4 modf (half4 param0, __private half4 *param1);
OVERLOADABLE half8 modf (half8 param0, __private half8 *param1);
OVERLOADABLE half16 modf (half16 param0, __private half16 *param1);

//floatn remquo (floatn x, floatn y, __global intn *quo)

OVERLOADABLE float2 remquo (float2 param0, float2 param1, __global int2 *param2);
OVERLOADABLE float3 remquo (float3 param0, float3 param1, __global int3 *param2);
OVERLOADABLE float4 remquo (float4 param0, float4 param1, __global int4 *param2);
OVERLOADABLE float8 remquo (float8 param0, float8 param1, __global int8 *param2);
OVERLOADABLE float16 remquo (float16 param0, float16 param1, __global int16 *param2);

//floatn remquo (floatn x, floatn y, __local intn *quo)

OVERLOADABLE float2 remquo (float2 param0, float2 param1, __local int2 *param2);
OVERLOADABLE float3 remquo (float3 param0, float3 param1, __local int3 *param2);
OVERLOADABLE float4 remquo (float4 param0, float4 param1, __local int4 *param2);
OVERLOADABLE float8 remquo (float8 param0, float8 param1, __local int8 *param2);
OVERLOADABLE float16 remquo (float16 param0, float16 param1, __local int16 *param2);

//floatn remquo (floatn x, floatn y, __private intn *quo)

OVERLOADABLE float2 remquo (float2 param0, float2 param1, __private int2 *param2);
OVERLOADABLE float3 remquo (float3 param0, float3 param1, __private int3 *param2);
OVERLOADABLE float4 remquo (float4 param0, float4 param1, __private int4 *param2);
OVERLOADABLE float8 remquo (float8 param0, float8 param1, __private int8 *param2);
OVERLOADABLE float16 remquo (float16 param0, float16 param1, __private int16 *param2);

//float remquo (float x, float y, __global int *quo)


//float remquo (float x, float y, __local int *quo)


//float remquo (float x, float y, __private int *quo)


//halfn remquo (halfn x, halfn y, __global intn *quo)

OVERLOADABLE half2 remquo (half2 param0, half2 param1, __global int2 *param2);
OVERLOADABLE half3 remquo (half3 param0, half3 param1, __global int3 *param2);
OVERLOADABLE half4 remquo (half4 param0, half4 param1, __global int4 *param2);
OVERLOADABLE half8 remquo (half8 param0, half8 param1, __global int8 *param2);
OVERLOADABLE half16 remquo (half16 param0, half16 param1, __global int16 *param2);

//halfn remquo (halfn x, halfn y, __local intn *quo)

OVERLOADABLE half2 remquo (half2 param0, half2 param1, __local int2 *param2);
OVERLOADABLE half3 remquo (half3 param0, half3 param1, __local int3 *param2);
OVERLOADABLE half4 remquo (half4 param0, half4 param1, __local int4 *param2);
OVERLOADABLE half8 remquo (half8 param0, half8 param1, __local int8 *param2);
OVERLOADABLE half16 remquo (half16 param0, half16 param1, __local int16 *param2);

//halfn remquo (halfn x, halfn y, __private intn *quo)

OVERLOADABLE half2 remquo (half2 param0, half2 param1, __private int2 *param2);
OVERLOADABLE half3 remquo (half3 param0, half3 param1, __private int3 *param2);
OVERLOADABLE half4 remquo (half4 param0, half4 param1, __private int4 *param2);
OVERLOADABLE half8 remquo (half8 param0, half8 param1, __private int8 *param2);
OVERLOADABLE half16 remquo (half16 param0, half16 param1, __private int16 *param2);

//half remquo (half x, half y, __global int *quo)


//half remquo (half x, half y, __local int *quo)


//half remquo (half x, half y, __private int *quo)


//doublen remquo (doublen x, doublen y, __global intn *quo)

OVERLOADABLE double2 remquo (double2 param0, double2 param1, __global int2 *param2);
OVERLOADABLE double3 remquo (double3 param0, double3 param1, __global int3 *param2);
OVERLOADABLE double4 remquo (double4 param0, double4 param1, __global int4 *param2);
OVERLOADABLE double8 remquo (double8 param0, double8 param1, __global int8 *param2);
OVERLOADABLE double16 remquo (double16 param0, double16 param1, __global int16 *param2);

//doublen remquo (doublen x, doublen y, __local intn *quo)

OVERLOADABLE double2 remquo (double2 param0, double2 param1, __local int2 *param2);
OVERLOADABLE double3 remquo (double3 param0, double3 param1, __local int3 *param2);
OVERLOADABLE double4 remquo (double4 param0, double4 param1, __local int4 *param2);
OVERLOADABLE double8 remquo (double8 param0, double8 param1, __local int8 *param2);
OVERLOADABLE double16 remquo (double16 param0, double16 param1, __local int16 *param2);

//doublen remquo (doublen x, doublen y, __private intn *quo)

OVERLOADABLE double2 remquo (double2 param0, double2 param1, __private int2 *param2);
OVERLOADABLE double3 remquo (double3 param0, double3 param1, __private int3 *param2);
OVERLOADABLE double4 remquo (double4 param0, double4 param1, __private int4 *param2);
OVERLOADABLE double8 remquo (double8 param0, double8 param1, __private int8 *param2);
OVERLOADABLE double16 remquo (double16 param0, double16 param1, __private int16 *param2);

//double remquo (double x, double y, __global int *quo)


//double remquo (double x, double y, __local int *quo)


//double remquo (double x, double y, __private int *quo)


//gentype sincos (gentype x, __global gentype *cosval)

OVERLOADABLE float2 sincos (float2 param0, __global float2 *param1);
OVERLOADABLE float3 sincos (float3 param0, __global float3 *param1);
OVERLOADABLE float4 sincos (float4 param0, __global float4 *param1);
OVERLOADABLE float8 sincos (float8 param0, __global float8 *param1);
OVERLOADABLE float16 sincos (float16 param0, __global float16 *param1);
OVERLOADABLE double2 sincos (double2 param0, __global double2 *param1);
OVERLOADABLE double3 sincos (double3 param0, __global double3 *param1);
OVERLOADABLE double4 sincos (double4 param0, __global double4 *param1);
OVERLOADABLE double8 sincos (double8 param0, __global double8 *param1);
OVERLOADABLE double16 sincos (double16 param0, __global double16 *param1);
OVERLOADABLE half2 sincos (half2 param0, __global half2 *param1);
OVERLOADABLE half3 sincos (half3 param0, __global half3 *param1);
OVERLOADABLE half4 sincos (half4 param0, __global half4 *param1);
OVERLOADABLE half8 sincos (half8 param0, __global half8 *param1);
OVERLOADABLE half16 sincos (half16 param0, __global half16 *param1);

//gentype sincos (gentype x, __local gentype *cosval)

OVERLOADABLE float2 sincos (float2 param0, __local float2 *param1);
OVERLOADABLE float3 sincos (float3 param0, __local float3 *param1);
OVERLOADABLE float4 sincos (float4 param0, __local float4 *param1);
OVERLOADABLE float8 sincos (float8 param0, __local float8 *param1);
OVERLOADABLE float16 sincos (float16 param0, __local float16 *param1);
OVERLOADABLE double2 sincos (double2 param0, __local double2 *param1);
OVERLOADABLE double3 sincos (double3 param0, __local double3 *param1);
OVERLOADABLE double4 sincos (double4 param0, __local double4 *param1);
OVERLOADABLE double8 sincos (double8 param0, __local double8 *param1);
OVERLOADABLE double16 sincos (double16 param0, __local double16 *param1);
OVERLOADABLE half2 sincos (half2 param0, __local half2 *param1);
OVERLOADABLE half3 sincos (half3 param0, __local half3 *param1);
OVERLOADABLE half4 sincos (half4 param0, __local half4 *param1);
OVERLOADABLE half8 sincos (half8 param0, __local half8 *param1);
OVERLOADABLE half16 sincos (half16 param0, __local half16 *param1);

//gentype sincos (gentype x, __private gentype *cosval)

OVERLOADABLE float2 sincos (float2 param0, __private float2 *param1);
OVERLOADABLE float3 sincos (float3 param0, __private float3 *param1);
OVERLOADABLE float4 sincos (float4 param0, __private float4 *param1);
OVERLOADABLE float8 sincos (float8 param0, __private float8 *param1);
OVERLOADABLE float16 sincos (float16 param0, __private float16 *param1);
OVERLOADABLE double2 sincos (double2 param0, __private double2 *param1);
OVERLOADABLE double3 sincos (double3 param0, __private double3 *param1);
OVERLOADABLE double4 sincos (double4 param0, __private double4 *param1);
OVERLOADABLE double8 sincos (double8 param0, __private double8 *param1);
OVERLOADABLE double16 sincos (double16 param0, __private double16 *param1);
OVERLOADABLE half2 sincos (half2 param0, __private half2 *param1);
OVERLOADABLE half3 sincos (half3 param0, __private half3 *param1);
OVERLOADABLE half4 sincos (half4 param0, __private half4 *param1);
OVERLOADABLE half8 sincos (half8 param0, __private half8 *param1);
OVERLOADABLE half16 sincos (half16 param0, __private half16 *param1);

#endif
