"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitCommentThreadView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commitCommentView = _interopRequireDefault(require("./commit-comment-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitCommentThreadView extends _react["default"].Component {
  render() {
    const {
      item
    } = this.props;
    return _react["default"].createElement("div", {
      className: "commit-comment-thread timeline-item"
    }, item.comments.edges.map((edge, i) => _react["default"].createElement(_commitCommentView["default"], {
      isReply: i !== 0,
      key: edge.node.id,
      item: edge.node,
      switchToIssueish: this.props.switchToIssueish
    })));
  }

}

exports.BareCommitCommentThreadView = BareCommitCommentThreadView;

_defineProperty(BareCommitCommentThreadView, "propTypes", {
  item: _propTypes["default"].shape({
    commit: _propTypes["default"].shape({
      oid: _propTypes["default"].string.isRequired
    }).isRequired,
    comments: _propTypes["default"].shape({
      edges: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        node: _propTypes["default"].object.isRequired
      }).isRequired).isRequired
    }).isRequired
  }).isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentThreadView, {
  item: function () {
    const node = require("./__generated__/commitCommentThreadView_item.graphql");

    if (node.hash && node.hash !== "8d9762b31747ddf9be48e163b09a45bc") {
      console.error("The definition of 'commitCommentThreadView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitCommentThreadView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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