/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import processing.app.Base;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Util;
import processing.app.contrib.ContributionType;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.LocalContribution;

public class ModeContribution
extends LocalContribution {
    private Mode mode;

    public static ModeContribution load(Base base, File folder) {
        return ModeContribution.load(base, folder, null);
    }

    public static ModeContribution load(Base base, File folder, String searchName) {
        try {
            return new ModeContribution(base, folder, searchName);
        }
        catch (IgnorableException ig) {
            Messages.log(ig.getMessage());
        }
        catch (Throwable err) {
            System.out.println("err is " + err);
            if (searchName == null) {
                throw new RuntimeException(err);
            }
            Messages.loge("ModeContribution.load() failed for " + searchName, err);
        }
        return null;
    }

    public ModeContribution(Base base, File folder, String className) throws Exception {
        super(folder);
        className = this.initLoader(base, className);
        if (className != null) {
            Class<?> modeClass = this.loader.loadClass(className);
            Messages.log("Got mode class " + modeClass);
            Constructor<?> con = modeClass.getConstructor(Base.class, File.class);
            this.mode = (Mode)con.newInstance(base, folder);
            this.mode.setClassLoader(this.loader);
            if (base != null) {
                this.mode.setupGUI();
            }
        }
    }

    public void clearClassLoader(Base base) {
        List<ModeContribution> contribModes = base.getModeContribs();
        int botherToRemove = contribModes.indexOf(this);
        if (botherToRemove != -1) {
            contribModes.remove(botherToRemove);
            try {
                ((URLClassLoader)this.loader).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public ContributionType getType() {
        return ContributionType.MODE;
    }

    public String initLoader(Base base, String className) throws Exception {
        File modeDirectory = new File(this.folder, this.getTypeName());
        if (modeDirectory.exists()) {
            File[] archives;
            Messages.log("checking mode folder regarding class name " + className);
            if (className == null) {
                String shortName = this.folder.getName();
                File mainJar = new File(modeDirectory, String.valueOf(shortName) + ".jar");
                if (!mainJar.exists()) {
                    throw new IgnorableException(String.valueOf(mainJar.getAbsolutePath()) + " does not exist.");
                }
                className = ModeContribution.findClassInZipFile(shortName, mainJar);
                if (className == null) {
                    throw new IgnorableException("Could not find " + shortName + " class inside " + mainJar.getAbsolutePath());
                }
            }
            ArrayList<URL> extraUrls = new ArrayList<URL>();
            if (this.imports != null && this.imports.size() > 0) {
                HashMap<String, Mode> installedModes = new HashMap<String, Mode>();
                for (Mode m : base.getModeList()) {
                    installedModes.put(m.getClass().getName(), m);
                }
                for (String modeImport : this.imports) {
                    if (installedModes.containsKey(modeImport)) {
                        Messages.log("Found mode dependency " + modeImport);
                        File modeFolder = ((Mode)installedModes.get(modeImport)).getFolder();
                        File[] archives2 = Util.listJarFiles(new File(modeFolder, "mode"));
                        if (archives2 == null || archives2.length <= 0) continue;
                        int i = 0;
                        while (i < archives2.length) {
                            extraUrls.add(archives2[i].toURI().toURL());
                            ++i;
                        }
                        continue;
                    }
                    throw new IgnorableException("Can't load " + className + " because the import " + modeImport + " could not be found. ");
                }
            }
            if ((archives = Util.listJarFiles(modeDirectory)) != null && archives.length > 0) {
                int arrLen = archives.length + extraUrls.size();
                URL[] urlList = new URL[arrLen];
                int j = 0;
                while (j < extraUrls.size()) {
                    urlList[j] = (URL)extraUrls.get(j);
                    ++j;
                }
                int k = 0;
                while (k < archives.length) {
                    Messages.log("Found archive " + archives[k] + " for " + this.getName());
                    urlList[j] = archives[k].toURI().toURL();
                    ++k;
                    ++j;
                }
                this.loader = new URLClassLoader(urlList);
                Messages.log("loading above JARs with loader " + this.loader);
            }
        }
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
        }
        return className;
    }
}

