/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.lib.profiler.results.memory.DiffObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsDiff
extends LivenessMemoryResultsSnapshot {
    private final LivenessMemoryResultsSnapshot snapshot1;
    private final LivenessMemoryResultsSnapshot snapshot2;
    private float[] avgObjectAge;
    private String[] classNames;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] objectsSizePerClass;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int nClasses;
    private long maxTrackedLiveObjectsSizeDiff;
    private long minTrackedLiveObjectsSizeDiff;

    public LivenessMemoryResultsDiff(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot2) {
        this.snapshot1 = livenessMemoryResultsSnapshot;
        this.snapshot2 = livenessMemoryResultsSnapshot2;
        this.computeDiff(livenessMemoryResultsSnapshot, livenessMemoryResultsSnapshot2);
    }

    @Override
    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public String getClassName(int n) {
        return this.classNames[n];
    }

    @Override
    public String[] getClassNames() {
        return this.classNames;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    @Override
    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxTrackedLiveObjectsSizeDiff() {
        return this.maxTrackedLiveObjectsSizeDiff;
    }

    @Override
    public long getMaxValue() {
        return -1L;
    }

    public long getMinTrackedLiveObjectsSizeDiff() {
        return this.minTrackedLiveObjectsSizeDiff;
    }

    @Override
    public int getNAlloc() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNInstrClasses() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNProfiledClasses() {
        return this.nClasses;
    }

    @Override
    public long getNTotalTracked() {
        return -1L;
    }

    @Override
    public long getNTotalTrackedBytes() {
        return -1L;
    }

    @Override
    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    @Override
    public int getNTrackedItems() {
        return this.getNProfiledClasses();
    }

    @Override
    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    @Override
    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    @Override
    public boolean containsStacks() {
        return false;
    }

    @Override
    public PresoObjLivenessCCTNode createPresentationCCT(int n, boolean bl) {
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = this.snapshot1.createPresentationCCT(this.classId1(n), bl);
        PresoObjLivenessCCTNode presoObjLivenessCCTNode2 = this.snapshot2.createPresentationCCT(this.classId2(n), bl);
        return new DiffObjLivenessCCTNode(presoObjLivenessCCTNode, presoObjLivenessCCTNode2);
    }

    @Override
    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjLivenessCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = this.snapshot1.createPresentationCCT(runtimeMemoryCCTNode, this.classId1(n), bl);
        PresoObjLivenessCCTNode presoObjLivenessCCTNode2 = this.snapshot2.createPresentationCCT(runtimeMemoryCCTNode, this.classId2(n), bl);
        return new DiffObjLivenessCCTNode(presoObjLivenessCCTNode, presoObjLivenessCCTNode2);
    }

    private int classId1(int n) {
        return this.classId(n, this.snapshot1);
    }

    private int classId2(int n) {
        return this.classId(n, this.snapshot2);
    }

    private int classId(int n, LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot) {
        if (livenessMemoryResultsSnapshot == null) {
            return -1;
        }
        String string = this.getClassName(n);
        String[] stringArray = livenessMemoryResultsSnapshot.getClassNames();
        if (stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void computeDiff(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot2) {
        Object object;
        int n = livenessMemoryResultsSnapshot.getNTrackedItems();
        int n2 = livenessMemoryResultsSnapshot2.getNTrackedItems();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(n);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(n);
        ArrayList<Float> arrayList5 = new ArrayList<Float>(n);
        ArrayList<Long> arrayList6 = new ArrayList<Long>(n);
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>(n);
        String[] stringArray = livenessMemoryResultsSnapshot.getClassNames();
        long[] lArray = livenessMemoryResultsSnapshot.getNTrackedAllocObjects();
        long[] lArray2 = livenessMemoryResultsSnapshot.getObjectsSizePerClass();
        int[] nArray = livenessMemoryResultsSnapshot.getNTrackedLiveObjects();
        int[] nArray2 = livenessMemoryResultsSnapshot.getMaxSurvGen();
        float[] fArray = livenessMemoryResultsSnapshot.getAvgObjectAge();
        long[] lArray3 = livenessMemoryResultsSnapshot.getTrackedLiveObjectsSize();
        int[] nArray3 = livenessMemoryResultsSnapshot.getnTotalAllocObjects();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            object = (Integer)hashMap.get(stringArray[i]);
            if (object != null) {
                arrayList.set((Integer)object, (Long)arrayList.get((Integer)object) - lArray[i]);
                arrayList2.set((Integer)object, (Long)arrayList2.get((Integer)object) - lArray2[i]);
                arrayList3.set((Integer)object, (Integer)arrayList3.get((Integer)object) - nArray[i]);
                arrayList4.set((Integer)object, (Integer)arrayList4.get((Integer)object) - nArray2[i]);
                arrayList5.set((Integer)object, Float.valueOf(((Float)arrayList5.get((Integer)object)).floatValue() - fArray[i]));
                arrayList6.set((Integer)object, (Long)arrayList6.get((Integer)object) - lArray3[i]);
                arrayList7.set((Integer)object, (Integer)arrayList7.get((Integer)object) - nArray3[i]);
                continue;
            }
            hashMap.put(stringArray[i], n3++);
            arrayList.add(-lArray[i]);
            arrayList2.add(-lArray2[i]);
            arrayList3.add(-nArray[i]);
            arrayList4.add(-nArray2[i]);
            arrayList5.add(Float.valueOf(-fArray[i]));
            arrayList6.add(-lArray3[i]);
            arrayList7.add(-nArray3[i]);
        }
        String[] stringArray2 = livenessMemoryResultsSnapshot2.getClassNames();
        object = livenessMemoryResultsSnapshot2.getNTrackedAllocObjects();
        long[] lArray4 = livenessMemoryResultsSnapshot2.getObjectsSizePerClass();
        int[] nArray4 = livenessMemoryResultsSnapshot2.getNTrackedLiveObjects();
        int[] nArray5 = livenessMemoryResultsSnapshot2.getMaxSurvGen();
        float[] fArray2 = livenessMemoryResultsSnapshot2.getAvgObjectAge();
        long[] lArray5 = livenessMemoryResultsSnapshot2.getTrackedLiveObjectsSize();
        int[] nArray6 = livenessMemoryResultsSnapshot2.getnTotalAllocObjects();
        for (int i = 0; i < n2; ++i) {
            Integer n4 = (Integer)hashMap.get(stringArray2[i]);
            if (n4 != null) {
                arrayList.set(n4, (Long)arrayList.get(n4) + object[i]);
                arrayList2.set(n4, (Long)arrayList2.get(n4) + lArray4[i]);
                arrayList3.set(n4, (Integer)arrayList3.get(n4) + nArray4[i]);
                arrayList4.set(n4, (Integer)arrayList4.get(n4) + nArray5[i]);
                arrayList5.set(n4, Float.valueOf(((Float)arrayList5.get(n4)).floatValue() + fArray2[i]));
                arrayList6.set(n4, (Long)arrayList6.get(n4) + lArray5[i]);
                arrayList7.set(n4, (Integer)arrayList7.get(n4) + nArray6[i]);
                continue;
            }
            hashMap.put(stringArray2[i], arrayList.size());
            arrayList.add((long)object[i]);
            arrayList2.add(lArray4[i]);
            arrayList3.add(nArray4[i]);
            arrayList4.add(nArray5[i]);
            arrayList5.add(Float.valueOf(fArray2[i]));
            arrayList6.add(lArray5[i]);
            arrayList7.add(nArray6[i]);
        }
        this.nClasses = hashMap.size();
        this.classNames = new String[this.nClasses];
        this.nTrackedAllocObjects = new long[this.nClasses];
        this.objectsSizePerClass = new long[this.nClasses];
        this.nTrackedLiveObjects = new int[this.nClasses];
        this.maxSurvGen = new int[this.nClasses];
        this.avgObjectAge = new float[this.nClasses];
        this.trackedLiveObjectsSize = new long[this.nClasses];
        this.nTotalAllocObjects = new int[this.nClasses];
        this.minTrackedLiveObjectsSizeDiff = Integer.MAX_VALUE;
        this.maxTrackedLiveObjectsSizeDiff = Integer.MIN_VALUE;
        Iterator iterator = hashMap.entrySet().iterator();
        int n5 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n6 = (Integer)entry.getValue();
            this.classNames[n5] = (String)entry.getKey();
            this.nTrackedAllocObjects[n5] = (Long)arrayList.get(n6);
            this.objectsSizePerClass[n5] = (Long)arrayList2.get(n6);
            this.nTrackedLiveObjects[n5] = (Integer)arrayList3.get(n6);
            this.maxSurvGen[n5] = (Integer)arrayList4.get(n6);
            this.avgObjectAge[n5] = ((Float)arrayList5.get(n6)).floatValue();
            this.trackedLiveObjectsSize[n5] = (Long)arrayList6.get(n6);
            this.nTotalAllocObjects[n5] = (Integer)arrayList7.get(n6);
            this.minTrackedLiveObjectsSizeDiff = Math.min(this.minTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[n5]);
            this.maxTrackedLiveObjectsSizeDiff = Math.max(this.maxTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[n5]);
            ++n5;
        }
        if (this.minTrackedLiveObjectsSizeDiff > 0L && this.maxTrackedLiveObjectsSizeDiff > 0L) {
            this.minTrackedLiveObjectsSizeDiff = 0L;
        } else if (this.minTrackedLiveObjectsSizeDiff < 0L && this.maxTrackedLiveObjectsSizeDiff < 0L) {
            this.maxTrackedLiveObjectsSizeDiff = 0L;
        }
    }
}

