/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FallbackResource;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PrismCompositeFontResource
implements CompositeFontResource {
    private FontResource primaryResource;
    private FallbackResource fallbackResource;
    CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();

    PrismCompositeFontResource(FontResource primaryResource, String lookupName) {
        if (!(primaryResource instanceof PrismFontFile)) {
            Thread.dumpStack();
            throw new IllegalStateException("wrong resource type");
        }
        if (lookupName != null) {
            PrismFontFactory factory = PrismFontFactory.getFontFactory();
            factory.compResourceMap.put(lookupName, this);
        }
        this.primaryResource = primaryResource;
        int aaMode = primaryResource.getDefaultAAMode();
        boolean bold = primaryResource.isBold();
        boolean italic = primaryResource.isItalic();
        this.fallbackResource = FallbackResource.getFallbackResource(bold, italic, aaMode);
    }

    @Override
    public int getNumSlots() {
        return this.fallbackResource.getNumSlots() + 1;
    }

    @Override
    public int getSlotForFont(String fontName) {
        if (this.primaryResource.getFullName().equalsIgnoreCase(fontName)) {
            return 0;
        }
        return this.fallbackResource.getSlotForFont(fontName) + 1;
    }

    @Override
    public FontResource getSlotResource(int slot) {
        if (slot == 0) {
            return this.primaryResource;
        }
        FontResource fb = this.fallbackResource.getSlotResource(slot - 1);
        if (fb != null) {
            return fb;
        }
        return this.primaryResource;
    }

    @Override
    public String getFullName() {
        return this.primaryResource.getFullName();
    }

    @Override
    public String getPSName() {
        return this.primaryResource.getPSName();
    }

    @Override
    public String getFamilyName() {
        return this.primaryResource.getFamilyName();
    }

    @Override
    public String getStyleName() {
        return this.primaryResource.getStyleName();
    }

    @Override
    public String getLocaleFullName() {
        return this.primaryResource.getLocaleFullName();
    }

    @Override
    public String getLocaleFamilyName() {
        return this.primaryResource.getLocaleFamilyName();
    }

    @Override
    public String getLocaleStyleName() {
        return this.primaryResource.getLocaleStyleName();
    }

    @Override
    public String getFileName() {
        return this.primaryResource.getFileName();
    }

    @Override
    public int getFeatures() {
        return this.primaryResource.getFeatures();
    }

    @Override
    public Object getPeer() {
        return this.primaryResource.getPeer();
    }

    @Override
    public void setPeer(Object peer) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isEmbeddedFont() {
        return this.primaryResource.isEmbeddedFont();
    }

    @Override
    public boolean isBold() {
        return this.primaryResource.isBold();
    }

    @Override
    public boolean isItalic() {
        return this.primaryResource.isItalic();
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public float[] getGlyphBoundingBox(int glyphCode, float size, float[] retArr) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getGlyphBoundingBox(slotglyphCode, size, retArr);
    }

    @Override
    public float getAdvance(int glyphCode, float size) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getAdvance(slotglyphCode, size);
    }

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    @Override
    public int getDefaultAAMode() {
        return this.getSlotResource(0).getDefaultAAMode();
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform) {
        return this.getStrike(size, transform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform, int aaMode) {
        FontStrikeDesc desc = new FontStrikeDesc(size, transform, aaMode);
        WeakReference<CompositeStrike> ref = this.strikeMap.get(desc);
        CompositeStrike strike = null;
        if (ref != null) {
            strike = (CompositeStrike)ref.get();
        }
        if (strike == null) {
            strike = new CompositeStrike(this, size, transform, aaMode, desc);
            ref = strike.disposer != null ? Disposer.addRecord(strike, strike.disposer) : new WeakReference<CompositeStrike>(strike);
            this.strikeMap.put(desc, ref);
        }
        return strike;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrismCompositeFontResource)) {
            return false;
        }
        PrismCompositeFontResource other = (PrismCompositeFontResource)obj;
        return this.primaryResource.equals(other.primaryResource);
    }

    public int hashCode() {
        return this.primaryResource.hashCode();
    }
}

