Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

'use babel';

var GoToLineView = (function () {
  function GoToLineView() {
    var _this = this;

    _classCallCheck(this, GoToLineView);

    this.miniEditor = new _atom.TextEditor({ mini: true });
    this.miniEditor.element.addEventListener('blur', this.close.bind(this));

    this.message = document.createElement('div');
    this.message.classList.add('message');

    this.element = document.createElement('div');
    this.element.classList.add('go-to-line');
    this.element.appendChild(this.miniEditor.element);
    this.element.appendChild(this.message);

    this.panel = atom.workspace.addModalPanel({
      item: this,
      visible: false
    });
    atom.commands.add('atom-text-editor', 'go-to-line:toggle', function () {
      _this.toggle();
      return false;
    });
    atom.commands.add(this.miniEditor.element, 'core:confirm', function () {
      _this.navigate();
    });
    atom.commands.add(this.miniEditor.element, 'core:cancel', function () {
      _this.close();
    });
    this.miniEditor.onWillInsertText(function (arg) {
      if (arg.text.match(/[^0-9:]/)) {
        arg.cancel();
      }
    });
    this.miniEditor.onDidChange(function () {
      _this.navigate({ keepOpen: true });
    });
  }

  _createClass(GoToLineView, [{
    key: 'toggle',
    value: function toggle() {
      this.panel.isVisible() ? this.close() : this.open();
    }
  }, {
    key: 'close',
    value: function close() {
      if (!this.panel.isVisible()) return;
      this.miniEditor.setText('');
      this.panel.hide();
      if (this.miniEditor.element.hasFocus()) {
        this.restoreFocus();
      }
    }
  }, {
    key: 'navigate',
    value: function navigate() {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var lineNumber = this.miniEditor.getText();
      var editor = atom.workspace.getActiveTextEditor();
      if (!options.keepOpen) {
        this.close();
      }
      if (!editor || !lineNumber.length) return;

      var currentRow = editor.getCursorBufferPosition().row;
      var rowLineNumber = lineNumber.split(/:+/)[0] || '';
      var row = rowLineNumber.length > 0 ? parseInt(rowLineNumber) - 1 : currentRow;
      var columnLineNumber = lineNumber.split(/:+/)[1] || '';
      var column = columnLineNumber.length > 0 ? parseInt(columnLineNumber) - 1 : -1;

      var position = new _atom.Point(row, column);
      editor.setCursorBufferPosition(position);
      editor.unfoldBufferRow(row);
      if (column < 0) {
        editor.moveToFirstCharacterOfLine();
      }
      editor.scrollToBufferPosition(position, {
        center: true
      });
    }
  }, {
    key: 'storeFocusedElement',
    value: function storeFocusedElement() {
      this.previouslyFocusedElement = document.activeElement;
      return this.previouslyFocusedElement;
    }
  }, {
    key: 'restoreFocus',
    value: function restoreFocus() {
      if (this.previouslyFocusedElement && this.previouslyFocusedElement.parentElement) {
        return this.previouslyFocusedElement.focus();
      }
      atom.views.getView(atom.workspace).focus();
    }
  }, {
    key: 'open',
    value: function open() {
      if (this.panel.isVisible() || !atom.workspace.getActiveTextEditor()) return;
      this.storeFocusedElement();
      this.panel.show();
      this.message.textContent = 'Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7';
      this.miniEditor.element.focus();
    }
  }]);

  return GoToLineView;
})();

exports['default'] = {
  activate: function activate() {
    return new GoToLineView();
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9nby10by1saW5lL2xpYi9nby10by1saW5lLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7b0JBRWtDLE1BQU07O0FBRnhDLFdBQVcsQ0FBQTs7SUFJTCxZQUFZO0FBQ0osV0FEUixZQUFZLEdBQ0Q7OzswQkFEWCxZQUFZOztBQUVkLFFBQUksQ0FBQyxVQUFVLEdBQUcscUJBQWUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQTtBQUNoRCxRQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTs7QUFFdkUsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQzVDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQTs7QUFFckMsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQzVDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQUN4QyxRQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFBO0FBQ2pELFFBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQTs7QUFFdEMsUUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztBQUN4QyxVQUFJLEVBQUUsSUFBSTtBQUNWLGFBQU8sRUFBRSxLQUFLO0tBQ2YsQ0FBQyxDQUFBO0FBQ0YsUUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsbUJBQW1CLEVBQUUsWUFBTTtBQUMvRCxZQUFLLE1BQU0sRUFBRSxDQUFBO0FBQ2IsYUFBTyxLQUFLLENBQUE7S0FDYixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxjQUFjLEVBQUUsWUFBTTtBQUMvRCxZQUFLLFFBQVEsRUFBRSxDQUFBO0tBQ2hCLENBQUMsQ0FBQTtBQUNGLFFBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLGFBQWEsRUFBRSxZQUFNO0FBQzlELFlBQUssS0FBSyxFQUFFLENBQUE7S0FDYixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLFVBQUEsR0FBRyxFQUFJO0FBQ3RDLFVBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLEVBQUU7QUFDN0IsV0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ2I7S0FDRixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxZQUFNO0FBQ2hDLFlBQUssUUFBUSxDQUFDLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUE7S0FDbEMsQ0FBQyxDQUFBO0dBQ0g7O2VBbkNHLFlBQVk7O1dBcUNULGtCQUFHO0FBQ1IsVUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFBO0tBQ3BEOzs7V0FFSyxpQkFBRztBQUNQLFVBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxFQUFFLE9BQU07QUFDbkMsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUE7QUFDM0IsVUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUNqQixVQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxFQUFFO0FBQ3RDLFlBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQTtPQUNwQjtLQUNGOzs7V0FFUSxvQkFBZTtVQUFkLE9BQU8seURBQUcsRUFBRTs7QUFDcEIsVUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUM1QyxVQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDbkQsVUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7QUFDckIsWUFBSSxDQUFDLEtBQUssRUFBRSxDQUFBO09BQ2I7QUFDRCxVQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRSxPQUFNOztBQUV6QyxVQUFNLFVBQVUsR0FBRyxNQUFNLENBQUMsdUJBQXVCLEVBQUUsQ0FBQyxHQUFHLENBQUE7QUFDdkQsVUFBTSxhQUFhLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUE7QUFDckQsVUFBTSxHQUFHLEdBQ1AsYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsR0FBRyxVQUFVLENBQUE7QUFDckUsVUFBTSxnQkFBZ0IsR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUN4RCxVQUFNLE1BQU0sR0FDVixnQkFBZ0IsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQTs7QUFFbkUsVUFBTSxRQUFRLEdBQUcsZ0JBQVUsR0FBRyxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQ3ZDLFlBQU0sQ0FBQyx1QkFBdUIsQ0FBQyxRQUFRLENBQUMsQ0FBQTtBQUN4QyxZQUFNLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFBO0FBQzNCLFVBQUksTUFBTSxHQUFHLENBQUMsRUFBRTtBQUNkLGNBQU0sQ0FBQywwQkFBMEIsRUFBRSxDQUFBO09BQ3BDO0FBQ0QsWUFBTSxDQUFDLHNCQUFzQixDQUFDLFFBQVEsRUFBRTtBQUN0QyxjQUFNLEVBQUUsSUFBSTtPQUNiLENBQUMsQ0FBQTtLQUNIOzs7V0FFbUIsK0JBQUc7QUFDckIsVUFBSSxDQUFDLHdCQUF3QixHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUE7QUFDdEQsYUFBTyxJQUFJLENBQUMsd0JBQXdCLENBQUE7S0FDckM7OztXQUVZLHdCQUFHO0FBQ2QsVUFDRSxJQUFJLENBQUMsd0JBQXdCLElBQzdCLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxhQUFhLEVBQzNDO0FBQ0EsZUFBTyxJQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxFQUFFLENBQUE7T0FDN0M7QUFDRCxVQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUE7S0FDM0M7OztXQUVJLGdCQUFHO0FBQ04sVUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxFQUFFLE9BQU07QUFDM0UsVUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDMUIsVUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUNqQixVQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsR0FDdEIsc0dBQXNHLENBQUE7QUFDeEcsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUE7S0FDaEM7OztTQW5HRyxZQUFZOzs7cUJBc0dIO0FBQ2IsVUFBUSxFQUFDLG9CQUFHO0FBQ1YsV0FBTyxJQUFJLFlBQVksRUFBRSxDQUFBO0dBQzFCO0NBQ0YiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOC4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dvLXRvLWxpbmUvbGliL2dvLXRvLWxpbmUtdmlldy5qcyIsInNvdXJjZXNDb250ZW50IjpbIid1c2UgYmFiZWwnXG5cbmltcG9ydCB7IFBvaW50LCBUZXh0RWRpdG9yIH0gZnJvbSAnYXRvbSdcblxuY2xhc3MgR29Ub0xpbmVWaWV3IHtcbiAgY29uc3RydWN0b3IgKCkge1xuICAgIHRoaXMubWluaUVkaXRvciA9IG5ldyBUZXh0RWRpdG9yKHsgbWluaTogdHJ1ZSB9KVxuICAgIHRoaXMubWluaUVkaXRvci5lbGVtZW50LmFkZEV2ZW50TGlzdGVuZXIoJ2JsdXInLCB0aGlzLmNsb3NlLmJpbmQodGhpcykpXG5cbiAgICB0aGlzLm1lc3NhZ2UgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIHRoaXMubWVzc2FnZS5jbGFzc0xpc3QuYWRkKCdtZXNzYWdlJylcblxuICAgIHRoaXMuZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpXG4gICAgdGhpcy5lbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2dvLXRvLWxpbmUnKVxuICAgIHRoaXMuZWxlbWVudC5hcHBlbmRDaGlsZCh0aGlzLm1pbmlFZGl0b3IuZWxlbWVudClcbiAgICB0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQodGhpcy5tZXNzYWdlKVxuXG4gICAgdGhpcy5wYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZE1vZGFsUGFuZWwoe1xuICAgICAgaXRlbTogdGhpcyxcbiAgICAgIHZpc2libGU6IGZhbHNlXG4gICAgfSlcbiAgICBhdG9tLmNvbW1hbmRzLmFkZCgnYXRvbS10ZXh0LWVkaXRvcicsICdnby10by1saW5lOnRvZ2dsZScsICgpID0+IHtcbiAgICAgIHRoaXMudG9nZ2xlKClcbiAgICAgIHJldHVybiBmYWxzZVxuICAgIH0pXG4gICAgYXRvbS5jb21tYW5kcy5hZGQodGhpcy5taW5pRWRpdG9yLmVsZW1lbnQsICdjb3JlOmNvbmZpcm0nLCAoKSA9PiB7XG4gICAgICB0aGlzLm5hdmlnYXRlKClcbiAgICB9KVxuICAgIGF0b20uY29tbWFuZHMuYWRkKHRoaXMubWluaUVkaXRvci5lbGVtZW50LCAnY29yZTpjYW5jZWwnLCAoKSA9PiB7XG4gICAgICB0aGlzLmNsb3NlKClcbiAgICB9KVxuICAgIHRoaXMubWluaUVkaXRvci5vbldpbGxJbnNlcnRUZXh0KGFyZyA9PiB7XG4gICAgICBpZiAoYXJnLnRleHQubWF0Y2goL1teMC05Ol0vKSkge1xuICAgICAgICBhcmcuY2FuY2VsKClcbiAgICAgIH1cbiAgICB9KVxuICAgIHRoaXMubWluaUVkaXRvci5vbkRpZENoYW5nZSgoKSA9PiB7XG4gICAgICB0aGlzLm5hdmlnYXRlKHsga2VlcE9wZW46IHRydWUgfSlcbiAgICB9KVxuICB9XG5cbiAgdG9nZ2xlICgpIHtcbiAgICB0aGlzLnBhbmVsLmlzVmlzaWJsZSgpID8gdGhpcy5jbG9zZSgpIDogdGhpcy5vcGVuKClcbiAgfVxuXG4gIGNsb3NlICgpIHtcbiAgICBpZiAoIXRoaXMucGFuZWwuaXNWaXNpYmxlKCkpIHJldHVyblxuICAgIHRoaXMubWluaUVkaXRvci5zZXRUZXh0KCcnKVxuICAgIHRoaXMucGFuZWwuaGlkZSgpXG4gICAgaWYgKHRoaXMubWluaUVkaXRvci5lbGVtZW50Lmhhc0ZvY3VzKCkpIHtcbiAgICAgIHRoaXMucmVzdG9yZUZvY3VzKClcbiAgICB9XG4gIH1cblxuICBuYXZpZ2F0ZSAob3B0aW9ucyA9IHt9KSB7XG4gICAgY29uc3QgbGluZU51bWJlciA9IHRoaXMubWluaUVkaXRvci5nZXRUZXh0KClcbiAgICBjb25zdCBlZGl0b3IgPSBhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKClcbiAgICBpZiAoIW9wdGlvbnMua2VlcE9wZW4pIHtcbiAgICAgIHRoaXMuY2xvc2UoKVxuICAgIH1cbiAgICBpZiAoIWVkaXRvciB8fCAhbGluZU51bWJlci5sZW5ndGgpIHJldHVyblxuXG4gICAgY29uc3QgY3VycmVudFJvdyA9IGVkaXRvci5nZXRDdXJzb3JCdWZmZXJQb3NpdGlvbigpLnJvd1xuICAgIGNvbnN0IHJvd0xpbmVOdW1iZXIgPSBsaW5lTnVtYmVyLnNwbGl0KC86Ky8pWzBdIHx8ICcnXG4gICAgY29uc3Qgcm93ID1cbiAgICAgIHJvd0xpbmVOdW1iZXIubGVuZ3RoID4gMCA/IHBhcnNlSW50KHJvd0xpbmVOdW1iZXIpIC0gMSA6IGN1cnJlbnRSb3dcbiAgICBjb25zdCBjb2x1bW5MaW5lTnVtYmVyID0gbGluZU51bWJlci5zcGxpdCgvOisvKVsxXSB8fCAnJ1xuICAgIGNvbnN0IGNvbHVtbiA9XG4gICAgICBjb2x1bW5MaW5lTnVtYmVyLmxlbmd0aCA+IDAgPyBwYXJzZUludChjb2x1bW5MaW5lTnVtYmVyKSAtIDEgOiAtMVxuXG4gICAgY29uc3QgcG9zaXRpb24gPSBuZXcgUG9pbnQocm93LCBjb2x1bW4pXG4gICAgZWRpdG9yLnNldEN1cnNvckJ1ZmZlclBvc2l0aW9uKHBvc2l0aW9uKVxuICAgIGVkaXRvci51bmZvbGRCdWZmZXJSb3cocm93KVxuICAgIGlmIChjb2x1bW4gPCAwKSB7XG4gICAgICBlZGl0b3IubW92ZVRvRmlyc3RDaGFyYWN0ZXJPZkxpbmUoKVxuICAgIH1cbiAgICBlZGl0b3Iuc2Nyb2xsVG9CdWZmZXJQb3NpdGlvbihwb3NpdGlvbiwge1xuICAgICAgY2VudGVyOiB0cnVlXG4gICAgfSlcbiAgfVxuXG4gIHN0b3JlRm9jdXNlZEVsZW1lbnQgKCkge1xuICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50ID0gZG9jdW1lbnQuYWN0aXZlRWxlbWVudFxuICAgIHJldHVybiB0aGlzLnByZXZpb3VzbHlGb2N1c2VkRWxlbWVudFxuICB9XG5cbiAgcmVzdG9yZUZvY3VzICgpIHtcbiAgICBpZiAoXG4gICAgICB0aGlzLnByZXZpb3VzbHlGb2N1c2VkRWxlbWVudCAmJlxuICAgICAgdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQucGFyZW50RWxlbWVudFxuICAgICkge1xuICAgICAgcmV0dXJuIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50LmZvY3VzKClcbiAgICB9XG4gICAgYXRvbS52aWV3cy5nZXRWaWV3KGF0b20ud29ya3NwYWNlKS5mb2N1cygpXG4gIH1cblxuICBvcGVuICgpIHtcbiAgICBpZiAodGhpcy5wYW5lbC5pc1Zpc2libGUoKSB8fCAhYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpKSByZXR1cm5cbiAgICB0aGlzLnN0b3JlRm9jdXNlZEVsZW1lbnQoKVxuICAgIHRoaXMucGFuZWwuc2hvdygpXG4gICAgdGhpcy5tZXNzYWdlLnRleHRDb250ZW50ID1cbiAgICAgICdFbnRlciBhIDxyb3c+IG9yIDxyb3c+Ojxjb2x1bW4+IHRvIGdvIHRoZXJlLiBFeGFtcGxlczogXCIzXCIgZm9yIHJvdyAzIG9yIFwiMjo3XCIgZm9yIHJvdyAyIGFuZCBjb2x1bW4gNydcbiAgICB0aGlzLm1pbmlFZGl0b3IuZWxlbWVudC5mb2N1cygpXG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQge1xuICBhY3RpdmF0ZSAoKSB7XG4gICAgcmV0dXJuIG5ldyBHb1RvTGluZVZpZXcoKVxuICB9XG59XG4iXX0=