"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _issueishLink = require("./issueish-link");

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _prCheckoutController = require("../controllers/pr-checkout-controller");

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _patchPreviewView = _interopRequireDefault(require("./patch-preview-view"));

var _checkoutButton = _interopRequireDefault(require("./checkout-button"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const authorAssociationText = {
  MEMBER: 'Member',
  OWNER: 'Owner',
  COLLABORATOR: 'Collaborator',
  CONTRIBUTOR: 'Contributor',
  FIRST_TIME_CONTRIBUTOR: 'First-time contributor',
  FIRST_TIMER: 'First-timer',
  NONE: null
};

class ReviewsView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "logStartReviewClick", () => {
      (0, _reporterProxy.addEvent)('start-pr-review', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "renderReviewSummary", review => {
      const reviewTypes = type => {
        return {
          APPROVED: {
            icon: 'icon-check',
            copy: 'approved these changes'
          },
          COMMENTED: {
            icon: 'icon-comment',
            copy: 'commented'
          },
          CHANGES_REQUESTED: {
            icon: 'icon-alert',
            copy: 'requested changes'
          }
        }[type] || {
          icon: '',
          copy: ''
        };
      };

      const {
        icon,
        copy
      } = reviewTypes(review.state); // filter non actionable empty summary comments from this view

      if (review.state === 'PENDING' || review.state === 'COMMENTED' && review.bodyHTML === '') {
        return null;
      }

      const author = review.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: "github-ReviewSummary",
        key: review.id
      }, _react["default"].createElement("header", {
        className: "github-Review-header"
      }, _react["default"].createElement("div", {
        className: "github-Review-header-authorData"
      }, _react["default"].createElement("span", {
        className: `github-ReviewSummary-icon icon ${icon}`
      }), _react["default"].createElement("img", {
        className: "github-ReviewSummary-avatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement("a", {
        className: "github-ReviewSummary-username",
        href: author.url
      }, author.login), _react["default"].createElement("span", {
        className: "github-ReviewSummary-type"
      }, copy), this.renderEditedLink(review), this.renderAuthorAssociation(review)), _react["default"].createElement(_timeago["default"], {
        className: "github-ReviewSummary-timeAgo",
        time: review.submittedAt,
        displayStyle: "short"
      })), _react["default"].createElement("main", {
        className: "github-ReviewSummary-comment"
      }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
        html: review.bodyHTML,
        switchToIssueish: this.props.openIssueish,
        openIssueishLinkInNewTab: this.openIssueishLinkInNewTab
      }), _react["default"].createElement(_emojiReactionsController["default"], {
        reactable: review,
        tooltips: this.props.tooltips,
        reportMutationErrors: this.props.reportMutationErrors
      })));
    });

    _defineProperty(this, "renderReviewCommentThread", commentThread => {
      const {
        comments,
        thread
      } = commentThread;
      const rootComment = comments[0];

      if (!rootComment) {
        return null;
      }

      let threadHolder = this.threadHolders.get(thread.id);

      if (!threadHolder) {
        threadHolder = new _refHolder["default"]();
        this.threadHolders.set(thread.id, threadHolder);
      }

      const nativePath = (0, _helpers.toNativePathSep)(rootComment.path);

      const {
        dir,
        base
      } = _path["default"].parse(nativePath);

      const {
        lineNumber,
        positionText
      } = this.getTranslatedPosition(rootComment);
      const refJumpToFileButton = new _refHolder["default"]();
      const jumpToFileDisabledLabel = 'Checkout this pull request to enable Jump To File.';
      const elementId = `review-thread-${thread.id}`;
      const navButtonClasses = ['github-Review-navButton', 'icon', {
        outdated: !lineNumber
      }];
      const openFileClasses = (0, _classnames["default"])('icon-code', ...navButtonClasses);
      const openDiffClasses = (0, _classnames["default"])('icon-diff', ...navButtonClasses);
      const isOpen = this.props.threadIDsOpen.has(thread.id);
      const isHighlighted = this.props.highlightedThreadIDs.has(thread.id);

      const toggle = evt => {
        evt.preventDefault();
        evt.stopPropagation();

        if (isOpen) {
          this.props.hideThreadID(thread.id);
        } else {
          this.props.showThreadID(thread.id);
        }
      };

      const author = rootComment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("details", {
        ref: threadHolder.setter,
        className: (0, _classnames["default"])('github-Review', {
          'resolved': thread.isResolved,
          'github-Review--highlight': isHighlighted
        }),
        key: elementId,
        id: elementId,
        open: isOpen
      }, _react["default"].createElement("summary", {
        className: "github-Review-reference",
        onClick: toggle
      }, dir && _react["default"].createElement("span", {
        className: "github-Review-path"
      }, dir), _react["default"].createElement("span", {
        className: "github-Review-file"
      }, dir ? _path["default"].sep : '', base), _react["default"].createElement("span", {
        className: "github-Review-lineNr"
      }, positionText), _react["default"].createElement("img", {
        className: "github-Review-referenceAvatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement(_timeago["default"], {
        className: "github-Review-referenceTimeAgo",
        time: rootComment.createdAt,
        displayStyle: "short"
      })), _react["default"].createElement("nav", {
        className: "github-Review-nav"
      }, _react["default"].createElement("button", {
        className: openFileClasses,
        "data-path": nativePath,
        "data-line": lineNumber,
        onClick: this.openFile,
        disabled: this.props.checkoutOp.isEnabled(),
        ref: refJumpToFileButton.setter
      }, "Jump To File"), _react["default"].createElement("button", {
        className: openDiffClasses,
        "data-path": nativePath,
        "data-line": rootComment.position,
        onClick: this.openDiff
      }, "Open Diff"), this.props.checkoutOp.isEnabled() && _react["default"].createElement(_tooltip["default"], {
        manager: this.props.tooltips,
        target: refJumpToFileButton,
        title: jumpToFileDisabledLabel,
        showDelay: 200
      })), rootComment.position !== null && _react["default"].createElement(_patchPreviewView["default"], {
        multiFilePatch: this.props.multiFilePatch,
        fileName: nativePath,
        diffRow: rootComment.position,
        maxRowCount: this.props.contextLines,
        config: this.props.config
      }), this.renderThread({
        thread,
        comments
      }));
    });

    _defineProperty(this, "renderThread", ({
      thread,
      comments
    }) => {
      let replyHolder = this.replyHolders.get(thread.id);

      if (!replyHolder) {
        replyHolder = new _refHolder["default"]();
        this.replyHolders.set(thread.id, replyHolder);
      }

      const lastComment = comments[comments.length - 1];
      const isPosting = this.props.postingToThreadID !== null;
      return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("main", {
        className: "github-Review-comments"
      }, comments.map(this.renderComment), _react["default"].createElement("div", {
        className: (0, _classnames["default"])('github-Review-reply', {
          'github-Review-reply--disabled': isPosting
        }),
        "data-thread-id": thread.id
      }, _react["default"].createElement(_atomTextEditor["default"], {
        placeholderText: "Reply...",
        lineNumberGutterVisible: false,
        softWrapped: true,
        autoHeight: true,
        readOnly: isPosting,
        refModel: replyHolder
      }))), thread.isResolved && _react["default"].createElement("div", {
        className: "github-Review-resolvedText"
      }, "This conversation was marked as resolved by @", thread.resolvedBy.login), _react["default"].createElement("footer", {
        className: "github-Review-footer"
      }, _react["default"].createElement("button", {
        className: "github-Review-replyButton btn btn-primary",
        title: "Add your comment",
        disabled: isPosting,
        onClick: () => this.submitReply(replyHolder, thread, lastComment)
      }, "Comment"), this.renderResolveButton(thread)));
    });

    _defineProperty(this, "renderResolveButton", thread => {
      if (thread.isResolved) {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn icon icon-check",
          title: "Unresolve conversation",
          onClick: () => this.resolveUnresolveThread(thread)
        }, "Unresolve conversation");
      } else {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn icon icon-check",
          title: "Resolve conversation",
          onClick: () => this.resolveUnresolveThread(thread)
        }, "Resolve conversation");
      }
    });

    _defineProperty(this, "renderComment", comment => {
      if (comment.isMinimized) {
        return _react["default"].createElement("div", {
          className: "github-Review-comment github-Review-comment--hidden",
          key: comment.id
        }, _react["default"].createElement(_octicon["default"], {
          icon: 'fold',
          className: "github-Review-icon"
        }), _react["default"].createElement("em", null, "This comment was hidden"));
      }

      const commentClass = (0, _classnames["default"])('github-Review-comment', {
        'github-Review-comment--pending': comment.state === 'PENDING'
      });
      const author = comment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: commentClass,
        key: comment.id
      }, _react["default"].createElement("header", {
        className: "github-Review-header"
      }, _react["default"].createElement("div", {
        className: "github-Review-header-authorData"
      }, _react["default"].createElement("img", {
        className: "github-Review-avatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement("a", {
        className: "github-Review-username",
        href: author.url
      }, author.login), _react["default"].createElement("a", {
        className: "github-Review-timeAgo",
        href: comment.url
      }, _react["default"].createElement(_timeago["default"], {
        displayStyle: "long",
        time: comment.createdAt
      })), this.renderEditedLink(comment), this.renderAuthorAssociation(comment), comment.state === 'PENDING' && _react["default"].createElement("span", {
        className: "github-Review-pendingBadge badge badge-warning"
      }, "pending")), _react["default"].createElement("a", {
        className: "github-Review-reportAbuseLink",
        title: "report abuse",
        href: `https://github.com/contact/report-content?report=${encodeURIComponent(author.login)}&content_url=${encodeURIComponent(comment.url)}`
      }, _react["default"].createElement(_octicon["default"], {
        icon: "alert"
      }))), _react["default"].createElement("div", {
        className: "github-Review-text"
      }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
        html: comment.bodyHTML,
        switchToIssueish: this.props.openIssueish,
        openIssueishLinkInNewTab: this.openIssueishLinkInNewTab
      }), _react["default"].createElement(_emojiReactionsController["default"], {
        reactable: comment,
        tooltips: this.props.tooltips,
        reportMutationErrors: this.props.reportMutationErrors
      })));
    });

    _defineProperty(this, "openFile", evt => {
      if (!this.props.checkoutOp.isEnabled()) {
        const target = evt.currentTarget;
        this.props.openFile(target.dataset.path, target.dataset.line);
      }
    });

    _defineProperty(this, "openDiff", evt => {
      const target = evt.currentTarget;
      this.props.openDiff(target.dataset.path, parseInt(target.dataset.line, 10));
    });

    _defineProperty(this, "openIssueishLinkInNewTab", evt => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(evt.target.dataset.url);
      return this.props.openIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "submitCurrentComment", evt => {
      const threadID = evt.currentTarget.dataset.threadId;
      /* istanbul ignore if */

      if (!threadID) {
        return null;
      }

      const {
        thread,
        comments
      } = this.props.commentThreads.find(each => each.thread.id === threadID);
      const replyHolder = this.replyHolders.get(threadID);
      return this.submitReply(replyHolder, thread, comments[comments.length - 1]);
    });

    this.rootHolder = new _refHolder["default"]();
    this.replyHolders = new Map();
    this.threadHolders = new Map();
    this.state = {
      isRefreshing: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID) {
      this.scrollToThread(scrollToThreadID);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID && scrollToThreadID !== prevProps.scrollToThreadID) {
      this.scrollToThread(scrollToThreadID);
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Reviews",
      ref: this.rootHolder.setter
    }, this.renderCommands(), this.renderHeader(), _react["default"].createElement("div", {
      className: "github-Reviews-list"
    }, this.renderReviewSummaries(), this.renderReviewCommentThreads()));
  }

  renderCommands() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.rootHolder
    }, _react["default"].createElement(_commands.Command, {
      command: "github:more-context",
      callback: this.props.moreContext
    }), _react["default"].createElement(_commands.Command, {
      command: "github:less-context",
      callback: this.props.lessContext
    })), _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: ".github-Review-reply"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:submit-comment",
      callback: this.submitCurrentComment
    })));
  }

  renderHeader() {
    const refresh = () => {
      if (this.state.isRefreshing) {
        return;
      }

      this.setState({
        isRefreshing: true
      });
      const sub = this.props.refetch(() => {
        this.subs.remove(sub);
        this.setState({
          isRefreshing: false
        });
      });
      this.subs.add(sub);
    };

    return _react["default"].createElement("header", {
      className: "github-Reviews-topHeader"
    }, _react["default"].createElement("span", {
      className: "icon icon-comment-discussion"
    }), _react["default"].createElement("span", {
      className: "github-Reviews-headerTitle"
    }, "Reviews for\xA0", _react["default"].createElement("span", {
      className: "github-Reviews-clickable",
      onClick: this.props.openPR
    }, this.props.owner, "/", this.props.repo, "#", this.props.number)), _react["default"].createElement("button", {
      className: (0, _classnames["default"])('github-Reviews-headerButton github-Reviews-clickable icon icon-repo-sync', {
        refreshing: this.state.isRefreshing
      }),
      onClick: refresh
    }), _react["default"].createElement(_checkoutButton["default"], {
      checkoutOp: this.props.checkoutOp,
      classNamePrefix: "github-Reviews-checkoutButton--",
      classNames: ['github-Reviews-headerButton']
    }));
  }

  renderEmptyState() {
    const {
      number,
      repo,
      owner
    } = this.props; // todo: make this open the review flow in Atom instead of dotcom

    const pullRequestURL = `https://www.github.com/${owner}/${repo}/pull/${number}/files/`;
    return _react["default"].createElement("div", {
      className: "github-Reviews-emptyState"
    }, _react["default"].createElement("img", {
      src: "atom://github/img/mona.svg",
      alt: "Mona the octocat in spaaaccee",
      className: "github-Reviews-emptyImg"
    }), _react["default"].createElement("div", {
      className: "github-Reviews-emptyText"
    }, "This pull request has no reviews"), _react["default"].createElement("button", {
      className: "github-Reviews-emptyCallToActionButton btn"
    }, _react["default"].createElement("a", {
      href: pullRequestURL,
      onClick: this.logStartReviewClick
    }, "Start a new review")));
  }

  renderReviewSummaries() {
    if (this.props.summaries.length === 0) {
      return this.renderEmptyState();
    }

    const toggle = evt => {
      evt.preventDefault();

      if (this.props.summarySectionOpen) {
        this.props.hideSummaries();
      } else {
        this.props.showSummaries();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section summaries",
      open: this.props.summarySectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggle
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Summaries")), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, this.props.summaries.map(this.renderReviewSummary)));
  }

  renderReviewCommentThreads() {
    const commentThreads = this.props.commentThreads;

    if (commentThreads.length === 0) {
      return null;
    }

    const resolvedThreads = commentThreads.filter(pair => pair.thread.isResolved);
    const unresolvedThreads = commentThreads.filter(pair => !pair.thread.isResolved);

    const toggleComments = evt => {
      evt.preventDefault();

      if (this.props.commentSectionOpen) {
        this.props.hideComments();
      } else {
        this.props.showComments();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section comments",
      open: this.props.commentSectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggleComments
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Comments"), _react["default"].createElement("span", {
      className: "github-Reviews-progress"
    }, _react["default"].createElement("span", {
      className: "github-Reviews-count"
    }, "Resolved", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, resolvedThreads.length), ' ', "of", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, resolvedThreads.length + unresolvedThreads.length)), _react["default"].createElement("progress", {
      className: "github-Reviews-progessBar",
      value: resolvedThreads.length,
      max: resolvedThreads.length + unresolvedThreads.length
    }))), unresolvedThreads.length > 0 && _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, unresolvedThreads.map(this.renderReviewCommentThread)), resolvedThreads.length > 0 && _react["default"].createElement("details", {
      className: "github-Reviews-section resolved-comments",
      open: true
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header"
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Resolved")), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, resolvedThreads.map(this.renderReviewCommentThread))));
  }

  renderEditedLink(entity) {
    if (!entity.lastEditedAt) {
      return null;
    } else {
      return _react["default"].createElement("span", {
        className: "github-Review-edited"
      }, "\xA0\u2022\xA0", _react["default"].createElement("a", {
        className: "github-Review-edited",
        href: entity.url
      }, "edited"));
    }
  }

  renderAuthorAssociation(entity) {
    const text = authorAssociationText[entity.authorAssociation];

    if (!text) {
      return null;
    }

    return _react["default"].createElement("span", {
      className: "github-Review-authorAssociationBadge badge"
    }, text);
  }

  submitReply(replyHolder, thread, lastComment) {
    const body = replyHolder.map(editor => editor.getText()).getOr('');

    const didSubmitComment = () => replyHolder.map(editor => editor.setText('', {
      bypassReadOnly: true
    }));

    const didFailComment = () => replyHolder.map(editor => editor.setText(body, {
      bypassReadOnly: true
    }));

    return this.props.addSingleComment(body, thread.id, lastComment.id, lastComment.path, lastComment.position, {
      didSubmitComment,
      didFailComment
    });
  }

  getTranslatedPosition(rootComment) {
    let lineNumber, positionText;
    const translations = this.props.commentTranslations;

    const isCheckedOutPullRequest = this.props.checkoutOp.why() === _prCheckoutController.checkoutStates.CURRENT;

    if (translations === null) {
      lineNumber = null;
      positionText = '';
    } else if (rootComment.position === null) {
      lineNumber = null;
      positionText = 'outdated';
    } else {
      const translationsForFile = translations.get(rootComment.path);
      lineNumber = translationsForFile.diffToFilePosition.get(parseInt(rootComment.position, 10));

      if (translationsForFile.fileTranslations && isCheckedOutPullRequest) {
        lineNumber = translationsForFile.fileTranslations.get(lineNumber).newPosition;
      }

      positionText = lineNumber;
    }

    return {
      lineNumber,
      positionText
    };
  }
  /* istanbul ignore next */


  scrollToThread(threadID) {
    const threadHolder = this.threadHolders.get(threadID);

    if (threadHolder) {
      threadHolder.map(element => {
        element.scrollIntoViewIfNeeded();
        return null; // shh, eslint
      });
    }
  }

  async resolveUnresolveThread(thread) {
    if (thread.isResolved) {
      await this.props.unresolveThread(thread);
    } else {
      await this.props.resolveThread(thread);
    }
  }

}

exports["default"] = ReviewsView;

_defineProperty(ReviewsView, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].object.isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  multiFilePatch: _propTypes["default"].object.isRequired,
  contextLines: _propTypes["default"].number.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  summarySectionOpen: _propTypes["default"].bool.isRequired,
  commentSectionOpen: _propTypes["default"].bool.isRequired,
  threadIDsOpen: _propTypes["default"].shape({
    has: _propTypes["default"].func.isRequired
  }),
  highlightedThreadIDs: _propTypes["default"].shape({
    has: _propTypes["default"].func.isRequired
  }),
  postingToThreadID: _propTypes["default"].string,
  scrollToThreadID: _propTypes["default"].string,
  // Structure: Map< relativePath: String, {
  //   rawPositions: Set<lineNumbers: Number>,
  //   diffToFilePosition: Map<rawPosition: Number, adjustedPosition: Number>,
  //   fileTranslations: null | Map<adjustedPosition: Number, {newPosition: Number}>,
  //   digest: String,
  // }>
  commentTranslations: _propTypes["default"].object,
  // for the dotcom link in the empty state
  number: _propTypes["default"].number.isRequired,
  repo: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  openFile: _propTypes["default"].func.isRequired,
  openDiff: _propTypes["default"].func.isRequired,
  openPR: _propTypes["default"].func.isRequired,
  moreContext: _propTypes["default"].func.isRequired,
  lessContext: _propTypes["default"].func.isRequired,
  openIssueish: _propTypes["default"].func.isRequired,
  showSummaries: _propTypes["default"].func.isRequired,
  hideSummaries: _propTypes["default"].func.isRequired,
  showComments: _propTypes["default"].func.isRequired,
  hideComments: _propTypes["default"].func.isRequired,
  showThreadID: _propTypes["default"].func.isRequired,
  hideThreadID: _propTypes["default"].func.isRequired,
  resolveThread: _propTypes["default"].func.isRequired,
  unresolveThread: _propTypes["default"].func.isRequired,
  addSingleComment: _propTypes["default"].func.isRequired,
  reportMutationErrors: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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