"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accordion extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'toggle');
    this.state = {
      expanded: true
    };
  }

  render() {
    return _react["default"].createElement("details", {
      className: "github-Accordion",
      open: this.state.expanded
    }, _react["default"].createElement("summary", {
      className: "github-Accordion-header",
      onClick: this.toggle
    }, this.renderHeader()), _react["default"].createElement("main", {
      className: "github-Accordion-content"
    }, this.renderContent()));
  }

  renderHeader() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("span", {
      className: "github-Accordion--leftTitle"
    }, this.props.leftTitle), this.props.rightTitle && _react["default"].createElement("span", {
      className: "github-Accordion--rightTitle"
    }, this.props.rightTitle), this.props.reviewsButton());
  }

  renderContent() {
    if (this.props.isLoading) {
      const Loading = this.props.loadingComponent;
      return _react["default"].createElement(Loading, null);
    }

    if (this.props.results.length === 0) {
      const Empty = this.props.emptyComponent;
      return _react["default"].createElement(Empty, null);
    }

    if (!this.state.expanded) {
      return null;
    }

    const More = this.props.moreComponent;
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("ul", {
      className: "github-Accordion-list"
    }, this.props.results.map((item, index) => {
      const key = item.key !== undefined ? item.key : index;
      return _react["default"].createElement("li", {
        className: "github-Accordion-listItem",
        key: key,
        onClick: () => this.props.onClickItem(item)
      }, this.props.children(item));
    })), this.props.results.length < this.props.total && _react["default"].createElement(More, null));
  }

  toggle(e) {
    e.preventDefault();
    return new Promise(resolve => {
      this.setState(prevState => ({
        expanded: !prevState.expanded
      }), resolve);
    });
  }

}

exports["default"] = Accordion;

_defineProperty(Accordion, "propTypes", {
  leftTitle: _propTypes["default"].string.isRequired,
  rightTitle: _propTypes["default"].string,
  results: _propTypes["default"].arrayOf(_propTypes["default"].any).isRequired,
  total: _propTypes["default"].number.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  loadingComponent: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  moreComponent: _propTypes["default"].func,
  reviewsButton: _propTypes["default"].func,
  onClickItem: _propTypes["default"].func,
  children: _propTypes["default"].func.isRequired
});

_defineProperty(Accordion, "defaultProps", {
  loadingComponent: () => null,
  emptyComponent: () => null,
  moreComponent: () => null,
  onClickItem: () => {},
  reviewsButton: () => null
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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