"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

var _moment = _interopRequireDefault(require("moment"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewCommentMutation.graphql");

  if (node.hash && node.hash !== "75ec864a015eb9def27a9f6fcd181c83") {
    console.error("The definition of 'addPrReviewCommentMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewCommentMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  inReplyTo,
  reviewID,
  threadID,
  viewerID,
  path,
  position
}) => {
  const variables = {
    input: {
      body,
      inReplyTo,
      pullRequestReviewId: reviewID
    }
  };
  const configs = [{
    type: 'RANGE_ADD',
    parentID: threadID,
    connectionInfo: [{
      key: 'ReviewCommentsAccumulator_comments',
      rangeBehavior: 'append'
    }],
    edgeName: 'commentEdge'
  }];

  function optimisticUpdater(store) {
    const reviewThread = store.get(threadID);

    if (!reviewThread) {
      return;
    }

    const id = `add-pr-review-comment:comment:${placeholderID++}`;
    const comment = store.create(id, 'PullRequestReviewComment');
    comment.setValue(id, 'id');
    comment.setValue(`<em>${body}</em>`, 'bodyHTML');
    comment.setValue(false, 'isMinimized');
    comment.setValue(false, 'viewerCanMinimize');
    comment.setValue(false, 'viewerCanReact');
    comment.setValue((0, _moment["default"])().toISOString(), 'createdAt');
    comment.setValue(null, 'lastEditedAt');
    comment.setValue('NONE', 'authorAssociation');
    comment.setValue('https://github.com', 'url');
    comment.setValue(path, 'path');
    comment.setValue(position, 'position');
    comment.setLinkedRecords([], 'reactionGroups');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    comment.setLinkedRecord(author, 'author');

    const comments = _relayRuntime.ConnectionHandler.getConnection(reviewThread, 'ReviewCommentsAccumulator_comments');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, comments, comment, 'PullRequestReviewCommentEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(comments, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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