"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _multiFilePatchController = _interopRequireDefault(require("../controllers/multi-file-patch-controller"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestChangedFilesContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderPatchResult", (error, multiFilePatch) => {
      if (error === null && multiFilePatch === null) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (error !== null) {
        return _react["default"].createElement(_errorView["default"], {
          descriptions: [error]
        });
      }

      if (multiFilePatch !== this.lastPatch.patch) {
        this.lastPatch.subs.dispose();
        this.lastPatch = {
          subs: new _eventKit.CompositeDisposable(...multiFilePatch.getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => this.forceUpdate()))),
          patch: multiFilePatch
        };
      }

      return _react["default"].createElement(_multiFilePatchController["default"], _extends({
        multiFilePatch: multiFilePatch,
        repository: this.props.localRepository,
        reviewCommentsLoading: this.props.reviewCommentsLoading,
        reviewCommentThreads: this.props.reviewCommentThreads
      }, this.props));
    });

    this.lastPatch = {
      patch: null,
      subs: new _eventKit.CompositeDisposable()
    };
  }

  componentWillUnmount() {
    this.lastPatch.subs.dispose();
  }

  render() {
    const patchProps = {
      owner: this.props.owner,
      repo: this.props.repo,
      number: this.props.number,
      endpoint: this.props.endpoint,
      token: this.props.token,
      refetch: this.props.shouldRefetch
    };
    return _react["default"].createElement(_prPatchContainer["default"], patchProps, this.renderPatchResult);
  }

}

exports["default"] = PullRequestChangedFilesContainer;

_defineProperty(PullRequestChangedFilesContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  // action methods
  destroy: _propTypes["default"].func.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // local repo as opposed to pull request repo
  localRepository: _propTypes["default"].object.isRequired,
  workdirPath: _propTypes["default"].string,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // refetch diff on refresh
  shouldRefetch: _propTypes["default"].bool.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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