/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.java;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MetadataParserImpl;
import java.io.IOException;
import java.nio.charset.Charset;

final class FLVMetadataParser
extends MetadataParserImpl {
    private int dataSize = 0;
    private static final String CHARSET_UTF_8 = "UTF-8";

    public FLVMetadataParser(Locator locator) {
        super(locator);
    }

    @Override
    protected void parse() {
        block5: {
            try {
                if (this.getNextByte() != 70 || this.getNextByte() != 76 || this.getNextByte() != 86) break block5;
                this.skipBytes(2);
                int dataOffset = this.getInteger();
                this.skipBytes(dataOffset - 9);
                int tagCount = 0;
                for (tagCount = 0; tagCount < 10; ++tagCount) {
                    this.skipBytes(4);
                    byte tagType = this.getNextByte();
                    this.dataSize = this.getU24();
                    this.skipBytes(7);
                    if (tagType == 18) {
                        int expectedEndPosition = this.getStreamPosition() + this.dataSize;
                        if (!this.parseDataTag()) {
                            if (this.getStreamPosition() >= expectedEndPosition) continue;
                            this.skipBytes(expectedEndPosition - this.getStreamPosition());
                            continue;
                        }
                        break;
                    }
                    this.skipBytes(this.dataSize);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseDataTag() throws IOException {
        if (this.dataSize < 14) {
            return false;
        }
        byte[] header = new byte[14];
        for (int ii = 0; ii < 14; ++ii) {
            header[ii] = this.getNextByte();
        }
        if (header[0] != 2) {
            return false;
        }
        int nameSize = (header[1] & 0xFF) << 8 | header[2] & 0xFF;
        if (nameSize != 10) {
            return false;
        }
        if (!Charset.isSupported(CHARSET_UTF_8)) {
            return false;
        }
        String methodName = new String(header, 3, nameSize, Charset.forName(CHARSET_UTF_8));
        if (!methodName.equals("onMetaData")) {
            return false;
        }
        if (header[13] != 8) {
            if (Logger.canLog(3)) {
                Logger.logMsg(3, "FLV metadata must be in an ECMA array");
            }
            return false;
        }
        this.startRawMetadata(this.dataSize);
        if (null == this.rawMetaBlob) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Unable to allocate buffer for FLV metadata");
            }
            return false;
        }
        this.stuffRawMetadata(header, 0, 14);
        this.readRawMetadata(this.dataSize - 14);
        this.setParseRawMetadata(true);
        this.skipBytes(14);
        try {
            int arrayCount = this.getInteger();
            int parseCount = 0;
            boolean done = false;
            boolean warnMalformed = false;
            do {
                Object value;
                String attribute = this.getString(this.getShort(), Charset.forName(CHARSET_UTF_8));
                FlvDataValue flvValue = this.readDataValue(false);
                ++parseCount;
                String tag = this.convertTag(attribute);
                if (Logger.canLog(1) && !attribute.equals("")) {
                    Logger.logMsg(1, parseCount + ": \"" + attribute + "\" -> " + (null == tag ? "(unsupported)" : "\"" + tag + "\""));
                }
                if (tag != null && (value = this.convertValue(attribute, flvValue.obj)) != null) {
                    this.addMetadataItem(tag, value);
                }
                if (parseCount < arrayCount) continue;
                if (this.getStreamPosition() < this.dataSize) {
                    if (warnMalformed || !Logger.canLog(3)) continue;
                    Logger.logMsg(3, "FLV Source has malformed metadata, invalid ECMA element count");
                    warnMalformed = true;
                    continue;
                }
                done = true;
            } while (!done);
        }
        catch (Exception e) {
            if (Logger.canLog(3)) {
                Logger.logMsg(3, "Exception while processing FLV metadata: " + e);
            }
        }
        finally {
            if (null != this.rawMetaBlob) {
                this.setParseRawMetadata(false);
                this.addRawMetadata("FLV");
                this.disposeRawMetadata();
            }
            this.done();
        }
        return true;
    }

    private FlvDataValue readDataValue(boolean hasName) throws IOException {
        FlvDataValue sdv = new FlvDataValue();
        if (hasName) {
            this.skipBytes(this.getShort());
        }
        sdv.type = this.getNextByte();
        switch (sdv.type) {
            case 0: {
                sdv.obj = this.getDouble();
                break;
            }
            case 1: {
                boolean b = this.getNextByte() != 0;
                sdv.obj = b;
                break;
            }
            case 2: {
                sdv.obj = this.getString(this.getShort(), Charset.forName(CHARSET_UTF_8));
                break;
            }
            case 3: {
                this.skipObject();
                break;
            }
            case 4: {
                this.getString(this.getShort(), Charset.forName(CHARSET_UTF_8));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.skipBytes(2);
                break;
            }
            case 8: {
                this.skipArray();
                break;
            }
            case 9: {
                sdv.scriptDataObjectEnd = true;
                break;
            }
            case 10: {
                this.skipStrictArray();
                break;
            }
            case 11: {
                sdv.obj = this.getDouble();
                this.skipBytes(2);
                break;
            }
            case 12: {
                sdv.obj = this.getString(this.getInteger(), Charset.forName(CHARSET_UTF_8));
                break;
            }
        }
        return sdv;
    }

    private void skipObject() throws IOException {
        FlvDataValue value;
        do {
            value = this.readDataValue(true);
        } while (!value.scriptDataObjectEnd);
    }

    private void skipArray() throws IOException {
        int arrayCount = this.getInteger();
        for (int parseCount = 0; parseCount < arrayCount; ++parseCount) {
            this.readDataValue(true);
        }
    }

    private void skipStrictArray() throws IOException {
        long arrayLen = this.getInteger();
        int i = 0;
        while ((long)i < arrayLen) {
            this.readDataValue(false);
            ++i;
        }
    }

    private String convertTag(String tag) {
        if (tag.equals("duration")) {
            return "duration";
        }
        if (tag.equals("width")) {
            return "width";
        }
        if (tag.equals("height")) {
            return "height";
        }
        if (tag.equals("framerate")) {
            return "framerate";
        }
        if (tag.equals("videocodecid")) {
            return "video codec";
        }
        if (tag.equals("audiocodecid")) {
            return "audio codec";
        }
        if (tag.equals("creationdate")) {
            return "creationdate";
        }
        return null;
    }

    private static class FlvDataValue {
        static final byte NUMBER = 0;
        static final byte BOOLEAN = 1;
        static final byte STRING = 2;
        static final byte OBJECT = 3;
        static final byte MOVIE_CLIP = 4;
        static final byte NULL = 5;
        static final byte UNDEFINED = 6;
        static final byte REFERENCE = 7;
        static final byte ECMA_ARRAY = 8;
        static final byte END_OF_DATA = 9;
        static final byte STRICT_ARRAY = 10;
        static final byte DATE = 11;
        static final byte LONG_STRING = 12;
        boolean scriptDataObjectEnd = false;
        Object obj;
        byte type;

        private FlvDataValue() {
        }
    }
}

