/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.VariantUserDefined;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.AbstractParamContainerPanel;
import org.zaproxy.zap.extension.ascan.CustomScanPanel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.OptionsVariantPanel;
import org.zaproxy.zap.extension.ascan.PolicyAllCategoryPanel;
import org.zaproxy.zap.extension.ascan.PolicyCategoryPanel;
import org.zaproxy.zap.extension.ascan.PolicyManager;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.StandardFieldsDialog;
import org.zaproxy.zap.view.TechnologyTreePanel;

public class CustomScanDialog
extends StandardFieldsDialog {
    protected static final String[] STD_TAB_LABELS = new String[]{"ascan.custom.tab.scope", "ascan.custom.tab.input", "ascan.custom.tab.custom", "ascan.custom.tab.tech", "ascan.custom.tab.policy"};
    private static final String FIELD_START = "ascan.custom.label.start";
    private static final String FIELD_POLICY = "ascan.custom.label.policy";
    private static final String FIELD_CONTEXT = "ascan.custom.label.context";
    private static final String FIELD_USER = "ascan.custom.label.user";
    private static final String FIELD_RECURSE = "ascan.custom.label.recurse";
    private static final String FIELD_ADVANCED = "ascan.custom.label.adv";
    private static final Logger logger = Logger.getLogger(CustomScanDialog.class);
    private static final long serialVersionUID = 1L;
    private JButton[] extraButtons = null;
    private ExtensionActiveScan extension = null;
    private final ExtensionUserManagement extUserMgmt = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
    private int headerLength = -1;
    private int urlPathStart = -1;
    private Target target = null;
    private ScannerParam scannerParam = null;
    private JPanel customPanel = null;
    private JPanel techPanel = null;
    private ZapTextArea requestField = null;
    private JButton addCustomButton = null;
    private JButton removeCustomButton = null;
    private JList<Highlighter.Highlight> injectionPointList = null;
    private final DefaultListModel<Highlighter.Highlight> injectionPointModel = new DefaultListModel();
    private final JLabel customPanelStatus = new JLabel();
    private JCheckBox disableNonCustomVectors = null;
    private TechnologyTreePanel techTree;
    private TechSet techTreeState;
    private String scanPolicyName;
    private ScanPolicy scanPolicy = null;
    private OptionsVariantPanel variantPanel = null;
    private List<CustomScanPanel> customPanels = null;
    private boolean showingAdvTabs = true;
    private ScanPolicyPanel policyPanel;

    public CustomScanDialog(ExtensionActiveScan ext, String[] tabLabels, List<CustomScanPanel> customPanels, Frame owner, Dimension dim) {
        super(owner, "ascan.custom.title", dim, tabLabels);
        this.extension = ext;
        this.customPanels = customPanels;
        this.policyPanel = new ScanPolicyPanel(this, this.extension, Constant.messages.getString("ascan.custom.tab.policy"), new ScanPolicy());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CustomScanDialog.this.scanPolicy = null;
            }
        });
        this.reset(false);
    }

    public void init(Target target) {
        if (target != null) {
            this.target = target;
        }
        logger.debug((Object)("init " + this.target));
        this.removeAllFields();
        this.injectionPointModel.clear();
        this.getRequestField().getHighlighter().removeAllHighlights();
        this.headerLength = -1;
        this.urlPathStart = -1;
        if (this.scanPolicyName != null && PolicyManager.policyExists(this.scanPolicyName)) {
            try {
                this.scanPolicy = this.extension.getPolicyManager().getPolicy(this.scanPolicyName);
            }
            catch (ConfigurationException e) {
                logger.warn((Object)("Failed to load scan policy (" + this.scanPolicyName + "):"), (Throwable)e);
            }
        }
        if (this.scanPolicy == null) {
            this.scanPolicy = this.extension.getPolicyManager().getDefaultScanPolicy();
            this.scanPolicyName = this.scanPolicy.getName();
        }
        this.addTargetSelectField(0, FIELD_START, this.target, false, false);
        this.addComboField(0, FIELD_POLICY, this.extension.getPolicyManager().getAllPolicyNames(), this.scanPolicy.getName());
        this.addComboField(0, FIELD_CONTEXT, new String[0], "");
        this.addComboField(0, FIELD_USER, new String[0], "");
        this.addCheckBoxField(0, FIELD_RECURSE, true);
        this.addCheckBoxField(0, FIELD_ADVANCED, this.extension.getScannerParam().isShowAdvancedDialog());
        this.addFieldListener(FIELD_POLICY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomScanDialog.this.policySelected();
            }
        });
        this.addPadding(0);
        this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.recurse"));
        this.addFieldListener(FIELD_CONTEXT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomScanDialog.this.setUsers();
                CustomScanDialog.this.setTech();
            }
        });
        this.addFieldListener(FIELD_RECURSE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomScanDialog.this.setFieldStates();
            }
        });
        this.addFieldListener(FIELD_ADVANCED, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomScanDialog.this.setAdvancedOptions(CustomScanDialog.this.getBoolValue(CustomScanDialog.FIELD_ADVANCED));
            }
        });
        this.getVariantPanel().initParam(this.scannerParam);
        this.setCustomTabPanel(1, this.getVariantPanel());
        this.setCustomTabPanel(2, this.getCustomPanel());
        this.setCustomTabPanel(3, this.getTechPanel());
        this.setTechSet(this.techTreeState);
        this.setCustomTabPanel(4, this.policyPanel);
        int cIndex = 5;
        if (this.customPanels != null) {
            for (CustomScanPanel customPanel : this.customPanels) {
                this.setCustomTabPanel(cIndex, customPanel.getPanel(true));
                ++cIndex;
            }
        }
        if (target != null) {
            this.populateRequestField(this.target.getStartNode());
            this.targetSelected(FIELD_START, this.target);
            this.setUsers();
            this.setTech();
        }
        this.setAdvancedOptions(this.extension.getScannerParam().isShowAdvancedDialog());
        this.pack();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.advascan";
    }

    private void policySelected() {
        String policyName = this.getStringValue(FIELD_POLICY);
        try {
            this.scanPolicy = this.extension.getPolicyManager().getPolicy(policyName);
            this.policyPanel.setScanPolicy(this.scanPolicy);
            this.scanPolicyName = policyName;
        }
        catch (ConfigurationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setAdvancedOptions(boolean adv) {
        this.getField(FIELD_POLICY).setEnabled(!adv);
        if (adv) {
            ((JComboBox)this.getField(FIELD_POLICY)).setToolTipText(Constant.messages.getString("ascan.custom.tooltip.policy"));
        } else {
            ((JComboBox)this.getField(FIELD_POLICY)).setToolTipText("");
        }
        if (this.showingAdvTabs == adv) {
            return;
        }
        this.setTabsVisible(new String[]{"ascan.custom.tab.input", "ascan.custom.tab.custom", "ascan.custom.tab.tech", "ascan.custom.tab.policy"}, adv);
        if (this.customPanels != null) {
            for (CustomScanPanel customPanel : this.customPanels) {
                this.setTabsVisible(new String[]{customPanel.getLabel()}, adv);
            }
        }
        this.showingAdvTabs = adv;
        this.extension.getScannerParam().setShowAdvancedDialog(adv);
    }

    private void populateRequestField(SiteNode node) {
        try {
            if (node == null || node.getHistoryReference() == null || node.getHistoryReference().getHttpMessage() == null) {
                this.getRequestField().setText("");
            } else {
                HttpMessage msg = node.getHistoryReference().getHttpMessage();
                String header = msg.getRequestHeader().toString();
                StringBuilder sb = new StringBuilder();
                sb.append(header);
                this.headerLength = header.length();
                this.urlPathStart = header.indexOf("/", header.indexOf("://") + 2) + 1;
                sb.append(msg.getRequestBody().toString());
                this.getRequestField().setText(sb.toString());
                JCheckBox recurseChk = (JCheckBox)this.getField(FIELD_RECURSE);
                recurseChk.setEnabled(node.getChildCount() > 0);
                recurseChk.setSelected(node.getChildCount() > 0);
            }
            this.setFieldStates();
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            this.getRequestField().setText("");
        }
    }

    @Override
    public void targetSelected(String field, Target node) {
        ArrayList<String> ctxNames = new ArrayList<String>();
        if (node != null) {
            this.target = node;
            if (node.getStartNode() != null) {
                this.populateRequestField(node.getStartNode());
                Session session = Model.getSingleton().getSession();
                List<Context> contexts = session.getContextsForNode(node.getStartNode());
                for (Context context : contexts) {
                    ctxNames.add(context.getName());
                }
            } else if (node.getContext() != null) {
                ctxNames.add(node.getContext().getName());
            }
            this.setTech();
        }
        this.setComboFields(FIELD_CONTEXT, ctxNames, "");
        this.getField(FIELD_CONTEXT).setEnabled(ctxNames.size() > 0);
    }

    private Context getSelectedContext() {
        String ctxName = this.getStringValue(FIELD_CONTEXT);
        if (this.extUserMgmt != null && !this.isEmptyField(FIELD_CONTEXT)) {
            Session session = Model.getSingleton().getSession();
            return session.getContext(ctxName);
        }
        return null;
    }

    private User getSelectedUser() {
        Context context = this.getSelectedContext();
        if (context != null) {
            String userName = this.getStringValue(FIELD_USER);
            List<User> users = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            for (User user : users) {
                if (!userName.equals(user.getName())) continue;
                return user;
            }
        }
        return null;
    }

    private void setUsers() {
        Context context = this.getSelectedContext();
        ArrayList<String> userNames = new ArrayList<String>();
        if (context != null) {
            List<User> users = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            userNames.add("");
            for (User user : users) {
                userNames.add(user.getName());
            }
        }
        this.setComboFields(FIELD_USER, userNames, "");
        this.getField(FIELD_USER).setEnabled(userNames.size() > 1);
    }

    private void setTech() {
        Context context = this.getSelectedContext();
        this.setTechSet(context != null ? context.getTechSet() : null);
    }

    private void setTechSet(TechSet techSet) {
        if (techSet != null) {
            this.techTree.setTechSet(techSet);
        } else {
            this.techTree.reset();
        }
        this.techTreeState = techSet;
    }

    private ZapTextArea getRequestField() {
        if (this.requestField == null) {
            this.requestField = new ZapTextArea();
            this.requestField.setEditable(false);
            this.requestField.setLineWrap(true);
            this.requestField.getCaret().setVisible(true);
        }
        return this.requestField;
    }

    private OptionsVariantPanel getVariantPanel() {
        if (this.variantPanel == null) {
            this.variantPanel = new OptionsVariantPanel();
            this.variantPanel.setReasonVariantsDisabled(Constant.messages.getString("ascan.custom.warn.disabled"));
        }
        return this.variantPanel;
    }

    private JPanel getCustomPanel() {
        if (this.customPanel == null) {
            this.customPanel = new JPanel(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setViewportView(this.getRequestField());
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            this.getRequestField().addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent event) {
                    CustomScanDialog.this.setFieldStates();
                }
            });
            buttonPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 0, 1, 0.5));
            buttonPanel.add((Component)this.getAddCustomButton(), LayoutHelper.getGBC(1, 0, 1, 1, 0.0, 0.0, 1, 18, new Insets(5, 5, 5, 5)));
            buttonPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.5));
            buttonPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 1, 1, 0.5));
            buttonPanel.add((Component)this.getRemoveCustomButton(), LayoutHelper.getGBC(1, 1, 1, 1, 0.0, 0.0, 1, 18, new Insets(5, 5, 5, 5)));
            buttonPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 1, 1, 0.5));
            JScrollPane scrollPane2 = new JScrollPane(this.getInjectionPointList());
            scrollPane2.setVerticalScrollBarPolicy(20);
            buttonPanel.add((Component)new JLabel(Constant.messages.getString("ascan.custom.label.vectors")), LayoutHelper.getGBC(0, 2, 3, 0.0, 0.0));
            buttonPanel.add((Component)scrollPane2, LayoutHelper.getGBC(0, 3, 3, 1.0, 1.0));
            JSplitPane splitPane = new JSplitPane(1, scrollPane, buttonPanel);
            splitPane.setDividerLocation(550);
            this.customPanel.add((Component)splitPane, LayoutHelper.getGBC(0, 0, 1, 1, 1.0, 1.0));
            this.customPanel.add((Component)this.customPanelStatus, LayoutHelper.getGBC(0, 1, 1, 1, 1.0, 0.0));
            this.customPanel.add((Component)this.getDisableNonCustomVectors(), LayoutHelper.getGBC(0, 2, 1, 1, 1.0, 0.0));
        }
        return this.customPanel;
    }

    private JButton getAddCustomButton() {
        if (this.addCustomButton == null) {
            this.addCustomButton = new JButton(Constant.messages.getString("ascan.custom.button.pt.add"));
            this.addCustomButton.setEnabled(false);
            this.addCustomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int userDefStart = CustomScanDialog.this.getRequestField().getSelectionStart();
                    if (userDefStart >= 0) {
                        int userDefEnd = CustomScanDialog.this.getRequestField().getSelectionEnd();
                        Highlighter hl = CustomScanDialog.this.getRequestField().getHighlighter();
                        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.RED);
                        try {
                            Highlighter.Highlight hlt = (Highlighter.Highlight)hl.addHighlight(userDefStart, userDefEnd, painter);
                            CustomScanDialog.this.injectionPointModel.addElement(hlt);
                            CustomScanDialog.this.getRequestField().setSelectionStart(userDefEnd);
                            CustomScanDialog.this.getRequestField().setSelectionEnd(userDefEnd);
                            CustomScanDialog.this.getRequestField().getCaret().setVisible(true);
                        }
                        catch (BadLocationException e1) {
                            logger.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.addCustomButton;
    }

    private JButton getRemoveCustomButton() {
        if (this.removeCustomButton == null) {
            this.removeCustomButton = new JButton(Constant.messages.getString("ascan.custom.button.pt.rem"));
            this.removeCustomButton.setEnabled(false);
            this.removeCustomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int userDefStart = CustomScanDialog.this.getRequestField().getSelectionStart();
                    if (userDefStart >= 0) {
                        int userDefEnd = CustomScanDialog.this.getRequestField().getSelectionEnd();
                        Highlighter hltr = CustomScanDialog.this.getRequestField().getHighlighter();
                        Highlighter.Highlight[] hls = hltr.getHighlights();
                        if (hls != null && hls.length > 0) {
                            for (Highlighter.Highlight hl : hls) {
                                if (!CustomScanDialog.this.selectionIncludesHighlight(userDefStart, userDefEnd, hl)) continue;
                                hltr.removeHighlight(hl);
                                CustomScanDialog.this.injectionPointModel.removeElement(hl);
                            }
                        }
                        CustomScanDialog.this.getRequestField().setSelectionStart(userDefEnd);
                        CustomScanDialog.this.getRequestField().setSelectionEnd(userDefEnd);
                        CustomScanDialog.this.getRequestField().getCaret().setVisible(true);
                    }
                }
            });
        }
        return this.removeCustomButton;
    }

    private JCheckBox getDisableNonCustomVectors() {
        if (this.disableNonCustomVectors == null) {
            this.disableNonCustomVectors = new JCheckBox(Constant.messages.getString("ascan.custom.label.disableiv"));
            this.disableNonCustomVectors.addActionListener(e -> this.getVariantPanel().setAllInjectableAndRPC(!this.disableNonCustomVectors.isSelected()));
        }
        return this.disableNonCustomVectors;
    }

    private JPanel getTechPanel() {
        if (this.techPanel == null) {
            this.techPanel = new JPanel(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setViewportView(this.getTechTree());
            scrollPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.techPanel.add((Component)scrollPane, LayoutHelper.getGBC(0, 0, 1, 1, 1.0, 1.0));
        }
        return this.techPanel;
    }

    private TechnologyTreePanel getTechTree() {
        if (this.techTree == null) {
            this.techTree = new TechnologyTreePanel(Constant.messages.getString("ascan.custom.tab.tech.node"));
        }
        return this.techTree;
    }

    private void setFieldStates() {
        int userDefStart = this.getRequestField().getSelectionStart();
        if (this.getBoolValue(FIELD_RECURSE).booleanValue()) {
            this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.recurse"));
            this.getAddCustomButton().setEnabled(false);
            this.getRemoveCustomButton().setEnabled(false);
            this.getDisableNonCustomVectors().setEnabled(false);
        } else {
            this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.highlight"));
            if (userDefStart >= 0) {
                int userDefEnd = this.getRequestField().getSelectionEnd();
                if (this.selectionIncludesHighlight(userDefStart, userDefEnd, this.getRequestField().getHighlighter().getHighlights())) {
                    this.getAddCustomButton().setEnabled(false);
                    this.getRemoveCustomButton().setEnabled(true);
                } else if (userDefStart < this.urlPathStart) {
                    this.getAddCustomButton().setEnabled(false);
                } else if (userDefStart < this.headerLength && userDefEnd > this.headerLength) {
                    this.getAddCustomButton().setEnabled(false);
                    this.getRemoveCustomButton().setEnabled(false);
                } else {
                    this.getAddCustomButton().setEnabled(true);
                    this.getRemoveCustomButton().setEnabled(false);
                }
            } else {
                this.getAddCustomButton().setEnabled(false);
                this.getRemoveCustomButton().setEnabled(false);
            }
            this.getDisableNonCustomVectors().setEnabled(true);
        }
        this.getRequestField().getCaret().setVisible(true);
    }

    private JList<Highlighter.Highlight> getInjectionPointList() {
        if (this.injectionPointList == null) {
            this.injectionPointList = new JList<Highlighter.Highlight>(this.injectionPointModel);
            this.injectionPointList.setCellRenderer(new ListCellRenderer<Highlighter.Highlight>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends Highlighter.Highlight> list, Highlighter.Highlight hlt, int index, boolean isSelected, boolean cellHasFocus) {
                    String str = "";
                    try {
                        str = CustomScanDialog.this.getRequestField().getText(hlt.getStartOffset(), hlt.getEndOffset() - hlt.getStartOffset());
                        if (str.length() > 8) {
                            str = str.substring(0, 8) + "..";
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    return new JLabel("[" + hlt.getStartOffset() + "," + hlt.getEndOffset() + "]: " + str);
                }
            });
        }
        return this.injectionPointList;
    }

    private boolean selectionIncludesHighlight(int start, int end, Highlighter.Highlight hl) {
        DefaultHighlighter.DefaultHighlightPainter ptr;
        if (hl.getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter && (ptr = (DefaultHighlighter.DefaultHighlightPainter)hl.getPainter()).getColor() != null && ptr.getColor().equals(Color.RED)) {
            return start < hl.getEndOffset() && end > hl.getStartOffset();
        }
        return false;
    }

    private boolean selectionIncludesHighlight(int start, int end, Highlighter.Highlight[] hls) {
        for (Highlighter.Highlight hl : hls) {
            if (!this.selectionIncludesHighlight(start, end, hl)) continue;
            return true;
        }
        return false;
    }

    private void reset(boolean refreshUi) {
        this.scannerParam = (ScannerParam)this.extension.getScannerParam().clone();
        this.techTreeState = null;
        if (refreshUi) {
            this.policyPanel.resetAndSetPolicy(this.scanPolicyName);
            this.init(this.target);
            this.repaint();
        }
    }

    @Override
    public String getSaveButtonText() {
        return Constant.messages.getString("ascan.custom.button.scan");
    }

    @Override
    public JButton[] getExtraButtons() {
        if (this.extraButtons == null) {
            JButton resetButton = new JButton(Constant.messages.getString("ascan.custom.button.reset"));
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomScanDialog.this.reset(true);
                }
            });
            this.extraButtons = new JButton[]{resetButton};
        }
        return this.extraButtons;
    }

    @Override
    public void save() {
        ArrayList<Object> contextSpecificObjects = new ArrayList<Object>();
        this.techTreeState = this.getTechTree().getTechSet();
        if (!this.getBoolValue(FIELD_ADVANCED).booleanValue()) {
            contextSpecificObjects.add(this.scanPolicy);
        } else {
            contextSpecificObjects.add(this.policyPanel.getScanPolicy());
            if (this.target == null && this.customPanels != null) {
                for (CustomScanPanel customPanel : this.customPanels) {
                    this.target = customPanel.getTarget();
                    if (this.target == null) continue;
                    break;
                }
            }
            this.getVariantPanel().saveParam(this.scannerParam);
            if (this.getDisableNonCustomVectors().isSelected()) {
                this.scannerParam.setTargetParamsInjectable(0);
                this.scannerParam.setTargetParamsEnabledRPC(0);
            }
            if (!this.getBoolValue(FIELD_RECURSE).booleanValue() && this.injectionPointModel.getSize() > 0) {
                int[][] injPoints = new int[this.injectionPointModel.getSize()][];
                for (int i = 0; i < this.injectionPointModel.getSize(); ++i) {
                    Highlighter.Highlight hl = this.injectionPointModel.elementAt(i);
                    injPoints[i] = new int[2];
                    injPoints[i][0] = hl.getStartOffset();
                    injPoints[i][1] = hl.getEndOffset();
                }
                try {
                    if (this.target != null && this.target.getStartNode() != null) {
                        VariantUserDefined.setInjectionPoints(this.target.getStartNode().getHistoryReference().getURI().toString(), injPoints);
                        this.enableUserDefinedRPC();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.scannerParam.setHostPerScan(this.extension.getScannerParam().getHostPerScan());
            this.scannerParam.setThreadPerHost(this.extension.getScannerParam().getThreadPerHost());
            this.scannerParam.setHandleAntiCSRFTokens(this.extension.getScannerParam().getHandleAntiCSRFTokens());
            this.scannerParam.setMaxResultsToList(this.extension.getScannerParam().getMaxResultsToList());
            contextSpecificObjects.add(this.scannerParam);
            contextSpecificObjects.add(this.techTreeState);
            if (this.customPanels != null) {
                for (CustomScanPanel customPanel : this.customPanels) {
                    Object[] objs = customPanel.getContextSpecificObjects();
                    if (objs == null) continue;
                    for (Object obj : objs) {
                        contextSpecificObjects.add(obj);
                    }
                }
            }
        }
        this.target.setRecurse(this.getBoolValue(FIELD_RECURSE));
        if (this.target.getContext() == null && this.getSelectedContext() != null) {
            this.target.setContext(this.getSelectedContext());
        }
        this.extension.startScan(this.target, this.getSelectedUser(), contextSpecificObjects.toArray());
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (!show) {
            this.scanPolicy = null;
        }
    }

    @Override
    public String validateFields() {
        if (Control.Mode.safe == Control.getSingleton().getMode()) {
            return Constant.messages.getString("ascan.custom.notSafe.error");
        }
        if (this.customPanels != null) {
            for (CustomScanPanel customPanel : this.customPanels) {
                String fail = customPanel.validateFields();
                if (fail == null) continue;
                return fail;
            }
            for (CustomScanPanel customPanel : this.customPanels) {
                Target target = customPanel.getTarget();
                if (target == null || !target.isValid()) continue;
                return null;
            }
        }
        if (this.target == null || !this.target.isValid()) {
            return Constant.messages.getString("ascan.custom.nostart.error");
        }
        switch (Control.getSingleton().getMode()) {
            case protect: {
                List<StructuralNode> nodes = this.target.getStartNodes();
                if (nodes == null) break;
                for (StructuralNode node : nodes) {
                    SiteNode siteNode;
                    if (!(node instanceof StructuralSiteNode) || (siteNode = ((StructuralSiteNode)node).getSiteNode()).isIncludedInScope()) continue;
                    return Constant.messages.getString("ascan.custom.targetNotInScope.error", siteNode.getHierarchicNodeName());
                }
                break;
            }
        }
        return null;
    }

    public void enableUserDefinedRPC() {
        int enabledRpc = this.scannerParam.getTargetParamsEnabledRPC();
        this.scannerParam.setTargetParamsEnabledRPC(enabledRpc |= 0x100);
    }

    void reset() {
        this.target = null;
        this.reset(true);
    }

    private static class ScanPolicyPanel
    extends AbstractParamContainerPanel {
        private static final long serialVersionUID = -7997974525786756431L;
        private PolicyAllCategoryPanel policyAllCategoryPanel = null;
        private List<PolicyCategoryPanel> categoryPanels = Collections.emptyList();
        private ScanPolicy scanPolicy;

        public ScanPolicyPanel(Window parent, ExtensionActiveScan extension, String rootName, ScanPolicy scanPolicy) {
            super(rootName);
            this.scanPolicy = scanPolicy;
            String[] ROOT = new String[]{};
            this.policyAllCategoryPanel = new PolicyAllCategoryPanel(parent, extension, scanPolicy, true);
            this.policyAllCategoryPanel.setName(Constant.messages.getString("ascan.custom.tab.policy"));
            this.policyAllCategoryPanel.addScanPolicyChangedEventListener(new PolicyAllCategoryPanel.ScanPolicyChangedEventListener(){

                @Override
                public void scanPolicyChanged(ScanPolicy scanPolicy) {
                    scanPolicy = scanPolicy;
                    for (PolicyCategoryPanel panel : categoryPanels) {
                        panel.setPluginFactory(scanPolicy.getPluginFactory(), scanPolicy.getDefaultThreshold());
                    }
                }
            });
            this.addParamPanel(null, this.policyAllCategoryPanel, false);
            this.categoryPanels = new ArrayList<PolicyCategoryPanel>(Category.getAllNames().length);
            for (int i = 0; i < Category.getAllNames().length; ++i) {
                PolicyCategoryPanel panel = new PolicyCategoryPanel(i, this.scanPolicy.getPluginFactory(), scanPolicy.getDefaultThreshold());
                this.addParamPanel(ROOT, Category.getName(i), panel, true);
                this.categoryPanels.add(panel);
            }
            this.showDialog(true);
        }

        public void resetAndSetPolicy(String scanPolicyName) {
            this.policyAllCategoryPanel.reloadPolicies(scanPolicyName);
        }

        public void setScanPolicy(ScanPolicy scanPolicy) {
            this.policyAllCategoryPanel.setScanPolicy(scanPolicy);
        }

        public ScanPolicy getScanPolicy() {
            return this.scanPolicy;
        }
    }
}

