/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.sdedit.ui.components.ATabbedPane;
import net.sf.sdedit.ui.components.ButtonPanel;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.ConfiguratorFactory;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringSelectionReceiver;
import net.sf.sdedit.util.Tooltips;
import net.sf.sdedit.util.Utilities;

public class ConfigurationUI<C extends DataObject>
extends JPanel {
    private Map<String, JPanel> categoryMap;
    private ConfiguratorFactory<C> configuratorFactory;
    private Map<String, List<Configurator<?, C>>> configurators;
    private Map<String, Integer> labelWidths;
    private JList categoryList;
    private JPanel right;
    private ConfigurationUIListener listener;
    private Bean<C> bean;
    private Bean<C> formerState;
    private Bean<C> defaultBean;
    private ButtonPanel buttonPanel;
    private JPanel categoryListPanel;
    private ATabbedPane tabbedPane;
    private boolean editable = true;
    private Action ok = new AbstractAction(){
        {
            this.putValue("Name", "OK");
            this.putValue("ShortDescription", "Confirms all changes made since this dialog has been opened");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationUI.this.listener.applyConfiguration();
        }
    };
    private Action cancel = new AbstractAction(){
        {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancels all changes made since this dialog has been opened");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationUI.this.listener.cancelConfiguration();
        }
    };

    public ConfigurationUI(ConfigurationUIListener listener, Bean<C> bean, Bean<C> defaultBean, String saveAsDefault, String loadDefault, String description, boolean tabbed) {
        String tooltip;
        String name;
        String[] split;
        this.bean = bean;
        this.formerState = bean.copy();
        this.defaultBean = defaultBean;
        this.setLayout(new BorderLayout());
        this.listener = listener;
        this.configuratorFactory = new ConfiguratorFactory();
        this.configurators = new HashMap();
        this.categoryMap = new TreeMap<String, JPanel>();
        if (tabbed) {
            this.tabbedPane = new ATabbedPane();
            this.add((Component)this.tabbedPane, "Center");
        } else {
            this.right = new JPanel();
            this.right.setLayout(new BorderLayout());
            this.right.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add((Component)this.right, "Center");
            this.categoryListPanel = new JPanel();
            this.categoryListPanel.setLayout(new BorderLayout());
            this.categoryList = new JList();
            JScrollPane listScrollPane = new JScrollPane(this.categoryList);
            this.categoryListPanel.add((Component)listScrollPane, "Center");
            this.add((Component)this.categoryListPanel, "West");
            this.categoryList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String category = (String)ConfigurationUI.this.categoryList.getSelectedValue();
                    if (category != null) {
                        JPanel panel = (JPanel)ConfigurationUI.this.categoryMap.get(category);
                        ConfigurationUI.this.right.removeAll();
                        ConfigurationUI.this.right.add((Component)panel, "Center");
                        ConfigurationUI.this.right.updateUI();
                    }
                }
            });
            final ListCellRenderer lcr = this.categoryList.getCellRenderer();
            this.categoryList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JComponent comp = (JComponent)lcr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                    return comp;
                }
            });
        }
        this.labelWidths = new HashMap<String, Integer>();
        if (description != null) {
            JLabel descriptionLabel = new JLabel(description);
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)descriptionLabel, "North");
        }
        this.buttonPanel = new ButtonPanel();
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.addAction(this.cancel);
        if (loadDefault != null) {
            split = loadDefault.split("\\|");
            name = split[0];
            tooltip = split.length == 1 ? "" : split[1];
            this.buttonPanel.addAction(this.restoreDefaultsAction(name, tooltip));
        }
        if (saveAsDefault != null) {
            split = saveAsDefault.split("\\|");
            name = split[0];
            tooltip = split.length == 1 ? "" : split[1];
            this.buttonPanel.addAction(this.saveAsDefaultAction(name, tooltip));
        }
        this.buttonPanel.addAction(this.ok);
        this.init(bean, defaultBean);
        this.refreshAll();
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void focusFirst() {
        this.getConfigurators().get(0).focus();
    }

    public void hideCategoryList() {
        this.remove(this.categoryListPanel);
    }

    public void hideButtons() {
        this.remove(this.buttonPanel);
    }

    public void addTab(Component tab, String title) {
        this.tabbedPane.addTab(tab, title);
    }

    public void select(String name) {
        if (this.tabbedPane != null) {
            this.tabbedPane.selectByName(name);
        } else {
            this.categoryList.setSelectedValue(name, true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.tabbedPane != null) {
            this.tabbedPane.setEnabled(enabled);
        } else {
            this.categoryList.setEnabled(enabled);
        }
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.setEnabled(enabled && configurator.isDependencySatisfied());
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.setEditable(editable);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private List<Configurator<?, C>> getConfigurators() {
        LinkedList list = new LinkedList();
        for (List<Configurator<?, C>> sublist : this.configurators.values()) {
            list.addAll(sublist);
        }
        return list;
    }

    public void updateStringSelections(String ... properties) {
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            if (!(configurator instanceof StringSelectionReceiver)) continue;
            String name = configurator.getPropertyDescriptor().getName();
            if (properties.length != 0 && !Utilities.in(name, properties)) continue;
            this.bean.clearStringSelection(name);
            ((StringSelectionReceiver)((Object)configurator)).reinitialize();
        }
    }

    public Collection<JPanel> getCategoryPanels() {
        return this.categoryMap.values();
    }

    private void init(Bean<C> bean, Bean<C> defaultObject) {
        for (PropertyDescriptor propertyDescriptor : bean.getProperties()) {
            if (!propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).editable()) continue;
            this.add(bean, propertyDescriptor, defaultObject);
        }
        for (Map.Entry entry : this.configurators.entrySet()) {
            int width = this.labelWidths.get(entry.getKey());
            for (Configurator configurator : (List)entry.getValue()) {
                configurator.setLabelWidth(width);
            }
        }
    }

    private void add(Bean<C> bean, PropertyDescriptor property, Bean<C> defaultObject) {
        Method writeMethod = property.getWriteMethod();
        if (writeMethod.isAnnotationPresent(Adjustable.class)) {
            Adjustable adj = writeMethod.getAnnotation(Adjustable.class);
            if (adj.editable()) {
                String category = adj.category();
                JPanel categoryPanel = this.categoryMap.get(category);
                int labelWidth = 0;
                if (categoryPanel == null) {
                    categoryPanel = new JPanel();
                    categoryPanel.setLayout(new BoxLayout(categoryPanel, 1));
                    categoryPanel.setBorder(new TitledBorder(category));
                    this.configurators.put(category, new LinkedList());
                    this.categoryMap.put(category, categoryPanel);
                    if (this.tabbedPane != null) {
                        this.tabbedPane.addTab(categoryPanel, category);
                    } else {
                        this.categoryList.setListData(this.categoryMap.keySet().toArray());
                        if (this.categoryMap.keySet().iterator().next().equals(category)) {
                            this.right.removeAll();
                            this.right.add((Component)categoryPanel, "Center");
                        }
                        this.categoryList.setSelectedIndex(0);
                    }
                } else {
                    labelWidth = this.labelWidths.get(category);
                }
                Configurator<?, C> configurator = this.configuratorFactory.createConfigurator(bean, property);
                String tooltipKey = bean.getDataClass().getSimpleName() + "." + property.getName();
                String tooltipText = Tooltips.getTooltip(tooltipKey);
                if (tooltipText == null && adj.tooltip().length() > 0) {
                    tooltipText = adj.tooltip();
                }
                configurator.setToolTipText(tooltipText);
                labelWidth = Math.max(labelWidth, configurator.getLabelWidth());
                this.labelWidths.put(category, labelWidth);
                int height = configurator.getPreferredSize().height;
                Dimension size = new Dimension(500, height);
                configurator.setMinimumSize(size);
                configurator.setPreferredSize(size);
                configurator.setMaximumSize(size);
                configurator.setAlignmentX(0.0f);
                this.configurators.get(category).add(configurator);
                categoryPanel.add(configurator);
                int gap = 15 * adj.gap();
                categoryPanel.add(Box.createRigidArea(new Dimension(1, gap)));
            }
        } else {
            throw new IllegalArgumentException("No Adjustable annotation present for property " + property.getName());
        }
    }

    public void setBean(Bean<C> bean) {
        this.bean = bean;
        this.formerState = bean.copy();
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.setBean(bean);
        }
    }

    public void refreshAll() {
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.refresh();
        }
    }

    public void apply() {
        this.formerState.takeValuesFrom(this.bean);
    }

    public void cancel() {
        this.bean.takeValuesFrom(this.formerState);
    }

    private Action restoreDefaultsAction(final String name, final String tooltip) {
        return new AbstractAction(){
            {
                this.putValue("Name", name);
                this.putValue("ShortDescription", tooltip);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurationUI.this.defaultBean != null) {
                    ConfigurationUI.this.bean.takeValuesFrom(ConfigurationUI.this.defaultBean);
                }
            }
        };
    }

    private Action saveAsDefaultAction(final String name, final String tooltip) {
        return new AbstractAction(){
            {
                this.putValue("Name", name);
                this.putValue("ShortDescription", tooltip);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurationUI.this.defaultBean != null) {
                    ConfigurationUI.this.defaultBean.takeValuesFrom(ConfigurationUI.this.bean);
                }
            }
        };
    }
}

