/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class Word {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.Word");
    @NotNull
    private final DiffString myBaseText;
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final DiffString myText;

    public Word(@NotNull String baseText, @NotNull TextRange range) {
        if (baseText == null) {
            Word.$$$reportNull$$$0(0);
        }
        if (range == null) {
            Word.$$$reportNull$$$0(1);
        }
        this(DiffString.create(baseText), range);
    }

    public Word(@NotNull DiffString baseText, @NotNull TextRange range) {
        if (baseText == null) {
            Word.$$$reportNull$$$0(2);
        }
        if (range == null) {
            Word.$$$reportNull$$$0(3);
        }
        this.myBaseText = baseText;
        this.myRange = range;
        this.myText = this.myBaseText.substring(this.myRange.getStartOffset(), this.myRange.getEndOffset());
        LOG.assertTrue(this.myRange.getStartOffset() >= 0);
        LOG.assertTrue(this.myRange.getEndOffset() >= this.myRange.getStartOffset(), this.myRange);
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Word)) {
            return false;
        }
        Word other = (Word)obj;
        return this.getText().equals(other.getText());
    }

    @NotNull
    public DiffString getText() {
        DiffString diffString = this.myText;
        if (diffString == null) {
            Word.$$$reportNull$$$0(4);
        }
        return diffString;
    }

    @NotNull
    public DiffString getPrefix(int fromPosition) {
        LOG.assertTrue(fromPosition >= 0, fromPosition);
        int wordStart = this.myRange.getStartOffset();
        LOG.assertTrue(fromPosition <= wordStart, fromPosition + " " + wordStart);
        DiffString diffString = this.myBaseText.substring(fromPosition, wordStart);
        if (diffString == null) {
            Word.$$$reportNull$$$0(5);
        }
        return diffString;
    }

    public int getEnd() {
        return this.myRange.getEndOffset();
    }

    public int getStart() {
        return this.myRange.getStartOffset();
    }

    public String toString() {
        return this.myText.toString();
    }

    public boolean isWhitespace() {
        return false;
    }

    public boolean atEndOfLine() {
        int start = this.myRange.getStartOffset();
        if (start == 0) {
            return true;
        }
        if (this.myBaseText.charAt(start - 1) == '\n') {
            return true;
        }
        int end = this.myRange.getEndOffset();
        if (end == this.myBaseText.length()) {
            return true;
        }
        return this.myBaseText.charAt(end) == '\n';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/processing/Word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/processing/Word";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

