/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.ui.filter.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcs.log.ui.filter.VcsLogRegexTextFilter;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImplKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl;", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "text", "", "(Ljava/lang/String;)V", "isMatchCase", "", "(Ljava/lang/String;Z)V", "getText", "isRegex", "matches", "message", "matchesCase", "toString", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsLogTextFilterImpl
implements VcsLogDetailsFilter,
VcsLogTextFilter {
    private final String text;
    private final boolean isMatchCase;
    public static final Companion Companion = new Companion(null);

    public boolean matches(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return StringsKt.contains((CharSequence)message, (CharSequence)this.text, (!this.isMatchCase ? 1 : 0) != 0);
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean matchesCase() {
        return this.isMatchCase;
    }

    @NotNull
    public String toString() {
        return "containing " + this.text + ' ' + VcsLogTextFilterImplKt.access$caseSensitiveText(this);
    }

    public VcsLogTextFilterImpl(@NotNull String text, boolean isMatchCase) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.isMatchCase = isMatchCase;
    }

    public VcsLogTextFilterImpl(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this(text, false);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter createTextFilter(@NotNull String text, boolean isRegexpAllowed, boolean isMatchCase) {
        return Companion.createTextFilter(text, isRegexpAllowed, isMatchCase);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter createTextFilter(@NotNull List<String> patterns, boolean isMatchCase) {
        return Companion.createTextFilter(patterns, isMatchCase);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl$Companion;", "", "()V", "createTextFilter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "text", "", "isRegexpAllowed", "", "isMatchCase", "patterns", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final VcsLogTextFilter createTextFilter(@NotNull String text, boolean isRegexpAllowed, boolean isMatchCase) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (isRegexpAllowed && VcsLogUtil.maybeRegexp(text)) {
                try {
                    Pattern pattern = Pattern.compile(text, isMatchCase ? 0 : 2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(text, if\u2026Pattern.CASE_INSENSITIVE)");
                    return new VcsLogRegexTextFilter(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            return new VcsLogTextFilterImpl(text, isMatchCase);
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ VcsLogTextFilter createTextFilter$default(Companion companion, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.createTextFilter(string, bl, bl2);
        }

        @JvmStatic
        @NotNull
        public final VcsLogTextFilter createTextFilter(@NotNull List<String> patterns, boolean isMatchCase) {
            Intrinsics.checkParameterIsNotNull(patterns, (String)"patterns");
            if (patterns.isEmpty()) {
                return this.createTextFilter("", false, isMatchCase);
            }
            if (patterns.size() == 1) {
                return this.createTextFilter((String)CollectionsKt.single(patterns), false, isMatchCase);
            }
            return new VcsLogMultiplePatternsTextFilter(patterns, isMatchCase);
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ VcsLogTextFilter createTextFilter$default(Companion companion, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.createTextFilter(list2, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

