/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.Changeable;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import org.jetbrains.annotations.Nullable;

public class RegistryTextOptionDescriptor
extends OptionDescription
implements Changeable {
    private final RegistryValue myValue;

    public RegistryTextOptionDescriptor(RegistryValue value) {
        super(value.getKey());
        this.myValue = value;
    }

    public boolean hasChanged() {
        return this.myValue.isChangedFromDefault();
    }

    public String getOption() {
        return this.myValue.getKey();
    }

    public String getValue() {
        return this.myValue.asString();
    }

    public boolean hasExternalEditor() {
        return true;
    }

    public void invokeInternalEditor() {
        if (this.myValue.getKey().contains("color") && ColorUtil.fromHex((String)this.myValue.asString(), null) != null) {
            Color color = ColorChooser.chooseColor((Component)IdeFrameImpl.getActiveFrame(), (String)("Change Color For '" + this.myValue.getKey() + "'"), (Color)ColorUtil.fromHex((String)this.myValue.asString()));
            if (color != null) {
                this.myValue.setValue(ColorUtil.toHex((Color)color));
            }
        } else {
            String s = Messages.showInputDialog((Project)null, (String)("Enter new value for '" + this.myValue.getKey() + "'"), (String)"Change Registry Value", null, (String)this.myValue.asString(), (InputValidator)new InputValidatorEx(){

                @Nullable
                public String getErrorText(String inputString) {
                    return this.canClose(inputString) ? null : "Should not be empty";
                }

                public boolean checkInput(String inputString) {
                    return this.canClose(inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty((String)inputString);
                }
            });
            if (s != null) {
                this.myValue.setValue(s);
            }
        }
    }
}

