/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.semanticweb.owlapi.util.RootClassChecker;

public class SimpleRootClassChecker
implements RootClassChecker {
    @Nonnull
    private final Set<OWLOntology> ontologies;
    @Nonnull
    private final RootClassCheckerHelper checker = new RootClassCheckerHelper();
    @Nonnull
    private final NamedSuperChecker superChecker = new NamedSuperChecker();

    public SimpleRootClassChecker(@Nonnull Set<OWLOntology> ontologies) {
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    @Override
    public boolean isRootClass(OWLClass cls) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms((OWLPrimitive)cls, Imports.EXCLUDED)) {
                this.checker.setOWLClass(cls);
                ax.accept(this.checker);
                if (this.checker.isRoot()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean check(OWLClassExpression e) {
        this.superChecker.reset();
        e.accept(this.superChecker);
        return !this.superChecker.namedSuper;
    }

    private class RootClassCheckerHelper
    extends OWLAxiomVisitorAdapter {
        private boolean isRoot;
        private OWLClass cls;

        RootClassCheckerHelper() {
        }

        public void setOWLClass(OWLClass cls) {
            this.isRoot = true;
            this.cls = cls;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (axiom.getSubClass().equals(this.cls)) {
                this.isRoot = SimpleRootClassChecker.this.check(axiom.getSuperClass());
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLClassExpression> descs = axiom.getClassExpressions();
            if (!descs.contains(this.cls)) {
                return;
            }
            boolean check = false;
            for (OWLClassExpression desc : descs) {
                if (desc.equals(this.cls) || !(check = SimpleRootClassChecker.this.check(desc))) continue;
                this.isRoot = false;
                return;
            }
            this.isRoot = check;
        }
    }

    private static class NamedSuperChecker
    extends OWLClassExpressionVisitorAdapter {
        protected boolean namedSuper;

        NamedSuperChecker() {
        }

        public void reset() {
            this.namedSuper = false;
        }

        @Override
        public void visit(OWLClass ce) {
            this.namedSuper = true;
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression op : ce.getOperands()) {
                op.accept(this);
                if (!this.namedSuper) continue;
                break;
            }
        }
    }
}

