/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomFilter;

public class OWLOntologyMerger
implements OWLAxiomFilter {
    private final OWLOntologySetProvider setProvider;
    private final OWLAxiomFilter axiomFilter;
    private final boolean mergeOnlyLogicalAxioms;

    public OWLOntologyMerger(@Nonnull OWLOntologySetProvider setProvider) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.axiomFilter = this;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntologyMerger(@Nonnull OWLOntologySetProvider setProvider, boolean mergeOnlyLogicalAxioms) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.mergeOnlyLogicalAxioms = mergeOnlyLogicalAxioms;
        this.axiomFilter = this;
    }

    public OWLOntologyMerger(@Nonnull OWLOntologySetProvider setProvider, OWLAxiomFilter axiomFilter) {
        this.setProvider = OWLAPIPreconditions.checkNotNull(setProvider, "setProvider cannot be null");
        this.axiomFilter = axiomFilter;
        this.mergeOnlyLogicalAxioms = false;
    }

    public OWLOntology createMergedOntology(OWLOntologyManager ontologyManager, @Nullable IRI ontologyIRI) throws OWLOntologyCreationException {
        OWLOntology ontology = ontologyIRI != null ? ontologyManager.createOntology(ontologyIRI) : ontologyManager.createOntology();
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ont : this.setProvider.getOntologies()) {
            if (ont == ontology) continue;
            for (OWLAxiom oWLAxiom : this.getAxioms(ont)) {
                assert (oWLAxiom != null);
                if (!this.axiomFilter.passes(oWLAxiom)) continue;
                changes.add(new AddAxiom(ontology, oWLAxiom));
            }
        }
        ontologyManager.applyChanges(changes);
        return ontology;
    }

    private Set<? extends OWLAxiom> getAxioms(OWLOntology ont) {
        if (this.mergeOnlyLogicalAxioms) {
            return ont.getLogicalAxioms();
        }
        return ont.getAxioms();
    }

    @Override
    public boolean passes(OWLAxiom axiom) {
        return true;
    }
}

