/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.ClassPath;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.LdDefaults;
import net.sf.launch4j.config.Messages;
import net.sf.launch4j.config.Msg;
import net.sf.launch4j.config.SingleInstance;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class Config
implements IValidatable {
    public static final String HEADER = "header";
    public static final String JAR = "jar";
    public static final String OUTFILE = "outfile";
    public static final String ERR_TITLE = "errTitle";
    public static final String JAR_ARGS = "jarArgs";
    public static final String CHDIR = "chdir";
    public static final String STAY_ALIVE = "stayAlive";
    public static final String ICON = "icon";
    public static final String DOWNLOAD_URL = "http://java.com/download";
    public static final String GUI_HEADER = "gui";
    public static final String CONSOLE_HEADER = "console";
    public static final String JNI_GUI_HEADER_32 = "jniGui32";
    public static final String JNI_CONSOLE_HEADER_32 = "jniConsole32";
    private static final String[] HEADER_TYPES = new String[]{"gui", "console", "jniGui32", "jniConsole32"};
    private static final String[] PRIORITY_CLASS_NAMES = new String[]{"normal", "idle", "high"};
    private static final int[] PRIORITY_CLASSES = new int[]{32, 64, 128};
    private boolean dontWrapJar;
    private String headerType = "gui";
    private List<String> headerObjects;
    private List<String> libs;
    private File jar;
    private File outfile;
    private String errTitle;
    private String cmdLine;
    private String chdir;
    private String priority;
    private String downloadUrl;
    private String supportUrl;
    private boolean stayAlive;
    private boolean restartOnCrash;
    private File manifest;
    private File icon;
    private List<String> variables;
    private SingleInstance singleInstance;
    private ClassPath classPath;
    private Jre jre;
    private Splash splash;
    private VersionInfo versionInfo;
    private Msg messages;

    @Override
    public void checkInvariants() {
        Validator.checkTrue(this.outfile != null && this.outfile.getPath().endsWith(".exe"), OUTFILE, Messages.getString("Config.specify.output.exe"));
        if (this.dontWrapJar) {
            if (this.jar != null && !this.jar.getPath().equals("")) {
                Validator.checkRelativeWinPath(this.jar.getPath(), JAR, Messages.getString("Config.application.jar.path"));
            } else {
                Validator.checkTrue(this.classPath != null, "classPath", Messages.getString("ClassPath.or.jar"));
            }
        } else {
            Validator.checkFile(this.jar, JAR, Messages.getString("Config.application.jar"));
        }
        if (!Validator.isEmpty(this.chdir)) {
            Validator.checkRelativeWinPath(this.chdir, CHDIR, Messages.getString("Config.chdir.relative"));
            Validator.checkFalse(this.chdir.toLowerCase().equals("true") || this.chdir.toLowerCase().equals("false"), CHDIR, Messages.getString("Config.chdir.path"));
        }
        Validator.checkOptFile(this.manifest, "manifest", Messages.getString("Config.manifest"));
        Validator.checkOptFile(this.icon, ICON, Messages.getString("Config.icon"));
        Validator.checkOptString(this.cmdLine, 8192, JAR_ARGS, Messages.getString("Config.jar.arguments"));
        Validator.checkOptString(this.errTitle, 128, ERR_TITLE, Messages.getString("Config.error.title"));
        Validator.checkOptString(this.downloadUrl, 256, "downloadUrl", Messages.getString("Config.download.url"));
        Validator.checkOptString(this.supportUrl, 256, "supportUrl", Messages.getString("Config.support.url"));
        Validator.checkIn(this.getHeaderType(), HEADER_TYPES, "headerType", Messages.getString("Config.header.type"));
        Validator.checkFalse(!this.isGuiApplication() && this.splash != null, "headerType", Messages.getString("Config.splash.not.impl.by.console.hdr"));
        Validator.checkOptStrings(this.variables, 30719, 30719, "[^=%\t]+=[^=\t]+", "variables", Messages.getString("Config.variables"), Messages.getString("Config.variables.err"));
        Validator.checkIn(this.getPriority(), PRIORITY_CLASS_NAMES, "priority", Messages.getString("Config.priority"));
        this.checkJniInvariants();
        this.jre.checkInvariants();
    }

    private void checkJniInvariants() {
        if (this.isJniApplication()) {
            Validator.checkTrue(".".equals(this.chdir), CHDIR, "Only '.' is allowed in change directory.");
            Validator.checkTrue(Validator.isEmpty(this.cmdLine), "cmdLine", "Constant command line arguments not supported.");
            Validator.checkFalse(this.stayAlive, STAY_ALIVE, "Stay alive option is not used in JNI, this is the default behavior.");
            Validator.checkFalse(this.restartOnCrash, "restartOnCrash", "Restart on crash not supported.");
            Validator.checkIn(this.getPriority(), new String[]{"normal"}, "priority", "Process priority is not supported,");
            Validator.checkNotNull(this.classPath, "classpath", "classpath");
            Validator.checkFalse(this.jre.getBundledJre64Bit(), "jre.bundledJre64Bit", "64-bit bundled JRE not supported.");
            Validator.checkTrue("32".equals(this.jre.getRuntimeBits()), "jre.runtimeBits", "64-bit JRE not supported.");
        }
    }

    public void validate() {
        this.checkInvariants();
        if (this.classPath != null) {
            this.classPath.checkInvariants();
        }
        if (this.splash != null) {
            this.splash.checkInvariants();
        }
        if (this.versionInfo != null) {
            this.versionInfo.checkInvariants();
        }
    }

    public String getChdir() {
        return this.chdir;
    }

    public void setChdir(String chdir) {
        this.chdir = chdir;
    }

    public String getCmdLine() {
        return this.cmdLine;
    }

    public void setCmdLine(String cmdLine) {
        this.cmdLine = cmdLine;
    }

    public String getErrTitle() {
        return this.errTitle;
    }

    public void setErrTitle(String errTitle) {
        this.errTitle = errTitle;
    }

    public boolean isGuiApplication() {
        return GUI_HEADER.equals(this.headerType) || JNI_GUI_HEADER_32.equals(this.headerType);
    }

    public boolean isJniApplication() {
        return JNI_GUI_HEADER_32.equals(this.headerType) || JNI_CONSOLE_HEADER_32.equals(this.headerType);
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public int getHeaderTypeIndex() {
        int x = Arrays.asList(HEADER_TYPES).indexOf(this.getHeaderType());
        return x != -1 ? x : 0;
    }

    public void setHeaderTypeIndex(int headerTypeIndex) {
        this.headerType = HEADER_TYPES[headerTypeIndex];
    }

    public boolean isCustomHeaderObjects() {
        return this.headerObjects != null && !this.headerObjects.isEmpty();
    }

    public List<String> getHeaderObjects() {
        return this.isCustomHeaderObjects() ? this.headerObjects : LdDefaults.getHeaderObjects(this.getHeaderTypeIndex());
    }

    public void setHeaderObjects(List<String> headerObjects) {
        this.headerObjects = headerObjects;
    }

    public boolean isCustomLibs() {
        return this.libs != null && !this.libs.isEmpty();
    }

    public List<String> getLibs() {
        return this.isCustomLibs() ? this.libs : LdDefaults.getLibs(this.headerType);
    }

    public void setLibs(List<String> libs) {
        this.libs = libs;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public File getIcon() {
        return this.icon;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public File getJar() {
        return this.jar;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public void setClassPath(ClassPath classpath) {
        this.classPath = classpath;
    }

    public Jre getJre() {
        return this.jre;
    }

    public void setJre(Jre jre) {
        this.jre = jre;
    }

    public File getOutfile() {
        return this.outfile;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    public Splash getSplash() {
        return this.splash;
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public boolean isStayAlive() {
        return this.stayAlive;
    }

    public void setStayAlive(boolean stayAlive) {
        this.stayAlive = stayAlive;
    }

    public boolean isRestartOnCrash() {
        return this.restartOnCrash;
    }

    public void setRestartOnCrash(boolean restartOnCrash) {
        this.restartOnCrash = restartOnCrash;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public boolean isDontWrapJar() {
        return this.dontWrapJar;
    }

    public void setDontWrapJar(boolean dontWrapJar) {
        this.dontWrapJar = dontWrapJar;
    }

    public int getPriorityIndex() {
        int x = Arrays.asList(PRIORITY_CLASS_NAMES).indexOf(this.getPriority());
        return x != -1 ? x : 0;
    }

    public void setPriorityIndex(int x) {
        this.priority = PRIORITY_CLASS_NAMES[x];
    }

    public String getPriority() {
        return Validator.isEmpty(this.priority) ? PRIORITY_CLASS_NAMES[0] : this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public int getPriorityClass() {
        return PRIORITY_CLASSES[this.getPriorityIndex()];
    }

    public String getDownloadUrl() {
        return this.downloadUrl == null ? DOWNLOAD_URL : this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    public Msg getMessages() {
        return this.messages;
    }

    public void setMessages(Msg messages) {
        this.messages = messages;
    }

    public SingleInstance getSingleInstance() {
        return this.singleInstance;
    }

    public void setSingleInstance(SingleInstance singleInstance) {
        this.singleInstance = singleInstance;
    }
}

