/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.modules;

import java.util.Objects;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

class DashboardTile
extends VBox {
    private static final PseudoClass ARMED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"armed");
    private Button button = new Button();
    ReadOnlyBooleanWrapper armed = new ReadOnlyBooleanWrapper(false){

        protected void invalidated() {
            DashboardTile.this.pseudoClassStateChanged(ARMED_PSEUDOCLASS_STATE, this.get());
        }
    };

    public DashboardTile(String title, String description, Node graphic) {
        this.getStyleClass().addAll((Object[])new String[]{"dashboard-modules-tile"});
        Label titleLabel = new Label(title);
        titleLabel.getStyleClass().add((Object)"dashboard-modules-tile-title");
        if (Objects.nonNull(graphic)) {
            titleLabel.setGraphic(graphic);
        }
        Label textLabel = new Label(description);
        textLabel.getStyleClass().add((Object)"dashboard-modules-tile-text");
        textLabel.setMinHeight(Double.NEGATIVE_INFINITY);
        VBox topTile = new VBox(5.0);
        topTile.getChildren().addAll((Object[])new Node[]{titleLabel, textLabel});
        this.button.getStyleClass().add((Object)"dashboard-modules-invisible-button");
        this.button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.armed.bind((ObservableValue)this.button.armedProperty());
        this.getChildren().addAll((Object[])new Node[]{new StackPane(new Node[]{topTile, this.button})});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
    }

    public final ReadOnlyBooleanProperty armedProperty() {
        return this.armed.getReadOnlyProperty();
    }

    public final boolean isArmed() {
        return this.armed.get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.button.setOnAction(eventHandler);
    }

    void addBottomPanel(Region pane) {
        this.getChildren().add((Object)pane);
    }
}

