/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class EditMediator
implements ActionListener,
ListSelectionListener {
    private static String[] DEFAULT_ANT_ARTIFACT_TYPES = new String[]{"jar", "folder"};
    public static final FileFilter JAR_ZIP_FILTER = new SimpleFileFilter(NbBundle.getMessage(EditMediator.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
    private static final RequestProcessor RP = new RequestProcessor(EditMediator.class);
    private final ListComponent list;
    private final DefaultListModel listModel;
    private final ListSelectionModel selectionModel;
    private final ButtonModel addJar;
    private final ButtonModel addLibrary;
    private final ButtonModel addAntArtifact;
    private final ButtonModel remove;
    private final ButtonModel moveUp;
    private final ButtonModel moveDown;
    private final ButtonModel edit;
    private final boolean allowRemoveClassPath;
    private Document libraryPath;
    private ClassPathUiSupport.Callback callback;
    private AntProjectHelper helper;
    private ReferenceHelper refHelper;
    private Project project;
    private FileFilter filter;
    private String[] antArtifactTypes;
    private int fileSelectionMode;
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";

    private EditMediator(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, ButtonModel edit, boolean allowRemoveClassPath, Document libPath, ClassPathUiSupport.Callback callback, String[] antArtifactTypes, FileFilter filter, int fileSelectionMode) {
        this.list = list;
        this.listModel = list.getModel();
        this.selectionModel = list.getSelectionModel();
        this.addJar = addJar;
        this.addLibrary = addLibrary;
        this.addAntArtifact = addAntArtifact;
        this.remove = remove;
        this.moveUp = moveUp;
        this.moveDown = moveDown;
        this.edit = edit;
        this.libraryPath = libPath;
        this.callback = callback;
        this.helper = helper;
        this.refHelper = refHelper;
        this.project = project;
        this.filter = filter;
        this.fileSelectionMode = fileSelectionMode;
        this.antArtifactTypes = antArtifactTypes;
        this.allowRemoveClassPath = allowRemoveClassPath;
    }

    public static void register(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, ButtonModel edit, Document libPath, ClassPathUiSupport.Callback callback) {
        EditMediator.register(project, helper, refHelper, list, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown, edit, false, libPath, callback);
    }

    public static void register(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, ButtonModel edit, boolean allowRemoveClassPath, Document libPath, ClassPathUiSupport.Callback callback) {
        EditMediator.register(project, helper, refHelper, list, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown, edit, allowRemoveClassPath, libPath, callback, DEFAULT_ANT_ARTIFACT_TYPES, JAR_ZIP_FILTER, 2);
    }

    public static void register(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, ButtonModel edit, Document libPath, ClassPathUiSupport.Callback callback, String[] antArtifactTypes, FileFilter filter, int fileSelectionMode) {
        EditMediator.register(project, helper, refHelper, list, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown, edit, false, libPath, callback, antArtifactTypes, filter, fileSelectionMode);
    }

    public static void register(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ListComponent list, ButtonModel addJar, ButtonModel addLibrary, ButtonModel addAntArtifact, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, ButtonModel edit, boolean allowRemoveClassPath, Document libPath, ClassPathUiSupport.Callback callback, String[] antArtifactTypes, FileFilter filter, int fileSelectionMode) {
        EditMediator em = new EditMediator(project, helper, refHelper, list, addJar, addLibrary, addAntArtifact, remove, moveUp, moveDown, edit, allowRemoveClassPath, libPath, callback, antArtifactTypes, filter, fileSelectionMode);
        addJar.addActionListener(em);
        addLibrary.addActionListener(em);
        addAntArtifact.addActionListener(em);
        remove.addActionListener(em);
        moveUp.addActionListener(em);
        moveDown.addActionListener(em);
        edit.addActionListener(em);
        em.selectionModel.addListSelectionListener(em);
        em.valueChanged(null);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object source = e.getSource();
                        if (source == EditMediator.this.addJar) {
                            FileChooser chooser = EditMediator.this.helper.isSharableProject() ? new FileChooser(EditMediator.this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)EditMediator.this.project.getProjectDirectory()), null);
                            chooser.enableVariableBasedSelection(true);
                            chooser.setFileHidingEnabled(false);
                            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                            chooser.setFileSelectionMode(EditMediator.this.fileSelectionMode);
                            chooser.setMultiSelectionEnabled(true);
                            chooser.setDialogTitle(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
                            chooser.setAcceptAllFileFilterUsed(false);
                            chooser.setFileFilter(EditMediator.this.filter);
                            File curDir = EditMediator.getLastUsedClassPathFolder();
                            chooser.setCurrentDirectory(curDir);
                            chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
                            int option = chooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(EditMediator.this.list.getComponent()));
                            if (option == 0) {
                                String[] filePaths;
                                try {
                                    filePaths = chooser.getSelectedPaths();
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                    return;
                                }
                                File base = FileUtil.toFile((FileObject)EditMediator.this.helper.getProjectDirectory());
                                ArrayList<String> newPaths = new ArrayList<String>();
                                for (String path : filePaths) {
                                    File fl = PropertyUtils.resolveFile((File)base, (String)path);
                                    FileObject fo = FileUtil.toFileObject((File)fl);
                                    if (fo == null) {
                                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(EditMediator.this.list.getComponent()), NbBundle.getMessage(EditMediator.class, (String)"LBL_Missing_JAR", (Object)fl), NbBundle.getMessage(EditMediator.class, (String)"LBL_Missing_JAR_title"), 2);
                                        continue;
                                    }
                                    assert (fo != null) : fl;
                                    if (FileUtil.isArchiveFile((FileObject)fo)) {
                                        try {
                                            new JarFile(fl);
                                        }
                                        catch (IOException ex) {
                                            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(EditMediator.this.list.getComponent()), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR", (Object)fl), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR_title"), 2);
                                            continue;
                                        }
                                    }
                                    newPaths.add(path);
                                }
                                filePaths = newPaths.toArray(new String[newPaths.size()]);
                                int[] newSelection = ClassPathUiSupport.addJarFiles(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices(), filePaths, base, chooser.getSelectedPathVariables(), EditMediator.this.callback);
                                EditMediator.this.list.setSelectedIndices(newSelection);
                                curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                                EditMediator.setLastUsedClassPathFolder(curDir);
                            }
                        } else if (source == EditMediator.this.addLibrary) {
                            File librariesFile = null;
                            LibraryManager manager = null;
                            boolean empty = false;
                            try {
                                String path = EditMediator.this.libraryPath.getText(0, EditMediator.this.libraryPath.getLength());
                                if (path != null && path.length() > 0) {
                                    librariesFile = FileUtil.normalizeFile((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)EditMediator.this.helper.getProjectDirectory()), (String)path));
                                    URL librariesFolder = Utilities.toURI((File)librariesFile).toURL();
                                    manager = LibraryManager.forLocation((URL)librariesFolder);
                                } else {
                                    empty = true;
                                }
                            }
                            catch (BadLocationException ex) {
                                empty = true;
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (MalformedURLException ex2) {
                                Exceptions.printStackTrace((Throwable)ex2);
                            }
                            if (manager == null && empty) {
                                manager = LibraryManager.getDefault();
                            }
                            if (manager == null) {
                                return;
                            }
                            Set added = LibraryChooser.showDialog((LibraryManager)manager, (LibraryChooser.Filter)EditMediator.createLibraryFilter(), (LibraryChooser.LibraryImportHandler)(empty ? CustomizerUtilities.getLibraryChooserImportHandler((ReferenceHelper)EditMediator.this.refHelper) : CustomizerUtilities.getLibraryChooserImportHandler(librariesFile)));
                            if (added != null) {
                                Set includedLibraries = EditMediator.this.getIncludedLibraries(EditMediator.this.listModel);
                                int[] newSelection = ClassPathUiSupport.addLibraries(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices(), added.toArray(new Library[added.size()]), includedLibraries, EditMediator.this.callback);
                                EditMediator.this.list.setSelectedIndices(newSelection);
                            }
                        } else if (source == EditMediator.this.edit) {
                            ClassPathUiSupport.edit(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices(), EditMediator.this.helper);
                            if (EditMediator.this.list instanceof JListListComponent) {
                                ((JListListComponent)EditMediator.this.list).list.repaint();
                                for (ListDataListener listener : ((JListListComponent)EditMediator.this.list).getModel().getListDataListeners()) {
                                    listener.contentsChanged(new ListDataEvent(source, 0, EditMediator.this.list.getSelectedIndices().length > 0 ? Integer.valueOf(EditMediator.this.list.getSelectedIndices()[0]) : null, EditMediator.this.list.getSelectedIndices().length > 0 ? Integer.valueOf(EditMediator.this.list.getSelectedIndices()[EditMediator.this.list.getSelectedIndices().length - 1]) : null));
                                }
                            } else if (EditMediator.this.list instanceof JTableListComponent) {
                                ((JTableListComponent)EditMediator.this.list).table.repaint();
                                for (ListDataListener listener : ((JTableListComponent)EditMediator.this.list).getModel().getListDataListeners()) {
                                    listener.contentsChanged(new ListDataEvent(source, 0, EditMediator.this.list.getSelectedIndices().length > 0 ? Integer.valueOf(EditMediator.this.list.getSelectedIndices()[0]) : null, EditMediator.this.list.getSelectedIndices().length > 0 ? Integer.valueOf(EditMediator.this.list.getSelectedIndices()[EditMediator.this.list.getSelectedIndices().length - 1]) : null));
                                }
                            } else assert (false) : "do not know how to handle " + EditMediator.access$500(EditMediator.this).getClass().getName();
                        } else if (source == EditMediator.this.addAntArtifact) {
                            AntArtifactItem[] artifactItems = AntArtifactChooser.showDialog(EditMediator.this.antArtifactTypes, EditMediator.this.project, EditMediator.this.list.getComponent().getParent());
                            if (artifactItems != null) {
                                int[] newSelection = ClassPathUiSupport.addArtifacts(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices(), artifactItems, EditMediator.this.callback);
                                EditMediator.this.list.setSelectedIndices(newSelection);
                            }
                        } else if (source == EditMediator.this.remove) {
                            int[] newSelection = ClassPathUiSupport.remove(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices());
                            EditMediator.this.list.setSelectedIndices(newSelection);
                        } else if (source == EditMediator.this.moveUp) {
                            int[] newSelection = ClassPathUiSupport.moveUp(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices());
                            EditMediator.this.list.setSelectedIndices(newSelection);
                        } else if (source == EditMediator.this.moveDown) {
                            int[] newSelection = ClassPathUiSupport.moveDown(EditMediator.this.listModel, EditMediator.this.list.getSelectedIndices());
                            EditMediator.this.list.setSelectedIndices(newSelection);
                        }
                    }
                });
            }
        });
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(EditMediator.class);
    }

    private Set<Library> getIncludedLibraries(@NonNull DefaultListModel model) {
        HashSet<Library> inc = new HashSet<Library>();
        for (Object item : model.toArray()) {
            ClassPathSupport.Item cpItem;
            if (!(item instanceof ClassPathSupport.Item) || (cpItem = (ClassPathSupport.Item)item).getType() != 1 || cpItem.getLibrary() == null) continue;
            inc.add(cpItem.getLibrary());
        }
        return Collections.unmodifiableSet(inc);
    }

    public static File getLastUsedClassPathFolder() {
        return new File(EditMediator.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public static void setLastUsedClassPathFolder(File folder) {
        assert (folder != null) : "ClassPath root can not be null";
        String path = folder.getAbsolutePath();
        EditMediator.getPreferences().put(LAST_USED_CP_FOLDER, path);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean canRemove = false;
        if (this.selectionModel.getMinSelectionIndex() != -1) {
            canRemove = true;
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            for (int i = iMin; i <= iMax; ++i) {
                ClassPathSupport.Item item;
                if (!this.selectionModel.isSelectedIndex(i) || (item = (ClassPathSupport.Item)this.listModel.get(i)) == null || item.getType() != 3) continue;
                canRemove = this.allowRemoveClassPath;
                break;
            }
        }
        this.edit.setEnabled(ClassPathUiSupport.canEdit(this.selectionModel, this.listModel));
        this.remove.setEnabled(canRemove);
        this.moveUp.setEnabled(ClassPathUiSupport.canMoveUp(this.selectionModel));
        this.moveDown.setEnabled(ClassPathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
    }

    public static LibraryChooser.Filter createLibraryFilter() {
        return new LibraryChooser.Filter(){

            public boolean accept(Library library) {
                if ("javascript".equals(library.getType())) {
                    return false;
                }
                try {
                    library.getContent("classpath");
                    return true;
                }
                catch (IllegalArgumentException ex) {
                    return false;
                }
            }
        };
    }

    public static ListComponent createListComponent(JList list) {
        return new JListListComponent(list);
    }

    public static ListComponent createListComponent(JTable table, DefaultListModel model) {
        return new JTableListComponent(table, model);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static final class JTableListComponent
    implements ListComponent {
        private JTable table;
        private DefaultListModel model;

        public JTableListComponent(JTable table, DefaultListModel model) {
            this.table = table;
            this.model = model;
        }

        @Override
        public Component getComponent() {
            return this.table;
        }

        @Override
        public int[] getSelectedIndices() {
            return this.table.getSelectedRows();
        }

        @Override
        public void setSelectedIndices(int[] indices) {
            this.table.clearSelection();
            for (int i = 0; i < indices.length; ++i) {
                this.table.addRowSelectionInterval(indices[i], indices[i]);
            }
        }

        @Override
        public DefaultListModel getModel() {
            return this.model;
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.table.getSelectionModel();
        }
    }

    private static final class JListListComponent
    implements ListComponent {
        private JList list;

        public JListListComponent(JList list) {
            this.list = list;
        }

        @Override
        public Component getComponent() {
            return this.list;
        }

        @Override
        public int[] getSelectedIndices() {
            return this.list.getSelectedIndices();
        }

        @Override
        public void setSelectedIndices(int[] indices) {
            this.list.setSelectedIndices(indices);
        }

        @Override
        public DefaultListModel getModel() {
            return (DefaultListModel)this.list.getModel();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.list.getSelectionModel();
        }
    }

    public static interface ListComponent {
        public Component getComponent();

        public int[] getSelectedIndices();

        public void setSelectedIndices(int[] var1);

        public DefaultListModel getModel();

        public ListSelectionModel getSelectionModel();
    }
}

