/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.print.ui.Attribute;
import org.netbeans.modules.print.ui.Paper;
import org.netbeans.modules.print.ui.Printer;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.Percent;
import org.netbeans.modules.print.util.UI;
import org.netbeans.spi.print.PrintPage;
import org.netbeans.spi.print.PrintProvider;
import org.openide.DialogDescriptor;

public final class Preview
extends UI.Dialog
implements Percent.Listener {
    private JPanel myPaperPanel;
    private List<Paper> myPapers;
    private JButton myFirst;
    private JButton myPrevious;
    private JButton myNext;
    private JButton myLast;
    private JButton myFit;
    private JButton myIncrease;
    private JButton myDecrease;
    private JButton myPrintButton;
    private JButton myCloseButton;
    private Percent myScale;
    private JTextField myGoto;
    private int myPaperNumber;
    private int myCustomIndex;
    private JToggleButton myToggle;
    private MyScrollPane myScrollPane;
    private KeyListener myKeyListener;
    private Printer myPrinter;
    private PrintProvider[] myPrintProviders;
    private static final int GAP_SIZE = 20;
    private static final int GOTO_WIDTH = 60;
    private static final int SCROLL_INCREMENT = 40;
    private static final double SCALE_RATIO = 1.05;
    private static final double PREVIEW_HEIGHT_RATIO = 0.66;
    private static final double PREVIEW_WIDTH_RATIO = 0.44;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 200, 400};
    private static final String LAST = "last";
    private static final String FIRST = "first";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";
    private final String[] CUSTOMS = new String[]{this.i18n("LBL_Fit_to_Width"), this.i18n("LBL_Fit_to_Height"), this.i18n("LBL_Fit_to_All")};
    private static final Preview DEFAULT = new Preview();

    public static Preview getDefault() {
        return DEFAULT;
    }

    private Preview() {
        this.myPrinter = new Printer();
        this.myKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                char ch = event.getKeyChar();
                int modifiers = event.getModifiers();
                if (ch == '+' || ch == '=') {
                    if (UI.isCtrl(modifiers)) {
                        Preview.this.increaseZoom();
                        Preview.this.updated();
                    } else {
                        Preview.this.myScale.increaseValue();
                    }
                } else if (ch == '-' || ch == '_') {
                    if (UI.isCtrl(modifiers)) {
                        Preview.this.decreaseZoom();
                        Preview.this.updated();
                    } else {
                        Preview.this.myScale.decreaseValue();
                    }
                } else if (ch == '/') {
                    Preview.this.myScale.normalValue();
                } else if (ch == '*') {
                    Preview.this.showCustom(true);
                }
            }
        };
    }

    public void print(PrintProvider[] providers, boolean withPreview) {
        assert (providers != null) : "Print providers cannot be null";
        assert (providers.length > 0) : "Must be at least one provider";
        this.myPrintProviders = providers;
        if (withPreview) {
            this.show(true);
        } else {
            this.print(true);
        }
    }

    private JPanel createPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 2);
        p.add((Component)this.createNavigatePanel(), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)this.createScalePanel(), c);
        c.anchor = 13;
        c.insets = new Insets(2, 13, 2, 0);
        this.myToggle = UI.createToggleButton(new UI.ButtonAction(UI.icon(Config.class, "toggle"), this.i18n("TLT_Toggle")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.toggle();
            }
        });
        this.myToggle.addKeyListener(this.myKeyListener);
        this.myToggle.setSelected(true);
        p.add((Component)this.myToggle, c);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(13, 0, 13, 0);
        panel.add((Component)p, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.createScrollPanel(), c);
        this.toggle();
        return panel;
    }

    @Override
    protected void updated() {
        this.createPapers();
        this.toggle();
    }

    private void toggle() {
        this.updatePaperNumber();
        this.addPapers();
        this.updateButtons();
    }

    private JComponent createNavigatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel = new JPanel(new GridBagLayout());
        c.insets = new Insets(2, 2, 2, 2);
        this.myFirst = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, FIRST), this.i18n("TLT_First")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.first();
            }
        });
        this.myFirst.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myFirst, c);
        this.myPrevious = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "previous"), this.i18n("TLT_Previous")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.previous();
            }
        });
        this.myPrevious.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myPrevious, c);
        this.myGoto = new JTextField();
        int height = this.myPrevious.getPreferredSize().height;
        this.myGoto.setPreferredSize(new Dimension(60, height));
        this.myGoto.setMinimumSize(new Dimension(60, height));
        InputMap inputMap = this.myGoto.getInputMap();
        ActionMap actionMap = this.myGoto.getActionMap();
        this.populateInputMap(inputMap);
        this.populateActionMap(actionMap);
        this.myGoto.setHorizontalAlignment(0);
        this.myGoto.setToolTipText(this.i18n("TLT_Goto"));
        this.myGoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.goTo();
            }
        });
        panel.add((Component)this.myGoto, c);
        this.myNext = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "next"), this.i18n("TLT_Next")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.next();
            }
        });
        this.myNext.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myNext, c);
        this.myLast = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, LAST), this.i18n("TLT_Last")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.last();
            }
        });
        this.myLast.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myLast, c);
        return panel;
    }

    private void populateInputMap(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke('k'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('K'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('+'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('='), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('g'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('G'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('-'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('_'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('l'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('L'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('*'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('f'), FIRST);
        inputMap.put(KeyStroke.getKeyStroke('F'), FIRST);
        inputMap.put(KeyStroke.getKeyStroke('/'), FIRST);
    }

    private void populateActionMap(ActionMap actionMap) {
        actionMap.put(INCREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.next();
            }
        });
        actionMap.put(DECREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.previous();
            }
        });
        actionMap.put(LAST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.last();
            }
        });
        actionMap.put(FIRST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.first();
            }
        });
    }

    private JComponent createScalePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 13, 2, 2);
        this.myFit = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "fit"), this.i18n("TLT_Fit")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.showCustom(true);
            }
        });
        this.myFit.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myFit, c);
        c.insets = new Insets(2, 2, 2, 2);
        this.myScale = new Percent(this, 1.0, PERCENTS, this.CUSTOMS.length - 1, this.CUSTOMS, this.i18n("TLT_Preview_Scale"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Preview.this.myScale.setValue(Preview.this.getAllWidthScale());
            }
        });
        int width = (int)Math.round((double)this.myScale.getPreferredSize().width * 1.05);
        int height = this.myPrevious.getPreferredSize().height;
        this.myScale.setPreferredSize(new Dimension(width, height));
        this.myScale.setMinimumSize(new Dimension(width, height));
        panel.add((Component)this.myScale, c);
        this.myDecrease = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "minus"), this.i18n("TLT_Zoom_Out")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.decreaseValue();
            }
        });
        this.myDecrease.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myDecrease, c);
        this.myIncrease = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "plus"), this.i18n("TLT_Zoom_In")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.increaseValue();
            }
        });
        this.myIncrease.addKeyListener(this.myKeyListener);
        panel.add((Component)this.myIncrease, c);
        return panel;
    }

    private JComponent createScrollPanel() {
        GridBagConstraints c = new GridBagConstraints();
        this.myPaperPanel = new JPanel(new GridBagLayout());
        this.myPaperPanel.setBackground(Color.lightGray);
        JPanel panel = new JPanel(new GridBagLayout());
        c.gridy = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.setBackground(Color.lightGray);
        panel.add((Component)this.myPaperPanel, c);
        c.fill = 1;
        this.myScrollPane = new MyScrollPane(panel);
        this.myScrollPane.setFocusable(true);
        this.myScrollPane.addWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                if (SwingUtilities.isRightMouseButton(event) || event.isControlDown()) {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(false);
                    if (event.getWheelRotation() > 0) {
                        Preview.this.myScale.increaseValue();
                    } else {
                        Preview.this.myScale.decreaseValue();
                    }
                } else {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(true);
                }
            }
        });
        this.myScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() != 2) {
                    return;
                }
                if (event.isControlDown()) {
                    if (SwingUtilities.isRightMouseButton(event)) {
                        Preview.this.decreaseZoom();
                    } else {
                        Preview.this.increaseZoom();
                    }
                    Preview.this.updated();
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    Preview.this.myScale.decreaseValue();
                } else {
                    Preview.this.myScale.increaseValue();
                }
            }
        });
        this.myScrollPane.addKeyListener(this.myKeyListener);
        return this.myScrollPane;
    }

    private void increaseZoom() {
        Config.getDefault().setZoom(Config.getDefault().getZoom() * 1.09);
    }

    private void decreaseZoom() {
        Config.getDefault().setZoom(Config.getDefault().getZoom() / 1.09);
    }

    private void showCustom(boolean doNext) {
        if (doNext) {
            ++this.myCustomIndex;
            if (this.myCustomIndex == this.CUSTOMS.length) {
                this.myCustomIndex = 0;
            }
        }
        this.myScale.customValue(this.myCustomIndex);
    }

    private void updateButtons() {
        this.myGoto.setText(this.getPaper(this.myPaperNumber));
        this.myFirst.setEnabled(this.myPaperNumber > 1);
        this.myPrevious.setEnabled(this.myPaperNumber > 1);
        this.myNext.setEnabled(this.myPaperNumber < this.getPaperCount());
        this.myLast.setEnabled(this.myPaperNumber < this.getPaperCount());
        boolean enabled = this.getPaperCount() > 0;
        this.myGoto.setEnabled(enabled);
        this.myScale.setEnabled(enabled);
        this.myToggle.setEnabled(enabled);
        this.myFit.setEnabled(enabled);
        this.myIncrease.setEnabled(enabled);
        this.myDecrease.setEnabled(enabled);
        this.myPrintButton.setEnabled(enabled);
    }

    private void scrollTo() {
        Paper paper = this.myPapers.get(this.myPaperNumber - 1);
        int gap = this.getGap();
        int x = paper.getX() - gap;
        int y = paper.getY() - gap;
        int w = paper.getWidth();
        int h = paper.getHeight();
        JViewport view = this.myScrollPane.getViewport();
        if (!view.getViewRect().contains(x, y, w, h)) {
            view.setViewPosition(new Point(x, y));
            this.updatePaperPanel();
        }
    }

    @Override
    public double getCustomValue(int index) {
        if (this.getPaperCount() == 0) {
            return 0.0;
        }
        int width = this.myPapers.get(0).getPaperWidth() + 20;
        int height = this.myPapers.get(0).getPaperHeight() + 20;
        if (index == 0) {
            return this.getWidthScale(width);
        }
        if (index == 1) {
            return this.getHeightScale(height);
        }
        if (index == 2) {
            return this.getAllScale(width, height);
        }
        return 1.0;
    }

    private double getWidthScale(int width) {
        int JAVA_INSET = 5;
        double scrollWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth() - 5;
        return scrollWidth / (double)width;
    }

    private double getHeightScale(int height) {
        int JAVA_INSET = 5;
        double scrollHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight() - 5;
        return scrollHeight / (double)height;
    }

    private double getAllScale(int width, int height) {
        int w = width;
        int h = height;
        if (!this.isSingleMode()) {
            int maxRow = 0;
            int maxColumn = 0;
            for (Paper paper : this.myPapers) {
                maxRow = Math.max(maxRow, paper.getRow());
                maxColumn = Math.max(maxColumn, paper.getColumn());
            }
            w *= maxColumn + 1;
            h *= maxRow + 1;
        }
        return Math.min(this.getWidthScale(w), this.getHeightScale(h));
    }

    private double getAllWidthScale() {
        if (this.myPapers == null) {
            this.createPapers();
        }
        if (this.myPapers.isEmpty()) {
            return 1.0;
        }
        int w = this.myPapers.get(0).getPaperWidth() + 20;
        if (!this.isSingleMode()) {
            int maxColumn = 0;
            for (Paper paper : this.myPapers) {
                maxColumn = Math.max(maxColumn, paper.getColumn());
            }
            w *= maxColumn + 1;
        }
        return this.getWidthScale(w);
    }

    @Override
    public void valueChanged(double value, int index) {
        if (index != -1) {
            this.myCustomIndex = index;
        }
        if (this.getPaperCount() == 0) {
            return;
        }
        for (Paper paper : this.myPapers) {
            paper.setScale(value);
        }
        this.addPapers();
    }

    private void addPapers() {
        this.myPaperPanel.removeAll();
        if (this.getPaperCount() == 0) {
            this.updatePaperPanel();
            return;
        }
        int gap = this.getGap();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(gap, gap, 0, 0);
        if (this.isSingleMode()) {
            this.myPaperPanel.add((Component)this.myPapers.get(this.myPaperNumber - 1), c);
        } else {
            for (Paper paper : this.myPapers) {
                c.gridx = paper.getColumn();
                c.gridy = paper.getRow();
                this.myPaperPanel.add((Component)paper, c);
            }
        }
        this.updatePaperPanel();
    }

    private void updatePaperPanel() {
        this.myPaperPanel.revalidate();
        this.myPaperPanel.repaint();
    }

    private void createPapers() {
        this.myPapers = new ArrayList<Paper>();
        int width = Config.getDefault().getPageWidth();
        int height = Config.getDefault().getPageHeight();
        double zoom = Config.getDefault().getZoom();
        double scale = 1.0;
        if (this.myScale != null) {
            scale = this.myScale.getValue();
        }
        int delta = 0;
        int number = 0;
        for (PrintProvider provider : this.myPrintProviders) {
            Date lastModified;
            String name = provider.getName();
            if (name == null) {
                name = "";
            }
            if ((lastModified = provider.lastModified()) == null) {
                lastModified = new Date(System.currentTimeMillis());
            }
            PrintPage[][] pages = provider.getPages(width, height, zoom);
            for (int i = 0; i < pages.length; ++i) {
                for (int j = 0; j < pages[i].length; ++j) {
                    PrintPage page = pages[i][j];
                    if (page == null) continue;
                    Paper paper = new Paper(page, name, lastModified);
                    paper.setCoordinate(number + 1, i + delta, j, scale);
                    this.myPapers.add(paper);
                    ++number;
                }
            }
            delta += pages.length;
        }
        int count = this.myPapers.size();
        for (Paper paper : this.myPapers) {
            paper.setCount(count);
        }
    }

    private int getPaperCount() {
        if (this.myPapers == null) {
            return 0;
        }
        return this.myPapers.size();
    }

    @Override
    public void invalidValue(String value) {
    }

    private void first() {
        this.updatePaperNumber();
        this.changePaper();
    }

    private void previous() {
        if (this.myPaperNumber == 1) {
            return;
        }
        --this.myPaperNumber;
        this.changePaper();
    }

    private void next() {
        if (this.myPaperNumber == this.getPaperCount()) {
            return;
        }
        ++this.myPaperNumber;
        this.changePaper();
    }

    private void last() {
        this.myPaperNumber = this.getPaperCount();
        this.changePaper();
    }

    private void goTo() {
        String value = this.myGoto.getText();
        int number = this.getPaperNumber(value);
        int count = this.getPaperCount();
        if (number < 1 || number > count) {
            this.myGoto.setText(this.getPaper(this.myPaperNumber));
        } else {
            this.myPaperNumber = number;
            this.changePaper();
        }
        this.myGoto.selectAll();
    }

    private void changePaper() {
        if (this.isSingleMode()) {
            this.addPapers();
        } else {
            this.scrollTo();
        }
        this.updateButtons();
    }

    private void updatePaperNumber() {
        this.myPaperNumber = this.getPaperCount() == 0 ? 0 : 1;
    }

    private int getGap() {
        return (int)Math.round(20.0 * this.myScale.getValue());
    }

    private String getPaper(int value) {
        return Config.getPageOfCount(String.valueOf(value), String.valueOf(this.getPaperCount()));
    }

    @Override
    protected DialogDescriptor createDescriptor() {
        Object[] rightButtons = this.getRightButtons();
        Object[] leftButtons = this.getLeftButtons();
        DialogDescriptor descriptor = new DialogDescriptor((Object)UI.getResizableXY(this.createPanel()), this.i18n("LBL_Print_Preview"), true, rightButtons, (Object)this.myPrintButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{this.myPrintButton, this.myCloseButton});
        descriptor.setAdditionalOptions(leftButtons);
        return descriptor;
    }

    @Override
    protected void opened() {
        this.myScrollPane.requestFocus();
    }

    @Override
    protected void resized() {
        if (this.myScale.isCustomValue()) {
            this.showCustom(false);
        }
    }

    private Object[] getLeftButtons() {
        JButton pageSetup = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Page_Setup_Button"), this.i18n("TLT_Page_Setup_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Config.getDefault().showPageSetup()) {
                    Preview.this.updated();
                }
            }
        });
        JButton printOption = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Print_Option_Button"), this.i18n("TLT_Print_Option_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.option();
            }
        });
        printOption.addKeyListener(this.myKeyListener);
        return new Object[]{pageSetup, printOption};
    }

    private Object[] getRightButtons() {
        this.myPrintButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Print_Button"), this.i18n("TLT_Print_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.print(false);
            }
        });
        this.myPrintButton.addKeyListener(this.myKeyListener);
        this.myCloseButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Close_Button"), this.i18n("TLT_Close_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.myCloseButton.addKeyListener(this.myKeyListener);
        return new Object[]{this.myPrintButton, this.myCloseButton};
    }

    @Override
    protected void closed() {
        this.myPapers = null;
        this.myPrintProviders = null;
    }

    private boolean isSingleMode() {
        return !this.myToggle.isSelected();
    }

    private void print(boolean doUpdate) {
        if (doUpdate) {
            this.createPapers();
        }
        this.myPrinter.print(this.myPapers);
    }

    private void option() {
        new Attribute(this).show(false);
    }

    private int getPaperNumber(String text) {
        char c;
        String value = text.trim();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length() && UI.isDigit(c = value.charAt(i)); ++i) {
            builder.append(c);
        }
        return UI.getInt(builder.toString());
    }

    private static final class MyScrollPane
    extends JScrollPane {
        private List<MouseWheelListener> myMouseWheelListeners;

        MyScrollPane(JPanel panel) {
            super(panel, 22, 32);
            this.getVerticalScrollBar().setUnitIncrement(40);
            int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            int height = (int)Math.round((double)screenHeight * 0.66);
            int width = (int)Math.round((double)height * 0.44);
            Dimension dimension = new Dimension(width, height);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public void addMouseWheelListener(MouseWheelListener listener) {
            if (this.myMouseWheelListeners == null) {
                this.myMouseWheelListeners = new ArrayList<MouseWheelListener>();
            }
            this.myMouseWheelListeners.add(listener);
        }

        public void addWheelListener(MouseWheelListener wheelListener) {
            super.addMouseWheelListener(wheelListener);
            for (int i = 0; i < this.myMouseWheelListeners.size(); ++i) {
                super.addMouseWheelListener(this.myMouseWheelListeners.get(i));
            }
        }
    }
}

