/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.api;

import java.awt.Image;
import java.net.URL;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.Bundle;
import org.netbeans.modules.cordova.platforms.api.ClientProjectUtilities;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.browser.spi.MessageDispatcher;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.WebKitUIManager;
import org.netbeans.modules.web.webkit.debugging.spi.Factory;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class WebKitDebuggingSupport {
    private static WebKitDebuggingSupport instance;
    private Session debuggerSession;
    private Lookup consoleLogger;
    private Lookup networkMonitor;
    private WebKitDebugging webKitDebugging;
    private MobileDebugTransport transport;
    private MessageDispatcherImpl dispatcher;
    private final RequestProcessor RP = new RequestProcessor(WebKitDebuggingSupport.class.getName(), 10);
    private volatile boolean startDebuggingInProgress = true;

    public static synchronized WebKitDebuggingSupport getDefault() {
        if (instance == null) {
            instance = new WebKitDebuggingSupport();
        }
        return instance;
    }

    private static String getProgressLabel(Device dev) {
        if ("ios".equals(dev.getPlatform().getType())) {
            return dev.isEmulator() ? Bundle.LBL_ConnectionIOSSimulator() : Bundle.LBL_ConnectingIOSDevice();
        }
        return dev.isEmulator() ? Bundle.LBL_ConnectionAndroidEmulator() : Bundle.LBL_ConnectionAndroidDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startDebugging(Device device, Project p, Lookup context, boolean navigateToUrl) {
        if (this.transport != null || this.webKitDebugging != null) {
            this.stopDebuggingNow(false);
        }
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)WebKitDebuggingSupport.getProgressLabel(device), (Cancellable)new Cancellable(){

            public boolean cancel() {
                WebKitDebuggingSupport.this.stopDebugging(true);
                return true;
            }
        });
        handle.start();
        this.startDebuggingInProgress = true;
        try {
            boolean attached;
            this.transport = device.getDebugTransport();
            String url = this.getUrl(p, context);
            this.transport.setBaseUrl(url);
            if (url == null) {
                String id = (String)context.lookup(String.class);
                this.transport.setBundleIdentifier(id);
                BrowserURLMapperImplementation.BrowserURLMapper mapper = (BrowserURLMapperImplementation.BrowserURLMapper)context.lookup(BrowserURLMapperImplementation.BrowserURLMapper.class);
                this.transport.setBrowserURLMapper(mapper);
            }
            if (!(attached = this.transport.attach())) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.transport == null) {
                return;
            }
            this.webKitDebugging = Factory.createWebKitDebugging((TransportImplementation)this.transport);
            if (navigateToUrl) {
                this.webKitDebugging.getPage().navigate(url);
            }
            this.webKitDebugging.getDebugger().enable();
            Lookup projectContext = Lookups.singleton((Object)p);
            this.debuggerSession = WebKitUIManager.getDefault().createDebuggingSession(this.webKitDebugging, projectContext);
            this.consoleLogger = WebKitUIManager.getDefault().createBrowserConsoleLogger(this.webKitDebugging, projectContext);
            this.networkMonitor = WebKitUIManager.getDefault().createNetworkMonitor(this.webKitDebugging, projectContext);
            this.dispatcher = new MessageDispatcherImpl();
            BrowserFamilyId browserFamilyId = (BrowserFamilyId)context.lookup(BrowserFamilyId.class);
            if (browserFamilyId == null) {
                browserFamilyId = BrowserFamilyId.UNKNOWN;
            }
            PageInspector.getDefault().inspectPage(Lookups.fixed((Object[])new Object[]{this.webKitDebugging, p, context.lookup(Image.class), browserFamilyId, this.dispatcher}));
        }
        finally {
            this.startDebuggingInProgress = false;
            handle.finish();
        }
    }

    public void stopDebugging(final boolean fullCleanup) {
        if (this.transport != null && fullCleanup) {
            this.transport.flush();
            if (this.webKitDebugging == null) {
                this.transport.detach();
                this.transport = null;
            }
        }
        if (this.startDebuggingInProgress && !fullCleanup) {
            return;
        }
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                WebKitDebuggingSupport.this.stopDebuggingNow(fullCleanup);
            }
        });
    }

    private synchronized void stopDebuggingNow(boolean fullCleanup) {
        if (this.webKitDebugging == null || this.webKitDebugging == null) {
            return;
        }
        if (this.debuggerSession != null) {
            WebKitUIManager.getDefault().stopDebuggingSession(this.debuggerSession);
        }
        this.debuggerSession = null;
        if (this.consoleLogger != null) {
            WebKitUIManager.getDefault().stopBrowserConsoleLogger(this.consoleLogger);
        }
        this.consoleLogger = null;
        if (this.networkMonitor != null) {
            WebKitUIManager.getDefault().stopNetworkMonitor(this.networkMonitor);
        }
        this.networkMonitor = null;
        if (this.webKitDebugging.getDebugger().isEnabled()) {
            this.webKitDebugging.getDebugger().disable();
        }
        this.dispatcher.dispose();
        if (fullCleanup) {
            this.webKitDebugging.getRuntime().evaluate("0");
        }
        this.webKitDebugging.reset();
        if (this.transport != null) {
            this.transport.detach();
            this.transport = null;
        }
        this.webKitDebugging = null;
    }

    public void reload() {
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                if (WebKitDebuggingSupport.this.webKitDebugging != null) {
                    WebKitDebuggingSupport.this.webKitDebugging.getPage().reload(true, null);
                }
            }
        });
    }

    public FileObject getFile(Project p, Lookup context) {
        DataObject dObject = (DataObject)context.lookup(DataObject.class);
        FileObject fileObject = dObject == null ? ClientProjectUtilities.getStartFile(p) : dObject.getPrimaryFile();
        return fileObject;
    }

    private String getUrl(Project p) {
        return this.getUrl(p, Lookup.EMPTY);
    }

    public String getUrl(Project p, Lookup context) {
        FileObject fileObject;
        if (ClientProjectUtilities.isUsingEmbeddedServer(p)) {
            WebServer.getWebserver().start(p, ClientProjectUtilities.getSiteRoot(p), ClientProjectUtilities.getWebContextRoot(p));
        } else {
            WebServer.getWebserver().stop(p);
        }
        if (context == null || context.lookup(BrowserURLMapperImplementation.BrowserURLMapper.class) != null) {
            return null;
        }
        URL url = (URL)context.lookup(URL.class);
        if (url != null) {
            return url.toExternalForm().replace("localhost", WebUtils.getLocalhostInetAddress().getHostAddress());
        }
        DataObject dObject = (DataObject)context.lookup(DataObject.class);
        FileObject fileObject2 = fileObject = dObject == null ? ClientProjectUtilities.getStartFile(p) : dObject.getPrimaryFile();
        if (fileObject == null) {
            return null;
        }
        return ServerURLMapping.toServer((Project)p, (FileObject)fileObject).toExternalForm().replace("localhost", WebUtils.getLocalhostInetAddress().getHostAddress());
    }

    static class MessageDispatcherImpl
    extends MessageDispatcher {
        MessageDispatcherImpl() {
        }

        void dispose() {
            this.dispatchMessage("inspect", null);
        }
    }
}

