/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.assertion.saml11.jaxb20;

import com.sun.xml.wss.saml.AuthorityBinding;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml11.jaxb20.Subject;
import com.sun.xml.wss.saml.assertion.saml11.jaxb20.SubjectLocality;
import com.sun.xml.wss.saml.internal.saml11.jaxb20.AuthenticationStatementType;
import com.sun.xml.wss.saml.internal.saml11.jaxb20.AuthorityBindingType;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import com.sun.xml.wss.util.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.w3c.dom.Element;

public class AuthenticationStatement
extends AuthenticationStatementType
implements com.sun.xml.wss.saml.AuthenticationStatement {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private List<AuthorityBinding> authorityBindingList = null;
    private Date instantDate = null;

    protected AuthenticationStatement() {
    }

    public static AuthenticationStatementType fromElement(Element element) throws SAMLException {
        try {
            JAXBContext jc = SAMLJAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            return (AuthenticationStatementType)u.unmarshal(element);
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }

    private void setAuthorityBinding(List authorityBinding) {
        this.authorityBinding = authorityBinding;
    }

    public AuthenticationStatement(String authMethod, GregorianCalendar authInstant, Subject subject, SubjectLocality subjectLocality, List authorityBinding) {
        if (authMethod != null) {
            this.setAuthenticationMethod(authMethod);
        }
        if (authInstant != null) {
            try {
                DatatypeFactory factory = DatatypeFactory.newInstance();
                this.setAuthenticationInstant(factory.newXMLGregorianCalendar(authInstant));
            }
            catch (DatatypeConfigurationException ex) {
                // empty catch block
            }
        }
        if (subject != null) {
            this.setSubject(subject);
        }
        if (subjectLocality != null) {
            this.setSubjectLocality(subjectLocality);
        }
        if (authorityBinding != null) {
            this.setAuthorityBinding(authorityBinding);
        }
    }

    public AuthenticationStatement(AuthenticationStatementType authStmtType) {
        this.setAuthenticationMethod(authStmtType.getAuthenticationMethod());
        this.setAuthenticationInstant(authStmtType.getAuthenticationInstant());
        if (authStmtType.getSubject() != null) {
            Subject subj = new Subject(authStmtType.getSubject());
            this.setSubject(subj);
        }
        this.setSubjectLocality(authStmtType.getSubjectLocality());
        this.setAuthorityBinding(authStmtType.getAuthorityBinding());
    }

    @Override
    public Date getAuthenticationInstantDate() {
        if (this.instantDate != null) {
            return this.instantDate;
        }
        try {
            if (super.getAuthenticationInstant() != null) {
                this.instantDate = DateUtils.stringToDate(super.getAuthenticationInstant().toString());
            }
        }
        catch (ParseException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        return this.instantDate;
    }

    @Override
    public String getAuthenticationMethod() {
        return super.getAuthenticationMethod();
    }

    @Override
    public List<AuthorityBinding> getAuthorityBindingList() {
        if (this.authorityBindingList == null) {
            return this.authorityBindingList;
        }
        this.authorityBindingList = new ArrayList<AuthorityBinding>();
        Iterator<AuthorityBindingType> it = super.getAuthorityBinding().iterator();
        while (it.hasNext()) {
            com.sun.xml.wss.saml.assertion.saml11.jaxb20.AuthorityBinding obj = new com.sun.xml.wss.saml.assertion.saml11.jaxb20.AuthorityBinding(it.next());
            this.authorityBindingList.add(obj);
        }
        return this.authorityBindingList;
    }

    @Override
    public String getSubjectLocalityIPAddress() {
        if (super.getSubjectLocality() != null) {
            return super.getSubjectLocality().getIPAddress();
        }
        return null;
    }

    @Override
    public String getSubjectLocalityDNSAddress() {
        if (super.getSubjectLocality() != null) {
            return super.getSubjectLocality().getDNSAddress();
        }
        return null;
    }

    @Override
    public Subject getSubject() {
        return (Subject)super.getSubject();
    }
}

