/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.misc.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;

public class X509ThumbPrintIdentifier
extends KeyIdentifier {
    private String encodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private String valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1";
    private X509Certificate cert = null;

    public X509ThumbPrintIdentifier(Document doc) throws XWSSecurityException {
        super(doc);
        this.setAttribute("EncodingType", this.encodingType);
        this.setAttribute("ValueType", this.valueType);
    }

    public X509ThumbPrintIdentifier(SOAPElement element) throws XWSSecurityException {
        super(element);
    }

    public byte[] getDecodedBase64EncodedValue() throws XWSSecurityException {
        try {
            return Base64.decode(this.getReferenceValue());
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", new Object[]{e.getMessage()});
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }

    public static byte[] getThumbPrintIdentifier(X509Certificate cert) throws XWSSecurityException {
        byte[] thumbPrintIdentifier = null;
        try {
            thumbPrintIdentifier = MessageDigest.getInstance("SHA-1").digest(cert.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XWSSecurityException("Digest algorithm SHA-1 not found");
        }
        catch (CertificateEncodingException ex) {
            throw new XWSSecurityException("Error while getting certificate's raw content");
        }
        return thumbPrintIdentifier;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

