/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.actions;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;

public class StepActionProvider
extends JPDADebuggerActionProvider {
    private static final Logger LOG = Logger.getLogger(StepActionProvider.class.getName());
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_CONTINUE)));

    public StepActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        JPDAThread currentThread = this.getDebuggerImpl().getCurrentThread();
        while (i.hasNext()) {
            this.setEnabled(i.next(), debuggerState == 3 && currentThread != null && TruffleAccess.getCurrentPCInfo(currentThread) != null);
        }
    }

    public void doAction(Object action) {
        LOG.fine("doAction(" + action + ")");
        JPDADebuggerImpl debugger = this.getDebuggerImpl();
        JPDAThread currentThread = debugger.getCurrentThread();
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(currentThread);
        int stepCmd = 0;
        if (ActionsManager.ACTION_CONTINUE.equals(action)) {
            stepCmd = 0;
        } else if (ActionsManager.ACTION_STEP_INTO.equals(action)) {
            stepCmd = 1;
        } else if (ActionsManager.ACTION_STEP_OVER.equals(action)) {
            stepCmd = 2;
        } else if (ActionsManager.ACTION_STEP_OUT.equals(action)) {
            stepCmd = 3;
        }
        try {
            currentPCInfo.getStepCommandVar().setFromMirrorObject((Object)stepCmd);
        }
        catch (InvalidObjectException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StepActionProvider.killJavaStep(debugger);
        if (stepCmd > 0) {
            debugger.resumeCurrentThread();
        } else {
            debugger.resume();
        }
    }

    public static void killJavaStep(JPDADebugger debugger) {
        StepActionProvider.killJavaStep((JPDADebuggerImpl)debugger);
    }

    private static void killJavaStep(JPDADebuggerImpl debugger) {
        ArrayList stepRequests;
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        EventRequestManager erm = vm.eventRequestManager();
        try {
            stepRequests = EventRequestManagerWrapper.stepRequests((EventRequestManager)erm);
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return;
        }
        if (stepRequests.isEmpty()) {
            return;
        }
        stepRequests = new ArrayList(stepRequests);
        for (StepRequest sr : stepRequests) {
            try {
                EventRequestManagerWrapper.deleteEventRequest((EventRequestManager)erm, (EventRequest)sr);
                debugger.getOperator().unregister((EventRequest)sr);
            }
            catch (InternalExceptionWrapper | InvalidRequestStateExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {}
        }
    }

    public Set getActions() {
        return ACTIONS;
    }
}

