/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientRootChildren;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JaxWsClientRootNode
extends AbstractNode {
    private static final String SERVICES_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png";
    private Icon folderIconCache;
    private Icon openedFolderIconCache;
    private Image cachedServicesBadge;

    public JaxWsClientRootNode(JaxWsModel jaxWsModel, FileObject srcRoot) {
        super((Children)new JaxWsClientRootChildren(jaxWsModel, srcRoot), JaxWsClientRootNode.createLookup(srcRoot));
        this.setDisplayName(NbBundle.getBundle(JaxWsClientRootNode.class).getString("LBL_ServiceReferences"));
    }

    public Image getIcon(int type) {
        return this.computeIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true);
    }

    private Image getServicesImage() {
        if (this.cachedServicesBadge == null) {
            this.cachedServicesBadge = ImageUtilities.loadImage((String)SERVICES_BADGE);
        }
        return this.cachedServicesBadge;
    }

    private Icon getFolderIcon(boolean opened) {
        if (this.openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            this.openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            this.folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return this.openedFolderIconCache;
        }
        return this.folderIconCache;
    }

    private Image computeIcon(boolean opened) {
        Icon icon = this.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static Lookup createLookup(FileObject srcRoot) {
        Project owner = FileOwnerQuery.getOwner((FileObject)srcRoot);
        return owner != null ? Lookups.fixed((Object[])new Object[]{owner}) : null;
    }
}

