/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.subtable;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.renderkit.CoreRenderer;

public class SubTableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SubTable table = (SubTable)component;
        int rowCount = table.getRowCount();
        this.encodeHeader(context, table);
        for (int i = 0; i < rowCount; ++i) {
            this.encodeRow(context, table, i);
        }
        this.encodeFooter(context, table);
    }

    public void encodeHeader(FacesContext context, SubTable table) throws IOException {
        ColumnGroup group;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getFacet("header");
        if (header != null) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-header", null);
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-subtable-header", null);
            writer.writeAttribute("colspan", (Object)table.getColumns().size(), null);
            header.encodeAll(context);
            writer.endElement("td");
            writer.endElement("tr");
        }
        if ((group = table.getColumnGroup("header")) != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row headerRow = (Row)child;
                writer.startElement("tr", null);
                writer.writeAttribute("class", (Object)"ui-widget-header", null);
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    if (!headerRowChild.isRendered() || !(headerRowChild instanceof Column)) continue;
                    Column footerColumn = (Column)headerRowChild;
                    this.encodeFacetColumn(context, table, footerColumn, "header", "ui-state-default", footerColumn.getHeaderText());
                }
                writer.endElement("tr");
            }
        }
    }

    public void encodeRow(FacesContext context, SubTable table, int rowIndex) throws IOException {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(clientId + "_row_" + rowIndex), null);
        writer.writeAttribute("class", (Object)"ui-widget-content", null);
        for (Column column : table.getColumns()) {
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            writer.startElement("td", null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            column.encodeAll(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    public void encodeFooter(FacesContext context, SubTable table) throws IOException {
        ColumnGroup group;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFacet("footer");
        if (footer != null) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-header", null);
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-subtable-footer", null);
            writer.writeAttribute("colspan", (Object)table.getColumns().size(), null);
            footer.encodeAll(context);
            writer.endElement("td");
            writer.endElement("tr");
        }
        if ((group = table.getColumnGroup("footer")) == null || !group.isRendered()) {
            return;
        }
        for (UIComponent child : group.getChildren()) {
            if (!child.isRendered() || !(child instanceof Row)) continue;
            Row footerRow = (Row)child;
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-header", null);
            for (UIComponent footerRowChild : footerRow.getChildren()) {
                if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                Column footerColumn = (Column)footerRowChild;
                this.encodeFacetColumn(context, table, footerColumn, "footer", "ui-state-default", footerColumn.getFooterText());
            }
            writer.endElement("tr");
        }
    }

    protected void encodeFacetColumn(FacesContext context, SubTable table, Column column, String facetName, String styleClass, String text) throws IOException {
        UIComponent facet;
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String columnClass = column.getStyleClass();
        columnClass = columnClass == null ? styleClass : styleClass + " " + columnClass;
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)columnClass, null);
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((facet = column.getFacet(facetName)) != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("td");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

