/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class DeleteFile
extends SimpleRefactoringElementImplementation {
    private final URL res;
    private String filename;
    private RefactoringElementsBag session;
    BackupFacility.Handle id;

    public DeleteFile(FileObject fo, RefactoringElementsBag session) {
        this.res = fo.toURL();
        this.filename = fo.getNameExt();
        this.session = session;
    }

    public String getText() {
        return Bundle.TXT_DeleteFile(this.filename);
    }

    public String getDisplayText() {
        return this.getText();
    }

    public void performChange() {
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.res);
            if (fo == null) {
                throw new IOException(this.res.toString());
            }
            this.id = BackupFacility.getDefault().backup(new FileObject[]{fo});
            DataObject.find((FileObject)fo).delete();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void undoChange() {
        try {
            try {
                File f = Utilities.toFile((URI)this.res.toURI());
                if (f.exists()) {
                    throw new CannotUndoRefactoring(Collections.singleton(f.getPath()));
                }
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.id.restore();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return URLMapper.findFileObject((URL)this.res);
    }

    public PositionBounds getPosition() {
        return null;
    }

    private class CannotUndoRefactoring
    extends CannotUndoException {
        private Collection<String> files;

        public CannotUndoRefactoring(Collection<String> checkChecksum) {
            this.files = checkChecksum;
        }

        @Override
        public String getMessage() {
            StringBuilder b = new StringBuilder("Cannot Undo.\nFollowing files were modified:\n");
            for (String f : this.files) {
                b.append(f);
                b.append('\n');
            }
            return b.toString();
        }

        public Collection<String> getFiles() {
            return this.files;
        }
    }
}

