/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.ModuleSelector;
import org.netbeans.nbbuild.XMLUtil;
import org.xml.sax.SAXException;

public class MakeJNLP
extends Task {
    private ResourceCollection files;
    private SignJar signTask;
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String UTF_8 = "UTF-8";
    private static final String ATTR_CODEBASE = "Codebase";
    private static final String ATTR_PERMISSIONS = "Permissions";
    private static final String ATTR_APPLICATION_NAME = "Application-Name";
    private File targetFile;
    private String appName;
    private final String manifestPermissions = "all-permissions";
    private final String manifestCodebase = "*";
    private String codebase = "$$codebase";
    private boolean verify;
    private String verifyExcludes;
    private String permissions = "<all-permissions/>";
    private FileSet indirectJars;
    private FileSet indirectFiles;
    private boolean signJars = true;
    private boolean processJarVersions = false;
    private Map<String, String> jarVersions;
    private Set<String> nativeLibraries;
    private Set<File> jarDirectories;
    private String includelocales;
    private static final Pattern SF = Pattern.compile("META-INF/(.+)\\.SF");

    public FileSet createModules() throws BuildException {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        this.addConfigured((ResourceCollection)fs);
        return fs;
    }

    public void addConfigured(ResourceCollection rc) throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be specified just once");
        }
        this.files = rc;
    }

    private SignJar getSignTask() {
        if (this.signTask == null) {
            this.signTask = (SignJar)this.getProject().createTask("signjar");
        }
        return this.signTask;
    }

    public void setDir(File t) {
        this.targetFile = t;
    }

    public void setAlias(String a) {
        this.getSignTask().setAlias(a);
    }

    public void setStorePass(String p) {
        this.getSignTask().setStorepass(p);
    }

    public void setKeystore(String k) {
        this.getSignTask().setKeystore(k);
    }

    public void setStoreType(String t) {
        this.getSignTask().setStoretype(t);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setVerify(boolean v) {
        this.verify = v;
    }

    public void setVerifyExcludes(String s) {
        this.verifyExcludes = s;
    }

    public void setPermissions(String s) {
        this.permissions = s;
    }

    public void addIndirectJars(FileSet fs) {
        this.indirectJars = fs;
    }

    public void addIndirectFiles(FileSet fs) {
        this.indirectFiles = fs;
    }

    public void setSignJars(boolean s) {
        this.signJars = s;
    }

    public void setProcessJarVersions(boolean b) {
        this.processJarVersions = b;
    }

    public void setJarVersions(Map<String, String> jarVersions) {
        this.jarVersions = jarVersions;
    }

    public void setNativeLibraries(Set<String> libs) {
        this.nativeLibraries = libs;
    }

    public void setIncludelocales(String includelocales) {
        this.includelocales = includelocales;
    }

    private void signOrCopy(File from, File to) {
        if (!from.exists() && from.getParentFile().getName().equals("locale")) {
            this.log("Localization file " + from + " is referenced, but cannot be found. Skipping.", 1);
            return;
        }
        if (this.signJars) {
            this.getSignTask().setJar(from);
            if (to != null) {
                to.getParentFile().mkdirs();
            }
            this.getSignTask().setSignedjar(to);
            this.getSignTask().setDigestAlg("SHA1");
            this.getSignTask().execute();
        } else if (to != null) {
            Copy copy = (Copy)this.getProject().createTask("copy");
            copy.setFile(from);
            copy.setTofile(to);
            copy.execute();
        }
        if (this.processJarVersions) {
            if (this.jarDirectories == null) {
                this.jarDirectories = new HashSet<File>();
            }
            this.jarDirectories.add(new File(to.getParent()));
        }
    }

    public void execute() throws BuildException {
        if (this.targetFile == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
            if (this.processJarVersions && this.jarDirectories != null && this.jarDirectories.size() > 0) {
                this.generateVersionXMLFiles();
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        HashSet<String> declaredLocales = new HashSet<String>();
        boolean useAllLocales = false;
        if (this.includelocales == null || "*".equals(this.includelocales)) {
            useAllLocales = true;
        } else if ("".equals(this.includelocales)) {
            useAllLocales = false;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.includelocales, ",");
            while (tokenizer.hasMoreElements()) {
                declaredLocales.add(tokenizer.nextToken());
            }
        }
        HashSet<String> indirectFilePaths = new HashSet<String>();
        File tmpFile = null;
        for (FileSet fs : new FileSet[]{this.indirectJars, this.indirectFiles}) {
            if (fs == null) continue;
            DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
            for (String f : scan.getIncludedFiles()) {
                indirectFilePaths.add(f.replace(File.separatorChar, '/'));
            }
        }
        for (FileResource fr : this.files) {
            File jar = fr.getFile();
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            Throwable throwable = null;
            try {
                String codenamebase = JarWithModuleAttributes.extractCodeName(theJar.getManifest().getMainAttributes());
                if (codenamebase == null) {
                    throw new BuildException("Not a NetBeans Module: " + jar);
                }
                if (codenamebase.equals("org.objectweb.asm.all") && jar.getParentFile().getName().equals("core") && jar.getParentFile().getParentFile().getName().startsWith("platform")) continue;
                int slash = codenamebase.indexOf(47);
                if (slash >= 0) {
                    codenamebase = codenamebase.substring(0, slash);
                }
                String dashcnb = codenamebase.replace('.', '-');
                String osDep = null;
                String bundle = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
                Properties prop = new Properties();
                if (bundle != null) {
                    java.util.zip.ZipEntry en = theJar.getEntry(bundle);
                    if (en == null) {
                        throw new BuildException("Cannot find entry: " + bundle + " in file: " + jar);
                    }
                    InputStream is = theJar.getInputStream(en);
                    Object object = null;
                    try {
                        prop.load(is);
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                String title = prop.getProperty("OpenIDE-Module-Name", codenamebase);
                String oneline = prop.getProperty("OpenIDE-Module-Short-Description", title);
                String shrt = prop.getProperty("OpenIDE-Module-Long-Description", oneline);
                String osMan = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Requires");
                if (osMan != null) {
                    if (osMan.indexOf("org.openide.modules.os.MacOSX") >= 0) {
                        osDep = "Mac OS X";
                    } else if (osMan.indexOf("org.openide.modules.os.Linux") >= 0) {
                        osDep = "Linux";
                    } else if (osMan.indexOf("org.openide.modules.os.Solaris") >= 0) {
                        osDep = "Solaris";
                    } else if (osMan.indexOf("org.openide.modules.os.Windows") >= 0) {
                        osDep = "Windows";
                    }
                }
                Map<String, List<File>> localizedFiles = this.verifyExtensions(jar, theJar.getManifest(), dashcnb, codenamebase, this.verify, indirectFilePaths);
                new File(this.targetFile, dashcnb).mkdir();
                File signed = new File(new File(this.targetFile, dashcnb), jar.getName());
                File jnlp = new File(this.targetFile, dashcnb + ".jnlp");
                StringWriter writeJNLP = new StringWriter();
                writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Descriptor 6.0//EN\" \"http://java.sun.com/dtd/JNLP-6.0.dtd\">\n");
                writeJNLP.write("<jnlp spec='1.0+' codebase='" + this.codebase + "'>\n");
                writeJNLP.write("  <information>\n");
                writeJNLP.write("   <title>" + XMLUtil.toElementContent(title) + "</title>\n");
                writeJNLP.write("   <vendor>NetBeans</vendor>\n");
                writeJNLP.write("   <description kind='one-line'>" + XMLUtil.toElementContent(oneline) + "</description>\n");
                writeJNLP.write("   <description kind='short'>" + XMLUtil.toElementContent(shrt) + "</description>\n");
                writeJNLP.write("  </information>\n");
                writeJNLP.write(this.permissions + "\n");
                if (osDep == null) {
                    writeJNLP.write("  <resources>\n");
                } else {
                    writeJNLP.write("  <resources os='" + osDep + "'>\n");
                }
                writeJNLP.write(this.constructJarHref(jar, dashcnb));
                this.processExtensions(jar, theJar.getManifest(), writeJNLP, dashcnb, this.codebase);
                this.processIndirectJars(writeJNLP, dashcnb);
                this.processIndirectFiles(writeJNLP, dashcnb);
                writeJNLP.write("  </resources>\n");
                if (useAllLocales || !declaredLocales.isEmpty()) {
                    for (Map.Entry entry : localizedFiles.entrySet()) {
                        String locale = (String)entry.getKey();
                        if (!declaredLocales.isEmpty() && !declaredLocales.contains(locale)) continue;
                        List allFiles = (List)entry.getValue();
                        writeJNLP.write("  <resources locale='" + locale + "'>\n");
                        for (File n : allFiles) {
                            this.log("generating locale " + locale + " for " + n, 3);
                            String name = n.getName();
                            String clusterRootPrefix = jar.getParent() + File.separatorChar;
                            String absname = n.getAbsolutePath();
                            if (absname.startsWith(clusterRootPrefix)) {
                                name = absname.substring(clusterRootPrefix.length()).replace(File.separatorChar, '-');
                            }
                            File t = new File(new File(this.targetFile, dashcnb), name);
                            File localeTmpFile = null;
                            if (n.exists() && MakeJNLP.isSigned(n) == null) {
                                try {
                                    localeTmpFile = this.extendLibraryManifest(this.getProject(), n, t, "*", "all-permissions", this.appName, jnlp);
                                }
                                catch (IOException | ManifestException ex) {
                                    this.getProject().log("Failed to extend libraries manifests: " + ex.getMessage(), 1);
                                }
                            } else {
                                this.getProject().log(String.format("Not adding security attributes into locale library: %s the library is already signed.", MakeJNLP.safeRelativePath(this.getProject().getBaseDir(), t)), 1);
                            }
                            if (localeTmpFile != null) {
                                this.signOrCopy(localeTmpFile, t);
                                MakeJNLP.deleteTmpFile(localeTmpFile);
                            } else {
                                this.signOrCopy(n, t);
                            }
                            writeJNLP.write(this.constructJarHref(n, dashcnb, name));
                        }
                        writeJNLP.write("  </resources>\n");
                    }
                }
                writeJNLP.write("  <component-desc/>\n");
                writeJNLP.write("</jnlp>\n");
                writeJNLP.close();
                FileWriter w = new FileWriter(jnlp);
                w.write(writeJNLP.toString());
                w.close();
                if (jar.exists() && MakeJNLP.isSigned(jar) == null) {
                    try {
                        tmpFile = this.extendLibraryManifest(this.getProject(), jar, signed, "*", "all-permissions", this.appName, jnlp);
                    }
                    catch (IOException | ManifestException throwable2) {
                        this.getProject().log("Failed to extend libraries manifests: " + throwable2.getMessage(), 1);
                    }
                } else {
                    this.getProject().log(String.format("Not adding security attributes into library: %s the library is already signed.", MakeJNLP.safeRelativePath(this.getProject().getBaseDir(), signed)), 1);
                }
                if (tmpFile != null) {
                    this.signOrCopy(tmpFile, signed);
                    MakeJNLP.deleteTmpFile(tmpFile);
                    continue;
                }
                this.signOrCopy(jar, signed);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (theJar == null) continue;
                if (throwable != null) {
                    try {
                        theJar.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                theJar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extendLibraryManifest(Project prj, File sourceJar, File signedJar, String codebase, String permissions, String appName, File jnlp) throws IOException, ManifestException {
        File tmpFile;
        block28: {
            org.apache.tools.ant.taskdefs.Manifest manifest = null;
            Copy cp = new Copy();
            tmpFile = new File(String.format("%s.tmp", signedJar.getAbsolutePath()));
            cp.setFile(sourceJar);
            cp.setTofile(tmpFile);
            cp.execute();
            boolean success = false;
            try {
                HashMap<String, String> extendedAttrs = new HashMap<String, String>();
                try (ZipFile zf = new ZipFile(sourceJar);){
                    Manifest.Section mainSection;
                    String attr;
                    ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                    if (manifestEntry != null) {
                        try (InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName(UTF_8));){
                            manifest = new org.apache.tools.ant.taskdefs.Manifest((Reader)in);
                        }
                    } else {
                        manifest = new org.apache.tools.ant.taskdefs.Manifest();
                    }
                    if ((attr = (mainSection = manifest.getMainSection()).getAttributeValue(ATTR_CODEBASE)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CODEBASE, codebase));
                        extendedAttrs.put(ATTR_CODEBASE, codebase);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_PERMISSIONS)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_PERMISSIONS, permissions));
                        extendedAttrs.put(ATTR_PERMISSIONS, permissions);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_APPLICATION_NAME)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_APPLICATION_NAME, appName));
                        extendedAttrs.put(ATTR_APPLICATION_NAME, appName);
                    }
                    if (extendedAttrs.isEmpty()) break block28;
                    Enumeration zent = zf.getEntries();
                    try (ZipOutputStream out = new ZipOutputStream(tmpFile);){
                        if (jnlp != null) {
                            ZipEntry jnlpEntry = new ZipEntry("JNLP-INF/" + jnlp.getName());
                            out.putNextEntry(jnlpEntry);
                            try (FileInputStream fis = new FileInputStream(jnlp.getAbsolutePath());){
                                MakeJNLP.copy(fis, (OutputStream)out);
                            }
                        }
                        while (zent.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)zent.nextElement();
                            try (InputStream in = zf.getInputStream(entry);){
                                out.putNextEntry(entry);
                                if (MANIFEST.equals(entry.getName())) {
                                    PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(UTF_8)));
                                    manifest.write(manifestOut);
                                    manifestOut.flush();
                                    continue;
                                }
                                MakeJNLP.copy(in, (OutputStream)out);
                            }
                        }
                    }
                    success = true;
                    StringBuilder message = new StringBuilder("Updating library ").append(MakeJNLP.safeRelativePath(prj.getBaseDir(), tmpFile)).append(" manifest");
                    for (Map.Entry e : extendedAttrs.entrySet()) {
                        message.append(String.format(" %s: %s,", e.getKey(), e.getValue()));
                    }
                    message.deleteCharAt(message.length() - 1);
                    prj.log(message.toString(), 3);
                }
            }
            finally {
                if (!success) {
                    Delete rm = new Delete();
                    rm.setFile(tmpFile);
                    rm.setQuiet(true);
                    rm.execute();
                    tmpFile = null;
                }
            }
        }
        return tmpFile;
    }

    private static void deleteTmpFile(File tmpFile) {
        Delete del = new Delete();
        del.setFile(tmpFile);
        del.execute();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }

    private static String safeRelativePath(File from, File to) {
        try {
            return FileUtils.getRelativePath((File)from, (File)to);
        }
        catch (Exception ex) {
            return to.getAbsolutePath();
        }
    }

    private Map<String, List<File>> verifyExtensions(File f, Manifest mf, String dashcnb, String codebasename, boolean verify, Set<String> indirectFilePaths) throws IOException, BuildException {
        StringTokenizer tok;
        File updateTracking;
        HashMap<String, List<File>> localizedFiles = new HashMap<String, List<File>>();
        File clusterRoot = f.getParentFile();
        String moduleDirPrefix = "";
        this.log("Verifying extensions for: " + codebasename + ", cluster root: " + clusterRoot + ", verify: " + verify, 4);
        while (!(updateTracking = new File(clusterRoot, "update_tracking")).isDirectory()) {
            moduleDirPrefix = clusterRoot.getName() + "/" + moduleDirPrefix;
            if ((clusterRoot = clusterRoot.getParentFile()) != null && clusterRoot.exists()) continue;
            if (!verify) {
                return localizedFiles;
            }
            throw new BuildException("Cannot find update_tracking directory for module " + f);
        }
        File ut = new File(updateTracking, dashcnb + ".xml");
        if (!ut.exists()) {
            throw new BuildException("The file " + ut + " for module " + codebasename + " cannot be found");
        }
        HashMap<String, String> fileToOwningModule = new HashMap<String, String>();
        try {
            ModuleSelector.readUpdateTracking(this.getProject(), ut.toString(), fileToOwningModule);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        this.log("project files: " + fileToOwningModule, 4);
        String name = this.relative(f, clusterRoot);
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/Modules/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/ModuleAutoDeps/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "update_tracking/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        String path = mf.getMainAttributes().getValue("Class-Path");
        if (path != null) {
            tok = new StringTokenizer(path, ", ");
            while (tok.hasMoreElements()) {
                String s = tok.nextToken();
                File e = new File(f.getParentFile(), s);
                String r = this.relative(e, clusterRoot);
                MakeJNLP.removeWithLocales(fileToOwningModule, r, clusterRoot, localizedFiles);
            }
        }
        fileToOwningModule.remove("ant/nblib/" + dashcnb + ".jar");
        fileToOwningModule.remove("VERSION.txt");
        this.log("  removing: " + indirectFilePaths, 4);
        fileToOwningModule.keySet().removeAll(indirectFilePaths);
        if (this.verifyExcludes != null) {
            tok = new StringTokenizer(this.verifyExcludes, ", ");
            while (tok.hasMoreElements()) {
                MakeJNLP.removeWithLocales(fileToOwningModule, tok.nextToken(), clusterRoot, localizedFiles);
            }
        }
        if (verify && !fileToOwningModule.isEmpty()) {
            throw new BuildException("Cannot build JNLP for module " + f + " as these files are in module's NBM, but are not referenced from any path (see harness/README for properties you can define to fix):\n" + fileToOwningModule.keySet());
        }
        return localizedFiles;
    }

    private static void removeWithLocales(Map<String, String> removeFrom, String removeWhat, File clusterRoot, Map<String, List<File>> recordLocales) {
        if (removeFrom.remove(removeWhat) != null && removeWhat.endsWith(".jar")) {
            int basedir = removeWhat.lastIndexOf(47);
            String base = basedir == -1 ? "" : removeWhat.substring(0, basedir);
            String name = removeWhat.substring(basedir + 1, removeWhat.length() - 4);
            Pattern p = Pattern.compile(base + "/locale/" + name + "(|_[a-zA-Z0-9_]+)\\.jar");
            Iterator<String> it = removeFrom.keySet().iterator();
            while (it.hasNext()) {
                String s = it.next();
                Matcher m = p.matcher(s);
                if (!m.matches()) continue;
                String locale = m.group(1).substring(1);
                List<File> l = recordLocales.get(locale);
                if (l == null) {
                    l = new ArrayList<File>();
                    recordLocales.put(locale, l);
                }
                l.add(new File(clusterRoot, s.replace('/', File.separatorChar)));
                it.remove();
            }
        }
    }

    private void processExtensions(File f, Manifest mf, Writer fileWriter, String dashcnb, String codebase) throws IOException, BuildException {
        String path;
        File nblibJar = new File(new File(new File(f.getParentFile().getParentFile(), "ant"), "nblib"), dashcnb + ".jar");
        if (nblibJar.isFile()) {
            File ext = new File(new File(this.targetFile, dashcnb), "ant-nblib-" + nblibJar.getName());
            fileWriter.write(this.constructJarHref(ext, dashcnb));
            this.signOrCopy(nblibJar, ext);
        }
        if ((path = mf.getMainAttributes().getValue("Class-Path")) == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(path, ", ");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            if (s.contains("${java.home}")) continue;
            File e = new File(f.getParentFile(), s);
            if (!e.canRead()) {
                throw new BuildException("Cannot read extension " + e + " referenced from " + f);
            }
            String n = e.getName();
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
            File ext = new File(new File(this.targetFile, dashcnb), s.replace("../", "").replace('/', '-'));
            if (e.exists() && MakeJNLP.isSigned(e) != null) {
                this.getProject().log(String.format("Not adding security attributes into library: %s the library is already signed.", MakeJNLP.safeRelativePath(this.getProject().getBaseDir(), ext)), 1);
                Copy copy = (Copy)this.getProject().createTask("copy");
                copy.setFile(e);
                copy.setTofile(ext);
                copy.execute();
                String extJnlpName = dashcnb + '-' + ext.getName().replaceFirst("\\.jar$", "") + ".jnlp";
                File jnlp = new File(this.targetFile, extJnlpName);
                try (FileWriter writeJNLP = new FileWriter(jnlp);){
                    writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                    writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Descriptor 6.0//EN\" \"http://java.sun.com/dtd/JNLP-6.0.dtd\">\n");
                    writeJNLP.write("<jnlp spec='1.0+' codebase='" + codebase + "'>\n");
                    writeJNLP.write("  <information>\n");
                    writeJNLP.write("    <title>" + n + "</title>\n");
                    writeJNLP.write("    <vendor>NetBeans</vendor>\n");
                    writeJNLP.write("  </information>\n");
                    writeJNLP.write(this.permissions + "\n");
                    writeJNLP.write("  <resources>\n");
                    writeJNLP.write(this.constructJarHref(ext, dashcnb));
                    writeJNLP.write("  </resources>\n");
                    writeJNLP.write("  <component-desc/>\n");
                    writeJNLP.write("</jnlp>\n");
                }
                fileWriter.write("    <extension name='" + e.getName().replaceFirst("\\.jar$", "") + "' href='" + extJnlpName + "'/>\n");
                continue;
            }
            File tmpFile = null;
            try {
                tmpFile = this.extendLibraryManifest(this.getProject(), e, ext, "*", "all-permissions", this.appName, null);
            }
            catch (IOException | ManifestException ex) {
                this.getProject().log("Failed to extend libraries manifests: " + ex.getMessage(), 1);
            }
            if (tmpFile != null) {
                this.signOrCopy(tmpFile, ext);
                MakeJNLP.deleteTmpFile(tmpFile);
            } else {
                this.signOrCopy(e, ext);
            }
            fileWriter.write(this.constructJarHref(ext, dashcnb));
        }
    }

    private void processIndirectJars(Writer fileWriter, String dashcnb) throws IOException, BuildException {
        if (this.indirectJars == null) {
            return;
        }
        DirectoryScanner scan = this.indirectJars.getDirectoryScanner(this.getProject());
        for (String f : scan.getIncludedFiles()) {
            String sig;
            File jar = new File(scan.getBasedir(), f);
            String rel = f.replace(File.separatorChar, '/');
            try {
                sig = MakeJNLP.isSigned(jar);
            }
            catch (IOException x) {
                throw new BuildException("Cannot check signature on " + jar, (Throwable)x, this.getLocation());
            }
            String rel2 = rel.endsWith(".jar") ? rel : rel.replaceFirst("(\\.zip)?$", ".jar");
            File ext = new File(new File(this.targetFile, dashcnb), rel2.replace('/', '-').replaceFirst("^modules-", ""));
            Zip jartask = (Zip)this.getProject().createTask("jar");
            jartask.setDestFile(ext);
            ZipFileSet zfs = new ZipFileSet();
            zfs.setSrc(jar);
            if (sig != null) {
                zfs.setExcludes("META-INF/" + sig + ".*");
            }
            jartask.addZipfileset(zfs);
            zfs = new ZipFileSet();
            File blank = File.createTempFile("empty", "");
            blank.deleteOnExit();
            zfs.setFile(blank);
            zfs.setFullpath("META-INF/clusterpath/" + rel);
            jartask.addZipfileset(zfs);
            jartask.execute();
            blank.delete();
            fileWriter.write(this.constructJarHref(ext, dashcnb));
            this.signOrCopy(ext, null);
        }
    }

    private void processIndirectFiles(Writer fileWriter, String dashcnb) throws IOException, BuildException {
        if (this.indirectFiles == null) {
            return;
        }
        DirectoryScanner scan = this.indirectFiles.getDirectoryScanner(this.getProject());
        LinkedHashMap<String, File> entries = new LinkedHashMap<String, File>();
        for (String f : scan.getIncludedFiles()) {
            entries.put(f.replace(File.separatorChar, '/'), new File(scan.getBasedir(), f));
        }
        if (entries.isEmpty()) {
            return;
        }
        File ext = new File(new File(this.targetFile, dashcnb), "extra-files.jar");
        Zip jartask = (Zip)this.getProject().createTask("jar");
        jartask.setDestFile(ext);
        for (Map.Entry entry : entries.entrySet()) {
            ZipFileSet zfs = new ZipFileSet();
            zfs.setFile((File)entry.getValue());
            zfs.setFullpath("META-INF/files/" + (String)entry.getKey());
            jartask.addZipfileset(zfs);
        }
        jartask.execute();
        fileWriter.write(this.constructJarHref(ext, dashcnb));
        this.signOrCopy(ext, null);
    }

    private String relative(File file, File root) {
        String sroot;
        String sfile = file.toString().replace(File.separatorChar, '/');
        if (sfile.startsWith(sroot = (root.toString() + File.separator).replace(File.separatorChar, '/'))) {
            try {
                String result = new URI(null, sfile.substring(sroot.length()), null).normalize().getPath();
                return result;
            }
            catch (URISyntaxException x) {
                throw new BuildException((Throwable)x, this.getLocation());
            }
        }
        return sfile;
    }

    private static String isSigned(File f) throws IOException {
        try (JarFile jar = new JarFile(f);){
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                Matcher m = SF.matcher(en.nextElement().getName());
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private String getJarVersion(JarFile jar) throws IOException {
        String version = jar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
        if (version == null) {
            version = jar.getManifest().getMainAttributes().getValue("Specification-Version");
        }
        if (version == null && this.jarVersions != null) {
            version = this.jarVersions.get(jar.getName());
        }
        return version;
    }

    private String constructJarHref(File f, String dashcnb) throws IOException {
        return this.constructJarHref(f, dashcnb, f.getName());
    }

    private String constructJarHref(File f, String dashcnb, String name) throws IOException {
        String tag = "jar";
        if (this.nativeLibraries != null && this.nativeLibraries.contains(name)) {
            tag = "nativelib";
        }
        if (this.processJarVersions) {
            if (!f.exists()) {
                throw new BuildException("JAR file " + f + " does not exist, cannot extract required versioning info.");
            }
            JarFile extJar = new JarFile(f);
            String version = this.getJarVersion(extJar);
            if (version != null) {
                return "    <" + tag + " href='" + dashcnb + '/' + name + "' version='" + version + "' size='" + f.length() + "'/>\n";
            }
        }
        return "    <" + tag + " href='" + dashcnb + '/' + name + "'/>\n";
    }

    private void generateVersionXMLFiles() throws IOException {
        FileSet fs = new FileSet();
        fs.setIncludes("**/*.jar");
        for (File directory : this.jarDirectories) {
            fs.setDir(directory);
            DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
            StringWriter writeVersionXML = new StringWriter();
            writeVersionXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writeVersionXML.append("<jnlp-versions>\n");
            for (String jarName : scan.getIncludedFiles()) {
                File jar = new File(scan.getBasedir(), jarName);
                JarFile jarFile = new JarFile(jar);
                String version = this.getJarVersion(jarFile);
                if (version != null) {
                    writeVersionXML.append("    <resource>\n        <pattern>\n            <name>");
                    writeVersionXML.append(jar.getName());
                    writeVersionXML.append("</name>\n            <version-id>");
                    writeVersionXML.append(version);
                    writeVersionXML.append("</version-id>\n        </pattern>\n        <file>");
                    writeVersionXML.append(jar.getName());
                    writeVersionXML.append("</file>\n    </resource>\n");
                    continue;
                }
                writeVersionXML.append("    <!-- No version found for ");
                writeVersionXML.append(jar.getName());
                writeVersionXML.append(" -->\n");
            }
            writeVersionXML.append("</jnlp-versions>\n");
            writeVersionXML.close();
            File versionXML = new File(directory, "version.xml");
            FileWriter w = new FileWriter(versionXML);
            w.write(writeVersionXML.toString());
            w.close();
        }
    }
}

