/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.api;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.testng.api.TestNGTest;
import org.netbeans.modules.testng.api.TestNGTestSuite;
import org.netbeans.modules.testng.api.TestNGTestcase;
import org.netbeans.modules.testng.api.XmlResult;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlOutputParser
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(XmlOutputParser.class.getName());
    private int allTestsCount;
    private int failedTestsCount;
    private int passedTestsCount;
    private int skippedTestsCount;
    private int failedConfCount;
    private int skippedConfCount;
    private String status;
    private int suiteTime;
    private static final int STATE_OUT_OF_SCOPE = 0;
    private static final int STATE_SUITE = 3;
    private static final int STATE_GROUPS = 4;
    private static final int STATE_GROUP = 5;
    private static final int STATE_METHOD = 6;
    private static final int STATE_TEST = 7;
    private static final int STATE_CLASS = 8;
    private static final int STATE_TEST_METHOD = 9;
    private static final int STATE_TEST_PARAMS = 10;
    private static final int STATE_TEST_PARAM = 11;
    private static final int STATE_TEST_VALUE = 12;
    private static final int STATE_EXCEPTION = 13;
    private static final int STATE_MESSAGE = 14;
    private static final int STATE_FULL_STACKTRACE = 15;
    private int state = 0;
    private XmlResult reports;
    private TestNGTest test;
    private TestNGTestSuite testsuite;
    private TestNGTestcase testcase;
    private Trouble trouble;
    private String tcClassName;
    private StringBuffer text;
    private final XMLReader xmlReader;
    private TestSession testSession;

    private XmlOutputParser(TestSession session) throws SAXException {
        this.testSession = session;
        this.xmlReader = XMLUtil.createXMLReader();
        this.xmlReader.setContentHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlResult parseXmlOutput(Reader reader, TestSession session) throws SAXException, IOException {
        assert (reader != null);
        XmlOutputParser parser = new XmlOutputParser(session);
        try {
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            LOG.info("Exception while parsing XML output from TestNG: " + ex.getMessage());
            throw ex;
        }
        catch (IOException ex) {
            assert (false);
        }
        finally {
            reader.close();
        }
        return parser.reports;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 3: {
                if ("groups".equals(qName)) {
                    this.state = 4;
                    break;
                }
                if (!"test".equals(qName)) break;
                String name = attributes.getValue("name");
                this.test = name != null ? new TestNGTest(name) : new TestNGTest("");
                this.state = 7;
                break;
            }
            case 4: {
                if (!"group".equals(qName)) break;
                this.state = 5;
                break;
            }
            case 5: {
                if (!"method".equals(qName)) break;
                this.state = 6;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (!"class".equals(qName)) break;
                this.tcClassName = attributes.getValue("name");
                this.testsuite = new TestNGTestSuite(this.tcClassName, this.testSession);
                this.state = 8;
                break;
            }
            case 8: {
                if (!"test-method".equals(qName)) break;
                int duration = Integer.valueOf(attributes.getValue("duration-ms"));
                this.testcase = this.createTestcaseReport(this.tcClassName, attributes.getValue("name"), duration);
                this.suiteTime += duration;
                this.testcase.setConfigMethod(Boolean.valueOf(attributes.getValue("is-config")));
                this.status = attributes.getValue("status");
                if (!this.testcase.isConfigMethod()) {
                    ++this.allTestsCount;
                }
                if ("FAIL".equals(this.status)) {
                    this.testcase.setStatus(Status.FAILED);
                    if (this.testcase.isConfigMethod()) {
                        ++this.failedConfCount;
                    } else {
                        ++this.failedTestsCount;
                    }
                    this.trouble = new Trouble(true);
                } else if ("PASS".equals(this.status)) {
                    this.testcase.setStatus(Status.PASSED);
                    ++this.passedTestsCount;
                } else if ("SKIP".equals(this.status)) {
                    this.testcase.setStatus(Status.SKIPPED);
                    this.trouble = new Trouble(false);
                    if (this.testcase.isConfigMethod()) {
                        ++this.skippedConfCount;
                    } else {
                        ++this.skippedTestsCount;
                    }
                }
                this.state = 9;
                break;
            }
            case 9: {
                if ("params".equals(qName)) {
                    this.state = 10;
                    break;
                }
                if (!"exception".equals(qName)) break;
                assert (this.testcase != null && this.status != null);
                if (!"PASS".equals(this.status)) {
                    // empty if block
                }
                this.state = this.trouble != null ? 13 : 9;
                break;
            }
            case 13: {
                if ("message".equals(qName)) {
                    this.state = 14;
                    break;
                }
                if (!"full-stacktrace".equals(qName)) break;
                this.state = 15;
                break;
            }
            default: {
                if (!qName.equals("suite")) break;
                String name = attributes.getValue("name");
                if (name == null || "".equals(name.trim())) {
                    name = NbBundle.getMessage(XmlOutputParser.class, (String)"UNKNOWN_NAME");
                }
                this.reports = new XmlResult(name);
                this.state = 3;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 4: {
                assert ("groups".equals(qName));
                this.state = 3;
                break;
            }
            case 5: {
                assert ("group".equals(qName));
                this.state = 4;
                break;
            }
            case 6: {
                assert ("method".equals(qName)) : "was " + qName;
                this.state = 5;
                break;
            }
            case 3: {
                assert ("suite".equals(qName)) : "was " + qName;
                this.state = 0;
                break;
            }
            case 7: {
                assert ("test".equals(qName));
                this.reports.addTestNGTest(this.test);
                this.test = null;
                this.state = 3;
                break;
            }
            case 8: {
                assert ("class".equals(qName));
                this.testsuite.setElapsedTime(this.suiteTime);
                this.test.addTestsuite(this.testsuite);
                this.testsuite = null;
                this.suiteTime = 0;
                this.skippedTestsCount = 0;
                this.failedTestsCount = 0;
                this.allTestsCount = 0;
                this.passedTestsCount = 0;
                this.skippedConfCount = 0;
                this.failedConfCount = 0;
                this.tcClassName = null;
                this.testcase = null;
                this.state = 7;
                break;
            }
            case 9: {
                if (!"test-method".equals(qName)) break;
                assert ("test-method".equals(qName)) : "was " + qName;
                assert (this.testcase != null);
                this.testcase.setTrouble(this.trouble);
                this.testsuite.getTestcases().add(this.testcase);
                this.trouble = null;
                this.testcase = null;
                this.state = 8;
                break;
            }
            case 10: {
                if ("param".equals(qName) || "value".equals(qName)) break;
                assert ("params".equals(qName)) : "was " + qName;
                this.state = 9;
                break;
            }
            case 13: {
                assert ("exception".equals(qName));
                this.state = 9;
                break;
            }
            case 14: {
                assert ("message".equals(qName));
                assert (this.testcase != null);
                assert (this.trouble != null);
                if (this.text != null) {
                    int index;
                    String s = this.text.toString().trim();
                    if (s.startsWith("expected:") && (index = s.indexOf("<")) > -1) {
                        int ie = s.indexOf(">", index + 1);
                        String expected = s.substring(index + 1, ie);
                        String actual = s.substring(s.indexOf("<", ie + 1) + 1, s.indexOf(">", ie + 1));
                        this.trouble.setComparisonFailure(new Trouble.ComparisonFailure(expected, actual));
                    }
                    this.text = null;
                }
                this.state = 13;
                break;
            }
            case 15: {
                assert ("full-stacktrace".equals(qName));
                if (this.text != null) {
                    String[] lines = this.text.toString().trim().split("[\\r\\n]+");
                    this.trouble.setStackTrace(lines);
                    this.text = null;
                }
                this.state = 13;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case 14: 
            case 15: {
                if (this.text == null) {
                    this.text = new StringBuffer(512);
                }
                this.text.append(ch, start, length);
            }
        }
    }

    private TestNGTestcase createTestcaseReport(String className, String name, int time) {
        TestNGTestcase tc = new TestNGTestcase(className + "." + name, "params", null, this.testSession);
        tc.setTimeMillis(time);
        return tc;
    }
}

