/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;

public class MemberSearchResult {
    private final ElementHandle<? extends Element> conflicting;
    private final ElementHandle<? extends Element> shadowed;
    private final ElementHandle<? extends TypeElement> shadowedGate;
    private final boolean gateSuper;
    private final Modifier requiredModifier;
    private final TreePathHandle conflictingPath;
    private final ElementKind kind;

    public MemberSearchResult(ElementHandle<? extends Element> conflicting) {
        this.conflicting = conflicting;
        this.shadowed = null;
        this.shadowedGate = null;
        this.gateSuper = false;
        this.requiredModifier = null;
        this.conflictingPath = null;
        this.kind = conflicting.getKind();
    }

    public MemberSearchResult(ElementKind kind) {
        this.conflicting = null;
        this.shadowed = null;
        this.shadowedGate = null;
        this.gateSuper = false;
        this.requiredModifier = null;
        this.conflictingPath = null;
        this.kind = kind;
    }

    public MemberSearchResult(TreePathHandle conflicting, ElementKind kind) {
        this.conflicting = null;
        this.shadowed = null;
        this.shadowedGate = null;
        this.gateSuper = false;
        this.requiredModifier = null;
        this.conflictingPath = conflicting;
        this.kind = kind;
    }

    public MemberSearchResult(ElementHandle<? extends Element> shadowed, ElementHandle<? extends TypeElement> shadowedGate) {
        this.shadowed = shadowed;
        this.shadowedGate = shadowedGate;
        this.gateSuper = false;
        this.conflicting = null;
        this.requiredModifier = null;
        this.conflictingPath = null;
        this.kind = null;
    }

    public MemberSearchResult(ElementHandle<? extends Element> shadowed, ElementHandle<? extends TypeElement> shadowedGate, Modifier requiredModifier) {
        this.shadowed = shadowed;
        this.shadowedGate = shadowedGate;
        this.requiredModifier = requiredModifier;
        this.gateSuper = true;
        this.conflicting = null;
        this.conflictingPath = null;
        this.kind = null;
    }

    public ElementHandle<? extends Element> getOverriden() {
        return this.requiredModifier != null ? this.shadowed : null;
    }

    public ElementHandle<? extends Element> getConflicting() {
        return this.conflicting;
    }

    public TreePathHandle getConflictingPath() {
        return this.conflictingPath;
    }

    public ElementKind getConflictingKind() {
        return this.kind;
    }

    public Element resolveConflict(CompilationInfo info) {
        if (this.conflicting != null) {
            return this.conflicting.resolve(info);
        }
        if (this.conflictingPath != null) {
            return this.conflictingPath.resolveElement(info);
        }
        return null;
    }

    public boolean isConflicting() {
        return this.conflicting != null || this.conflictingPath != null;
    }

    public ElementHandle<? extends Element> getShadowed() {
        return this.requiredModifier == null ? this.shadowed : null;
    }

    public ElementHandle<? extends TypeElement> getShadowedGate() {
        return this.shadowedGate;
    }

    public boolean isGateSuper() {
        return this.gateSuper;
    }

    public Modifier getRequiredModifier() {
        return this.requiredModifier;
    }
}

