/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.HideField;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class HideFieldByVar
extends HideField {
    public HideFieldByVar() {
        super("LocalVariableHidesMemberVariable");
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_HiddenFieldByVar");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_HiddenFieldByVar");
    }

    @Override
    protected List<Fix> computeFixes(CompilationInfo compilationInfo, TreePath treePath, int[] bounds) {
        if (treePath.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return null;
        }
        VariableTree vt = (VariableTree)treePath.getLeaf();
        Element el = compilationInfo.getTrees().getElement(treePath);
        if (el == null) {
            return null;
        }
        if (el.getKind() == ElementKind.FIELD) {
            return null;
        }
        boolean isStatic = false;
        while (el != null && !(el instanceof TypeElement)) {
            isStatic = el.getModifiers().contains((Object)Modifier.STATIC);
            el = el.getEnclosingElement();
        }
        if (el == null) {
            return null;
        }
        if (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD) {
            return null;
        }
        Element hidden = null;
        for (Element element : HideFieldByVar.getAllMembers(compilationInfo, (TypeElement)el)) {
            if (this.stop) {
                return null;
            }
            if (element.getKind() != ElementKind.FIELD || isStatic && !element.getModifiers().contains((Object)Modifier.STATIC) || element.getSimpleName() != vt.getName()) continue;
            hidden = element;
            break;
        }
        if (hidden == null) {
            return null;
        }
        int[] span = compilationInfo.getTreeUtilities().findNameSpan(vt);
        if (span == null) {
            return null;
        }
        List<Fix> list = Collections.singletonList(new HideField.FixImpl((span[1] + span[0]) / 2, compilationInfo.getFileObject(), true));
        bounds[0] = span[0];
        bounds[1] = span[1];
        return list;
    }
}

