/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class MetadataModelReadHelper<T, R> {
    private final RequestProcessor eventRP = new RequestProcessor("MetadataModelReadHelper", 1);
    private final RequestProcessor executorRP = new RequestProcessor("MetadataModelReadHelperExecutor", 3);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final MetadataModel<T> model;
    private final MetadataModelAction<T, R> action;
    private Reader reader;
    private volatile State state = State.IDLE;
    private volatile R result;
    private volatile ExecutionException executionException;

    public static <T, R> MetadataModelReadHelper<T, R> create(MetadataModel<T> model, MetadataModelAction<T, R> action) {
        Parameters.notNull((CharSequence)"model", model);
        Parameters.notNull((CharSequence)"action", action);
        return new MetadataModelReadHelper<T, R>(model, action);
    }

    private MetadataModelReadHelper(MetadataModel<T> model, MetadataModelAction<T, R> action) {
        this.model = model;
        this.action = action;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MetadataModelReadHelper metadataModelReadHelper = this;
        synchronized (metadataModelReadHelper) {
            if (this.reader != null) {
                throw new IllegalStateException("The action has already been started");
            }
            this.reader = new Reader();
        }
        this.state = State.WAITING_READY;
        this.changeSupport.fireChange();
        this.executorRP.post(new Runnable(){

            @Override
            public void run() {
                MetadataModelReadHelper.this.reader.run();
            }
        });
    }

    public State getState() {
        return this.state;
    }

    public R getResult() throws ExecutionException {
        if (this.state != State.FINISHED) {
            throw new IllegalStateException("The action has not finished yet");
        }
        if (this.executionException != null) {
            throw this.executionException;
        }
        return this.result;
    }

    private void fireChange() {
        this.eventRP.post(new Runnable(){

            @Override
            public void run() {
                MetadataModelReadHelper.this.changeSupport.fireChange();
            }
        });
    }

    private final class Reader {
        private Reader() {
        }

        public void run() {
            try {
                Future future = MetadataModelReadHelper.this.model.runReadActionWhenReady(new MetadataModelAction<T, Void>(){

                    public Void run(T metadata) throws Exception {
                        MetadataModelReadHelper.this.state = State.READING_MODEL;
                        MetadataModelReadHelper.this.fireChange();
                        MetadataModelReadHelper.this.result = MetadataModelReadHelper.this.action.run(metadata);
                        MetadataModelReadHelper.this.state = State.FINISHED;
                        MetadataModelReadHelper.this.fireChange();
                        return null;
                    }
                });
                future.get();
            }
            catch (Exception e) {
                MetadataModelReadHelper.this.state = State.FINISHED;
                MetadataModelReadHelper.this.executionException = new ExecutionException(e.getMessage(), e);
                MetadataModelReadHelper.this.fireChange();
            }
        }
    }

    public static enum State {
        IDLE,
        WAITING_READY,
        READING_MODEL,
        FINISHED;

    }
}

