/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

public class IncorrectReturnStatement
extends JsAstRule {
    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        Snapshot snapshot = context.getJsParserResult().getSnapshot();
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)context.lexOffset);
        if (ts != null) {
            while (ts.moveNext()) {
                JsTokenId tokenId;
                Token token = LexUtilities.findNextIncluding((TokenSequence)ts, Arrays.asList(JsTokenId.KEYWORD_RETURN));
                if (token == null || (tokenId = (JsTokenId)token.id()) != JsTokenId.KEYWORD_RETURN) continue;
                OffsetRange returnOffsetRange = new OffsetRange(ts.offset(), ts.offset() + token.length());
                if (!ts.moveNext() || (tokenId = (JsTokenId)(token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.BLOCK_COMMENT))).id()) != JsTokenId.EOL) continue;
                this.addHint(context, hints, offset, "js.other.hints", returnOffsetRange);
            }
        }
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, String name, OffsetRange range) throws BadLocationException {
        hints.add(new Hint((Rule)this, Bundle.JsIncorrectReturnStatementHintDesc(), context.getJsParserResult().getSnapshot().getSource().getFileObject(), ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()), null, 600));
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "jsincorrectreturnstatement.hint";
    }

    public String getDescription() {
        return Bundle.JsIncorrectReturnStatementDesc();
    }

    public String getDisplayName() {
        return Bundle.JsIncorrectReturnStatementHintDesc();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }
}

