/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

public class ClassPresenterPanel
extends JPanel
implements HeapFragmentWalker.StateListener {
    private static Icon ICON_CLASS = Icons.getIcon((String)"LanguageIcons.Class");
    private HeaderRenderer headerRenderer;
    private JLabel detailsRenderer;
    private JLabel actionsDivider;
    private JButton actionsRenderer;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassPresenterPanel() {
        this.initComponents();
    }

    public void setJavaClass(JavaClass javaClass) {
        if (javaClass != null) {
            String classDetails;
            String className = javaClass.getName();
            String instancesCount = Bundle.ClassPresenterPanel_InstancesCountString(javaClass.getInstancesCount());
            String instanceSize = javaClass.getInstanceSize() != -1 ? "  |  " + Bundle.ClassPresenterPanel_InstanceSizeString(javaClass.getInstanceSize()) : "";
            String allInstancesSize = javaClass.getAllInstancesSize() != -1L ? "  |  " + Bundle.ClassPresenterPanel_TotalSizeString(javaClass.getAllInstancesSize()) : "";
            String string = classDetails = javaClass.isArray() ? instancesCount + allInstancesSize : instancesCount + instanceSize + allInstancesSize;
            if (this.heapFragmentWalker.getRetainedSizesStatus() == 3) {
                classDetails = classDetails + "  |  " + Bundle.ClassPresenterPanel_RetainedSizeString(javaClass.getRetainedSizeByClass());
            }
            this.headerRenderer.setText(className);
            this.detailsRenderer.setText(classDetails);
            this.actionsRenderer.setPreferredSize(new Dimension(this.actionsRenderer.getPreferredSize().width, this.detailsRenderer.getPreferredSize().height));
        }
    }

    public void setHeapFragmentWalker(HeapFragmentWalker heapFragmentWalker) {
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.removeStateListener(this);
        }
        this.heapFragmentWalker = heapFragmentWalker;
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.addStateListener(this);
            this.updateActions(heapFragmentWalker.getRetainedSizesStatus());
        } else {
            this.updateActions(-1);
        }
    }

    public void refresh() {
    }

    @Override
    public void stateChanged(HeapFragmentWalker.StateEvent e) {
        this.updateActions(e.getRetainedSizesStatus());
    }

    public void updateActions(int retainedSizesStatus) {
        switch (retainedSizesStatus) {
            case -1: 
            case 3: {
                this.actionsRenderer.setVisible(false);
                this.refresh();
                break;
            }
            case 0: 
            case 1: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(true);
                break;
            }
            case 2: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        Color borderColor = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setOpaque(true);
        this.setBackground(UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground()));
        this.headerRenderer = new HeaderRenderer();
        this.headerRenderer.setIcon(ICON_CLASS);
        this.headerRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.headerRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.headerRenderer.setOpaque(false);
        this.detailsRenderer = new JLabel();
        this.detailsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.detailsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.detailsRenderer.setOpaque(false);
        this.actionsDivider = new JLabel("  |  ");
        this.actionsDivider.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.actionsDivider.setFont(UIManager.getFont("ToolTip.font"));
        this.actionsDivider.setOpaque(false);
        this.actionsRenderer = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (ClassPresenterPanel.this.heapFragmentWalker != null) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            ClassPresenterPanel.this.heapFragmentWalker.computeRetainedSizes(true, true);
                        }
                    });
                }
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                ClassPresenterPanel.this.actionsDivider.setVisible(visible);
            }

            @Override
            public boolean isContentAreaFilled() {
                return !UIUtils.isOracleLookAndFeel() ? false : this.isFocusOwner();
            }

            @Override
            public boolean isOpaque() {
                return !UIUtils.isOracleLookAndFeel() ? false : this.isFocusOwner();
            }
        };
        this.actionsRenderer.setOpaque(false);
        this.actionsRenderer.setContentAreaFilled(false);
        this.actionsRenderer.setBorderPainted(true);
        this.actionsRenderer.setMargin(new Insets(0, 0, 0, 0));
        this.actionsRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.actionsRenderer.setCursor(Cursor.getPredefinedCursor(12));
        this.actionsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.actionsRenderer.setText("<html><nobr><a href='#'>" + Bundle.ClassPresenterPanel_RetainedSizesString() + "</a></nobr></html>");
        this.actionsRenderer.setVisible(false);
        JPanel detailsContainer = new JPanel(new FlowLayout(3, 0, 0));
        detailsContainer.setOpaque(false);
        detailsContainer.add(this.detailsRenderer);
        detailsContainer.add(this.actionsDivider);
        detailsContainer.add(this.actionsRenderer);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        this.add((Component)this.headerRenderer, c);
        JPanel filler = new JPanel(null);
        filler.setOpaque(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)filler, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        this.add((Component)detailsContainer, c);
    }

    private static class HeaderRenderer
    extends JPanel {
        private JLabel classIcon;
        private JLabel packageName;
        private JLabel className;

        HeaderRenderer() {
            this.setLayout(new BorderLayout());
            this.classIcon = new JLabel();
            this.classIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, this.classIcon.getIconTextGap()));
            this.packageName = new JLabel();
            this.packageName.setFont(this.packageName.getFont().deriveFont(0));
            this.packageName.setBorder(BorderFactory.createEmptyBorder());
            this.className = new JLabel();
            this.className.setFont(this.packageName.getFont().deriveFont(1));
            this.className.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this.classIcon, "West");
            this.add((Component)this.packageName, "Center");
            this.add((Component)this.className, "East");
        }

        public void setIcon(Icon icon) {
            this.classIcon.setIcon(icon);
        }

        public void setText(String text) {
            int classNameIndex = text.lastIndexOf(46);
            if (classNameIndex == -1) {
                this.packageName.setText("");
                this.className.setText(text);
            } else {
                this.packageName.setText(text.substring(0, ++classNameIndex));
                this.className.setText(text.substring(classNameIndex));
            }
        }
    }
}

