/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.openide.util.NbBundle;

public class BookmarksTableModel
extends AbstractTableModel {
    static final int NAME_COLUMN = 0;
    static final int KEY_COLUMN = 1;
    static final int LOCATION_COLUMN = 2;
    static final int COLUMN_COUNT = 3;
    private static final boolean[] COLUMN_EDITABLE = new boolean[]{true, true, false};
    private final boolean forHistoryPopup;
    private final List<BookmarkNode> entries;
    private int columnCount;
    private int columnEntryCount;

    public BookmarksTableModel(boolean forHistoryPopup) {
        this.forHistoryPopup = forHistoryPopup;
        this.entries = new ArrayList<BookmarkNode>();
        this.columnCount = forHistoryPopup ? 1 : 3;
        this.columnEntryCount = Integer.MAX_VALUE;
    }

    public void setEntries(List<BookmarkNode> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        this.fireTableDataChanged();
    }

    public BookmarkNode getEntry(int index) {
        return this.entries.get(index);
    }

    public BookmarkNode getEntry(int rowIndex, int columnIndex) {
        return this.getEntry(this.entryIndex(rowIndex, this.forHistoryPopup ? columnIndex : 0));
    }

    public int entryIndex(int rowIndex, int columnIndex) {
        return columnIndex * this.columnEntryCount + rowIndex;
    }

    public void entryIndex2rowColumn(int entryIndex, int[] rowColumn) {
        rowColumn[1] = entryIndex / this.columnEntryCount;
        rowColumn[0] = entryIndex - rowColumn[1] * this.columnEntryCount;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    @Override
    public int getRowCount() {
        return Math.min(this.entries.size(), this.columnEntryCount);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnEntryCount() {
        return this.columnEntryCount;
    }

    int setColumnEntryCount(int columnEntryCount) {
        assert (columnEntryCount > 0) : "columnEntryCount=" + columnEntryCount + " <= 0";
        this.columnEntryCount = columnEntryCount;
        this.columnCount = Math.min(1, (this.entries.size() + columnEntryCount - 1) / columnEntryCount);
        this.fireTableDataChanged();
        return this.columnCount;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.forHistoryPopup ? false : COLUMN_EDITABLE[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BookmarkNode bNode = this.getEntry(rowIndex, columnIndex);
        BookmarkInfo bookmark = bNode.getBookmarkInfo();
        if (this.forHistoryPopup) {
            return bookmark.getDescription(false, true, true);
        }
        switch (columnIndex) {
            case 0: {
                return bookmark.getName();
            }
            case 1: {
                return bookmark.getKey();
            }
            case 2: {
                return bookmark.getDescription(false, false, false);
            }
        }
        throw new IllegalStateException("Invalid columnIndex=" + columnIndex);
    }

    public String getToolTipText(int rowIndex, int columnIndex) {
        BookmarkNode bNode = this.getEntry(rowIndex, columnIndex);
        BookmarkInfo bookmark = bNode.getBookmarkInfo();
        if (this.forHistoryPopup) {
            return bookmark.getFullPathDescription();
        }
        switch (columnIndex) {
            case 0: {
                String nameToolTip = bookmark.getName();
                if (nameToolTip == null || nameToolTip.length() == 0) {
                    nameToolTip = NbBundle.getMessage(BookmarksTableModel.class, (String)"LBL_BookmarkNameEmpty");
                }
                return nameToolTip;
            }
            case 1: {
                String keyToolTip = bookmark.getKey();
                if (keyToolTip == null || keyToolTip.length() == 0) {
                    keyToolTip = NbBundle.getMessage(BookmarksTableModel.class, (String)"LBL_BookmarkKeyEmpty");
                }
                return keyToolTip;
            }
            case 2: {
                return bookmark.getDescription(true, false, false);
            }
        }
        throw new IllegalStateException("Invalid columnIndex=" + columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        BookmarkNode bookmarkNode = this.getEntry(rowIndex, columnIndex);
        BookmarkInfo bookmark = bookmarkNode.getBookmarkInfo();
        switch (columnIndex) {
            case 0: {
                BookmarkUtils.setBookmarkNameUnderLock(bookmark, (String)value);
                break;
            }
            case 1: {
                BookmarkUtils.setBookmarkKeyUnderLock(bookmark, (String)value);
                break;
            }
            case 2: {
                throw new IllegalStateException("Should never get here");
            }
            default: {
                throw new IllegalStateException("Invalid columnIndex=" + columnIndex);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

