/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.grailsversion;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode(includes={"text"})
public class Snapshot
implements Comparable<Snapshot>,
GroovyObject {
    private static final String BUILD_SNAPSHOT = "BUILD-SNAPSHOT";
    private static final String RC = "RC";
    private static final String MILESTONE;
    private String text;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public Snapshot(String string) {
        void text;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = text;
        this.text = var3_3;
        if (!text.matches("^(M|RC|Final)\\d*$") && !this.isBuildSnapshot()) {
            throw (Throwable)new IllegalArgumentException("GrailsVersion snapshot is not in the expected format");
        }
    }

    public String toString() {
        return this.text;
    }

    public int getMilestoneVersion() {
        return StringGroovyMethods.toInteger((CharSequence)this.text.replace(MILESTONE, ""));
    }

    public int getReleaseCandidateVersion() {
        return StringGroovyMethods.toInteger((CharSequence)this.text.replace(RC, ""));
    }

    public boolean isBuildSnapshot() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.text, (Object)BUILD_SNAPSHOT);
    }

    public boolean isReleaseCandidate() {
        return this.text.startsWith(RC);
    }

    public boolean isMilestone() {
        return this.text.startsWith(MILESTONE);
    }

    @Override
    public int compareTo(Snapshot o) {
        if (this.isBuildSnapshot() && !o.isBuildSnapshot()) {
            return 1;
        }
        if (!this.isBuildSnapshot() && o.isBuildSnapshot()) {
            return -1;
        }
        if (this.isBuildSnapshot() && o.isBuildSnapshot()) {
            return 0;
        }
        if (this.isReleaseCandidate() && !o.isReleaseCandidate()) {
            return 1;
        }
        if (!this.isReleaseCandidate() && o.isReleaseCandidate()) {
            return -1;
        }
        if (this.isReleaseCandidate() && o.isReleaseCandidate()) {
            return ScriptBytecodeAdapter.compareTo((Object)this.getReleaseCandidateVersion(), (Object)o.getReleaseCandidateVersion());
        }
        if (this.isMilestone() && !o.isMilestone()) {
            return 1;
        }
        if (!this.isMilestone() && o.isMilestone()) {
            return -1;
        }
        if (this.isMilestone() && o.isMilestone()) {
            return ScriptBytecodeAdapter.compareTo((Object)this.getMilestoneVersion(), (Object)o.getMilestoneVersion());
        }
        return 0;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Snapshot.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof Snapshot;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Snapshot)) {
            return false;
        }
        Snapshot otherTyped = (Snapshot)other;
        return !(!otherTyped.canEqual(this));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        MILESTONE = string = "M";
    }
}

