/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionFactory;
import freemind.controller.filter.condition.NodeCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;

class NodeContainsCondition
extends NodeCondition {
    static final String VALUE = "value";
    static final String NAME = "node_contains_condition";
    private String value;

    NodeContainsCondition(String value) {
        this.value = value;
    }

    @Override
    public boolean checkNode(Controller c, MindMapNode node) {
        return node.getText().indexOf(this.value) > -1;
    }

    @Override
    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        super.saveAttributes(child);
        child.setAttribute(VALUE, this.value);
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new NodeContainsCondition(element.getStringAttribute(VALUE));
    }

    @Override
    protected String createDesctiption() {
        String nodeCondition = Resources.getInstance().getResourceString("filter_node");
        String simpleCondition = Resources.getInstance().getResourceString("filter_contains");
        return ConditionFactory.createDescription(nodeCondition, simpleCondition, this.value, false);
    }
}

