define(["datetime","itemHelper","css!./indicators.css","material-icons"],function(datetime,itemHelper){"use strict";function getProgressHtml(pct,options){var containerClass="itemProgressBar";return options&&options.containerClass&&(containerClass+=" "+options.containerClass),'<div class="'+containerClass+'"><div class="itemProgressBarForeground" style="width:'+pct+'%;"></div></div>'}function getAutoTimeProgressHtml(pct,options,isRecording,start,end){progressBarRequired||(progressBarRequired=!0,require(["emby-progressbar"]));var containerClass="itemProgressBar";options&&options.containerClass&&(containerClass+=" "+options.containerClass);var foregroundClass="itemProgressBarForeground";return isRecording&&(foregroundClass+=" itemProgressBarForeground-recording"),'<div is="emby-progressbar" data-automode="time" data-starttime="'+start+'" data-endtime="'+end+'" class="'+containerClass+'"><div class="'+foregroundClass+'" style="width:'+pct+'%;"></div></div>'}function getProgressBarHtml(item,options){var pct,itemType=item.Type;if("Recording"!==itemType){var userData=options?options.userData||item.UserData:item.UserData;if(userData&&(pct=userData.PlayedPercentage)&&pct<100)return getProgressHtml(pct,options)}if(("Program"===itemType||"Timer"===itemType||"Recording"===itemType)&&item.StartDate&&item.EndDate){var startDate=0,endDate=1;try{startDate=datetime.parseISO8601Date(item.StartDate).getTime()}catch(err){}try{endDate=datetime.parseISO8601Date(item.EndDate).getTime()}catch(err){}if((pct=((new Date).getTime()-startDate)/(endDate-startDate)*100)>0&&pct<100){return getAutoTimeProgressHtml(pct,options,"Timer"===itemType||"Recording"===itemType||item.TimerId,startDate,endDate)}}return""}function getPlayedIndicator(item){var userData=item.UserData;if(userData){if(userData.Played&&itemHelper.canMarkPlayed(item)&&(!item.IsFolder||"MusicAlbum"===item.Type))return'<div class="playedIndicator indicator"><i class="md-icon indicatorIcon">&#xE5CA;</i></div>';if(userData.UnplayedItemCount&&itemHelper.canMarkPlayed(item))return'<div class="countIndicator indicator">'+userData.UnplayedItemCount+"</div>"}return""}function getCountIndicatorHtml(count){return'<div class="countIndicator indicator">'+count+"</div>"}function getChildCountIndicatorHtml(item,options){var minCount=0;return options&&(minCount=options.minCount||minCount),item.ChildCount&&item.ChildCount>minCount?getCountIndicatorHtml(item.ChildCount):""}function getTimerIndicator(item){var status,itemType=item.Type;if("SeriesTimer"===itemType)return'<i class="md-icon timerIndicator indicatorIcon">&#xE062;</i>';if(item.TimerId||item.SeriesTimerId)status=item.Status||"Cancelled";else{if("Timer"!==itemType)return"";status=item.Status}return item.SeriesTimerId?"Cancelled"!==status?'<i class="md-icon timerIndicator indicatorIcon">&#xE062;</i>':'<i class="md-icon timerIndicator timerIndicator-inactive indicatorIcon">&#xE062;</i>':'<i class="md-icon timerIndicator indicatorIcon">&#xE061;</i>'}function getSyncIndicator(item){return 100===item.SyncPercent?'<div class="syncIndicator indicator fullSyncIndicator"><i class="md-icon indicatorIcon">&#xE2C4;</i></div>':null!=item.SyncPercent?'<div class="syncIndicator indicator emptySyncIndicator"><i class="md-icon indicatorIcon">&#xE2C4;</i></div>':""}function getTypeIndicator(item){var itemType=item.Type;return"Video"===itemType?'<div class="indicator videoIndicator"><i class="md-icon indicatorIcon">&#xE04B;</i></div>':"Folder"===itemType||"PhotoAlbum"===itemType?'<div class="indicator videoIndicator"><i class="md-icon indicatorIcon">&#xE2C7;</i></div>':"Photo"===itemType?'<div class="indicator videoIndicator"><i class="md-icon indicatorIcon">&#xE410;</i></div>':""}function getMissingIndicator(item){if("Episode"===item.Type&&"Virtual"===item.LocationType){if(item.PremiereDate)try{if(datetime.parseISO8601Date(item.PremiereDate).getTime()>(new Date).getTime())return'<div class="unairedIndicator">Unaired</div>'}catch(err){}return'<div class="missingIndicator">Missing</div>'}return""}var progressBarRequired;return{getProgressBarHtml:getProgressBarHtml,getPlayedIndicatorHtml:getPlayedIndicator,getChildCountIndicatorHtml:getChildCountIndicatorHtml,getTimerIndicator:getTimerIndicator,getSyncIndicator:getSyncIndicator,getTypeIndicator:getTypeIndicator,getMissingIndicator:getMissingIndicator}});