/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.corext.util.Resources;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class FormatAllAction
extends SelectionDispatchAction {
    private DocumentRewriteSession fRewriteSession;

    public FormatAllAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FormatAllAction_label);
        this.setToolTipText(ActionMessages.FormatAllAction_tooltip);
        this.setDescription(ActionMessages.FormatAllAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.format_all_action");
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ITranslationUnit[] getTranslationUnits(IStructuredSelection selection) {
        HashSet<ICElement> result = new HashSet<ICElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            try {
                IProject project;
                if (selected[i] instanceof ICElement) {
                    ICElement elem = (ICElement)selected[i];
                    if (elem.exists()) {
                        switch (elem.getElementType()) {
                            case 60: {
                                result.add(elem);
                                break;
                            }
                            case 12: {
                                this.collectTranslationUnits((ICContainer)elem, result);
                                break;
                            }
                            case 11: {
                                this.collectTranslationUnits((ICProject)elem, result);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (selected[i] instanceof IProject && CoreModel.hasCNature((IProject)(project = (IProject)selected[i]))) {
                    this.collectTranslationUnits(CoreModel.getDefault().create(project), result);
                }
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
            ++i;
        }
        return result.toArray(new ITranslationUnit[result.size()]);
    }

    private void collectTranslationUnits(ICProject project, Collection<ICElement> result) throws CModelException {
        ISourceRoot[] roots;
        ISourceRoot[] iSourceRootArray = roots = project.getSourceRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot root = iSourceRootArray[n2];
            this.collectTranslationUnits((ICContainer)root, result);
            ++n2;
        }
    }

    private void collectTranslationUnits(ICContainer container, Collection<ICElement> result) throws CModelException {
        ICElement[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            ICElement elem = children[i];
            if (elem.exists()) {
                switch (elem.getElementType()) {
                    case 60: {
                        result.add(elem);
                        break;
                    }
                    case 12: {
                        this.collectTranslationUnits((ICContainer)elem, result);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof ICElement) {
                ICElement elem = (ICElement)selected[i];
                if (elem.exists()) {
                    switch (elem.getElementType()) {
                        case 11: 
                        case 12: 
                        case 60: {
                            return true;
                        }
                    }
                }
            } else if (selected[i] instanceof IProject && CoreModel.hasCNature((IProject)((IProject)selected[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void run(ITextSelection selection) {
    }

    @Override
    public void run(IStructuredSelection selection) {
        int returnCode;
        ITranslationUnit[] tus = this.getTranslationUnits(selection);
        if (tus.length == 0) {
            return;
        }
        if (tus.length > 1 && (returnCode = OptionalMessageDialog.open("FormatAll", this.getShell(), ActionMessages.FormatAllAction_noundo_title, null, ActionMessages.FormatAllAction_noundo_message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && returnCode != 0) {
            return;
        }
        IStatus status = Resources.makeCommittable(this.getResources(tus), (Object)this.getShell());
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)ActionMessages.FormatAllAction_failedvalidateedit_title, (String)ActionMessages.FormatAllAction_failedvalidateedit_message, (IStatus)status);
            return;
        }
        this.runOnMultiple(tus);
    }

    private IResource[] getResources(ITranslationUnit[] tus) {
        IResource[] res = new IResource[tus.length];
        int i = 0;
        while (i < res.length) {
            res[i] = tus[i].getResource();
            ++i;
        }
        return res;
    }

    public void runOnMultiple(final ITranslationUnit[] tus) {
        try {
            String message = ActionMessages.FormatAllAction_status_description;
            final MultiStatus status = new MultiStatus("org.eclipse.cdt.ui", 0, message, null);
            if (tus.length == 1) {
                EditorUtility.openInEditor(tus[0]);
            }
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    FormatAllAction.this.doRunOnMultiple(tus, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = ActionMessages.FormatAllAction_multi_status_title;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
        catch (InterruptedException e) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
    }

    private static Map<String, Object> getFomatterSettings(ICProject project) {
        return new HashMap<String, Object>(project.getOptions(true));
    }

    private void doFormat(IDocument document, Map<String, Object> options) {
        FormattingContext context = new FormattingContext();
        try {
            context.setProperty((Object)"formatting.context.preferences", options);
            context.setProperty((Object)"formatting.context.document", (Object)true);
            MultiPassContentFormatter formatter = new MultiPassContentFormatter("___c_partitioning", "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)new CFormattingStrategy());
            try {
                this.startSequentialRewriteMode(document);
                formatter.format(document, (IFormattingContext)context);
            }
            finally {
                this.stopSequentialRewriteMode(document);
            }
        }
        finally {
            context.dispose();
        }
    }

    private void startSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            this.fRewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            extension.stopRewriteSession(this.fRewriteSession);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.stopSequentialRewrite();
        }
    }

    private void doRunOnMultiple(ITranslationUnit[] tus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.FormatAllAction_operation_description);
        monitor.beginTask("", tus.length * 4);
        try {
            Map<String, Object> lastOptions = null;
            ICProject lastProject = null;
            int i = 0;
            while (i < tus.length) {
                ITranslationUnit tu = tus[i];
                IPath path = tu.getPath();
                if (lastProject == null || lastOptions == null || !lastProject.equals(tu.getCProject())) {
                    lastProject = tu.getCProject();
                    lastOptions = FormatAllAction.getFomatterSettings(lastProject);
                }
                ILanguage language = null;
                try {
                    language = tu.getLanguage();
                }
                catch (CoreException exc) {
                    language = GPPLanguage.getDefault();
                }
                IWorkingCopy wc = CDTUITools.getWorkingCopyManager().findSharedWorkingCopy(tu);
                if (wc != null) {
                    tu = wc;
                }
                lastOptions.put("org.eclipse.cdt.core.formatter.current_translation_unit", tu);
                lastOptions.put("org.eclipse.cdt.core.formatter.language", language);
                lastOptions.put("org.eclipse.cdt.core.formatter.current_file", tu.getResource());
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                try {
                    try {
                        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        monitor.subTask(path.makeRelative().toString());
                        ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                        boolean wasDirty = fileBuffer.isDirty();
                        this.formatTranslationUnit(fileBuffer, lastOptions);
                        if (fileBuffer.isDirty() && !wasDirty) {
                            fileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 2), false);
                        } else {
                            monitor.worked(2);
                        }
                    }
                    finally {
                        manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void formatTranslationUnit(final ITextFileBuffer fileBuffer, final Map<String, Object> options) {
        if (fileBuffer.isShared()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FormatAllAction.this.doFormat(fileBuffer.getDocument(), options);
                }
            });
        } else {
            this.doFormat(fileBuffer.getDocument(), options);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private FormatAllAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new FormatAllAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }
}

