/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import org.eclipse.core.runtime.Platform;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnection;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.profile.core.PHPProfileCorePlugin;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.messages.GetProfilerCallTraceRequest;
import org.eclipse.php.profile.core.messages.GetProfilerCallTraceResponse;
import org.eclipse.php.profile.core.messages.GetProfilerFileRequest;
import org.eclipse.php.profile.core.messages.GetProfilerFileResponse;
import org.eclipse.php.profile.core.messages.GetProfilerRequest;
import org.eclipse.php.profile.core.messages.GetProfilerResponse;

public class ZRemoteProfiler
extends RemoteDebugger {
    public ZRemoteProfiler(IDebugHandler debugHandler, DebugConnection debugConnection) {
        super(debugHandler, debugConnection);
    }

    public ProfilerGlobalData getProfilerGlobalData() {
        GetProfilerResponse profilerResponse;
        block4: {
            if (!this.isActive()) {
                return null;
            }
            try {
                GetProfilerRequest getProfilerRequest = new GetProfilerRequest();
                profilerResponse = (GetProfilerResponse)((Object)this.getConnection().sendRequest((Object)getProfilerRequest));
                if (profilerResponse != null) break block4;
                return null;
            }
            catch (Exception e) {
                PHPProfileCorePlugin.log(e);
                return null;
            }
        }
        ProfilerGlobalData globalData = profilerResponse.getProfilerGlobalData();
        return globalData;
    }

    public ProfilerFileData getProfilerFileData(int fileNumber) {
        ProfilerFileData fileData;
        GetProfilerFileResponse getProfilerFileResponse;
        block5: {
            if (!this.isActive()) {
                return null;
            }
            GetProfilerFileRequest getProfilerFileRequest = new GetProfilerFileRequest();
            getProfilerFileRequest.setFileNumber(fileNumber);
            getProfilerFileResponse = (GetProfilerFileResponse)((Object)this.getConnection().sendRequest((Object)getProfilerFileRequest));
            if (getProfilerFileResponse != null) break block5;
            return null;
        }
        try {
            fileData = getProfilerFileResponse.getProfilerFileData();
            String localFileName = this.convertToLocalFilename(fileData.getName(), null, null);
            fileData.setLocalName(localFileName);
            ProfilerFunctionData[] functions = fileData.getFunctions();
            int i = 0;
            while (i < functions.length) {
                functions[i].setLocalFileName(localFileName);
                ++i;
            }
        }
        catch (Exception e) {
            PHPProfileCorePlugin.log(e);
            return null;
        }
        return fileData;
    }

    public ProfilerCallTrace getProfilerCallTrace() {
        GetProfilerCallTraceResponse getProfilerCallTraceResponse;
        block4: {
            if (!this.isActive()) {
                return null;
            }
            try {
                GetProfilerCallTraceRequest getProfilerCallTraceRequest = new GetProfilerCallTraceRequest();
                getProfilerCallTraceResponse = (GetProfilerCallTraceResponse)((Object)this.getConnection().sendRequest((Object)getProfilerCallTraceRequest));
                if (getProfilerCallTraceResponse != null) break block4;
                return null;
            }
            catch (Exception e) {
                PHPProfileCorePlugin.log(e);
                return null;
            }
        }
        ProfilerCallTrace callTrace = getProfilerCallTraceResponse.getCallTrace();
        return callTrace;
    }

    public ProfilerData getProfilerData() {
        ProfilerData profilerData = new ProfilerData();
        ProfilerGlobalData profilerGlobalData = this.getProfilerGlobalData();
        if (profilerGlobalData == null) {
            return null;
        }
        profilerGlobalData.setOriginalURL(this.getDebugHandler().getDebugTarget().getURL());
        profilerData.setGlobalData(profilerGlobalData);
        String dummyFile = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, "", null);
        boolean isDummyFiltered = false;
        int fileCount = profilerGlobalData.getFileCount();
        int i = 0;
        while (i < fileCount) {
            ProfilerFileData fileData = this.getProfilerFileData(i);
            if (fileData != null) {
                if (i == 0 && fileData.getName().endsWith(dummyFile)) {
                    isDummyFiltered = true;
                } else {
                    profilerData.addFile(fileData);
                }
            }
            ++i;
        }
        ProfilerCallTrace callTrace = this.getProfilerCallTrace();
        if (callTrace != null) {
            if (isDummyFiltered) {
                callTrace.removeFirstLayer();
            }
            profilerData.setCallTrace(callTrace);
        }
        return profilerData;
    }
}

